/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.deserialization;

import com.dtteam.dynamictrees.deserialization.JsonDeserializers;
import com.dtteam.dynamictrees.deserialization.applier.Applier;
import com.dtteam.dynamictrees.deserialization.applier.PropertyApplier;
import com.dtteam.dynamictrees.deserialization.applier.PropertyApplierResult;
import com.google.gson.JsonElement;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import org.apache.commons.lang3.function.TriFunction;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.Nullable;

public class TagKeyJsonPropertyApplier<K, O, V>
extends PropertyApplier<O, Float, JsonElement> {
    protected final TriFunction<TagKey<K>, O, Float, PropertyApplierResult> tagKeyFunction;
    protected final ResourceKey<? extends Registry<K>> registryKey;

    public TagKeyJsonPropertyApplier(ResourceKey<? extends Registry<K>> registryKey, Class<O> objectClass, TriConsumer<TagKey<K>, O, Float> tagKeyConsumer) {
        this(registryKey, objectClass, (tagKey, o, v) -> {
            tagKeyConsumer.accept(tagKey, o, v);
            return PropertyApplierResult.success();
        });
    }

    public TagKeyJsonPropertyApplier(ResourceKey<? extends Registry<K>> registryKey, Class<O> objectClass, TriFunction<TagKey<K>, O, Float, PropertyApplierResult> tagKeyFunction) {
        super("none", objectClass, (O o, V v) -> {});
        this.tagKeyFunction = tagKeyFunction;
        this.registryKey = registryKey;
    }

    @Override
    @Nullable
    public PropertyApplierResult applyIfShould(String key, Object object, JsonElement input) {
        if (!this.objectClass.isInstance(object)) {
            return null;
        }
        try {
            TagKey tagKey = TagKey.create(this.registryKey, (ResourceLocation)ResourceLocation.parse((String)(key.charAt(0) == '#' ? key.substring(1) : key)));
            return JsonDeserializers.getOrThrow(Float.class).deserialize(input).map(value -> (PropertyApplierResult)this.tagKeyFunction.apply((Object)tagKey, object, value)).orElseApply(PropertyApplierResult::failure, PropertyApplierResult::addWarnings, null);
        }
        catch (ResourceLocationException e) {
            return PropertyApplierResult.failure(e.getMessage());
        }
    }

    @Override
    @Nullable
    protected PropertyApplierResult applyIfShould(O object, JsonElement input, Applier<O, Float> applier) {
        return null;
    }
}

