/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.deserialization.applier;

import com.dtteam.dynamictrees.api.lazyvalue.LazyValue;
import com.dtteam.dynamictrees.deserialization.JsonDeserializers;
import com.dtteam.dynamictrees.deserialization.applier.Applier;
import com.dtteam.dynamictrees.deserialization.applier.PropertyApplier;
import com.dtteam.dynamictrees.deserialization.applier.PropertyApplierResult;
import com.dtteam.dynamictrees.deserialization.deserializer.Deserializer;
import com.dtteam.dynamictrees.deserialization.result.Result;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.jetbrains.annotations.Nullable;

public class ArrayPropertyApplier<T, V, I>
extends PropertyApplier<T, List<V>, I> {
    private final Function<I, Result<Iterator<I>, I>> iteratorDeserialiser;
    private final LazyValue<Deserializer<I, V>> valueDeserialiser;

    public ArrayPropertyApplier(String key, Class<T> objectClass, Applier<T, List<V>> applier, Function<I, Result<Iterator<I>, I>> iteratorDeserialiser, LazyValue<Deserializer<I, V>> valueDeserialiser) {
        super(key, objectClass, applier);
        this.iteratorDeserialiser = iteratorDeserialiser;
        this.valueDeserialiser = valueDeserialiser;
    }

    @Override
    @Nullable
    protected PropertyApplierResult applyIfShould(T object, I input, Applier<T, List<V>> applier) {
        Result<Iterator<I>, I> iteratorResult = this.iteratorDeserialiser.apply(input);
        if (!iteratorResult.success()) {
            return null;
        }
        ArrayList values = new ArrayList();
        Iterator<I> iterator = iteratorResult.get();
        while (iterator.hasNext()) {
            this.valueDeserialiser.get().deserialize(iterator.next()).ifSuccessOrElse(values::add, error -> LogManager.getLogger().error(error), warning -> LogManager.getLogger().warn(warning));
        }
        return applier.apply(object, values);
    }

    public static <T, V> ArrayPropertyApplier<T, V, JsonElement> json(String key, Class<T> objectClass, Class<V> valueClass, Applier<T, List<V>> applier) {
        return new ArrayPropertyApplier<T, V, JsonElement>(key, objectClass, applier, element -> JsonDeserializers.JSON_ARRAY.deserialize(element).map(JsonArray::iterator), LazyValue.supplied(() -> JsonDeserializers.getOrThrow(valueClass)));
    }
}

