/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.deserialization.deserializer;

import com.dtteam.dynamictrees.deserialization.JsonDeserializers;
import com.dtteam.dynamictrees.deserialization.deserializer.JsonDeserializer;
import com.dtteam.dynamictrees.deserialization.result.Result;
import com.google.gson.JsonElement;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.SoundType;

public final class SoundTypeDeserializer
implements JsonDeserializer<SoundType> {
    private static final Map<ResourceLocation, SoundType> SOUND_TYPES = (Map)Util.make(new HashMap(), soundTypes -> {
        soundTypes.put(ResourceLocation.parse((String)"wood"), SoundType.WOOD);
        soundTypes.put(ResourceLocation.parse((String)"gravel"), SoundType.GRAVEL);
        soundTypes.put(ResourceLocation.parse((String)"grass"), SoundType.GRASS);
        soundTypes.put(ResourceLocation.parse((String)"lily_pad"), SoundType.LILY_PAD);
        soundTypes.put(ResourceLocation.parse((String)"stone"), SoundType.STONE);
        soundTypes.put(ResourceLocation.parse((String)"metal"), SoundType.METAL);
        soundTypes.put(ResourceLocation.parse((String)"glass"), SoundType.GLASS);
        soundTypes.put(ResourceLocation.parse((String)"wool"), SoundType.WOOL);
        soundTypes.put(ResourceLocation.parse((String)"sand"), SoundType.SAND);
        soundTypes.put(ResourceLocation.parse((String)"snow"), SoundType.SNOW);
        soundTypes.put(ResourceLocation.parse((String)"ladder"), SoundType.LADDER);
        soundTypes.put(ResourceLocation.parse((String)"anvil"), SoundType.ANVIL);
        soundTypes.put(ResourceLocation.parse((String)"slime_block"), SoundType.SLIME_BLOCK);
        soundTypes.put(ResourceLocation.parse((String)"honey_block"), SoundType.HONEY_BLOCK);
        soundTypes.put(ResourceLocation.parse((String)"wet_grass"), SoundType.WET_GRASS);
        soundTypes.put(ResourceLocation.parse((String)"coral_block"), SoundType.CORAL_BLOCK);
        soundTypes.put(ResourceLocation.parse((String)"bamboo"), SoundType.BAMBOO);
        soundTypes.put(ResourceLocation.parse((String)"bamboo_sapling"), SoundType.BAMBOO_SAPLING);
        soundTypes.put(ResourceLocation.parse((String)"scaffolding"), SoundType.SCAFFOLDING);
        soundTypes.put(ResourceLocation.parse((String)"sweet_berry_bush"), SoundType.SWEET_BERRY_BUSH);
        soundTypes.put(ResourceLocation.parse((String)"crop"), SoundType.CROP);
        soundTypes.put(ResourceLocation.parse((String)"hard_crop"), SoundType.HARD_CROP);
        soundTypes.put(ResourceLocation.parse((String)"vine"), SoundType.VINE);
        soundTypes.put(ResourceLocation.parse((String)"nether_wart"), SoundType.NETHER_WART);
        soundTypes.put(ResourceLocation.parse((String)"lantern"), SoundType.LANTERN);
        soundTypes.put(ResourceLocation.parse((String)"stem"), SoundType.STEM);
        soundTypes.put(ResourceLocation.parse((String)"nylium"), SoundType.NYLIUM);
        soundTypes.put(ResourceLocation.parse((String)"fungus"), SoundType.FUNGUS);
        soundTypes.put(ResourceLocation.parse((String)"roots"), SoundType.ROOTS);
        soundTypes.put(ResourceLocation.parse((String)"shroomlight"), SoundType.SHROOMLIGHT);
        soundTypes.put(ResourceLocation.parse((String)"weeping_vines"), SoundType.WEEPING_VINES);
        soundTypes.put(ResourceLocation.parse((String)"twisting_vines"), SoundType.TWISTING_VINES);
        soundTypes.put(ResourceLocation.parse((String)"soul_sand"), SoundType.SOUL_SAND);
        soundTypes.put(ResourceLocation.parse((String)"soul_soil"), SoundType.SOUL_SOIL);
        soundTypes.put(ResourceLocation.parse((String)"basalt"), SoundType.BASALT);
        soundTypes.put(ResourceLocation.parse((String)"wart_block"), SoundType.WART_BLOCK);
        soundTypes.put(ResourceLocation.parse((String)"netherrack"), SoundType.NETHERRACK);
        soundTypes.put(ResourceLocation.parse((String)"nether_bricks"), SoundType.NETHER_BRICKS);
        soundTypes.put(ResourceLocation.parse((String)"nether_sprouts"), SoundType.NETHER_SPROUTS);
        soundTypes.put(ResourceLocation.parse((String)"nether_ore"), SoundType.NETHER_ORE);
        soundTypes.put(ResourceLocation.parse((String)"bone_block"), SoundType.BONE_BLOCK);
        soundTypes.put(ResourceLocation.parse((String)"netherite_block"), SoundType.NETHERITE_BLOCK);
        soundTypes.put(ResourceLocation.parse((String)"ancient_debris"), SoundType.ANCIENT_DEBRIS);
        soundTypes.put(ResourceLocation.parse((String)"lodestone"), SoundType.LODESTONE);
        soundTypes.put(ResourceLocation.parse((String)"chain"), SoundType.CHAIN);
        soundTypes.put(ResourceLocation.parse((String)"nether_gold_ore"), SoundType.NETHER_GOLD_ORE);
        soundTypes.put(ResourceLocation.parse((String)"gilded_blackstone"), SoundType.GILDED_BLACKSTONE);
        soundTypes.put(ResourceLocation.parse((String)"candle"), SoundType.CANDLE);
        soundTypes.put(ResourceLocation.parse((String)"amethyst"), SoundType.AMETHYST);
        soundTypes.put(ResourceLocation.parse((String)"amethyst_cluster"), SoundType.AMETHYST_CLUSTER);
        soundTypes.put(ResourceLocation.parse((String)"small_amethyst_bud"), SoundType.SMALL_AMETHYST_BUD);
        soundTypes.put(ResourceLocation.parse((String)"medium_amethyst_bud"), SoundType.MEDIUM_AMETHYST_BUD);
        soundTypes.put(ResourceLocation.parse((String)"large_amethyst_bud"), SoundType.LARGE_AMETHYST_BUD);
        soundTypes.put(ResourceLocation.parse((String)"tuff"), SoundType.TUFF);
        soundTypes.put(ResourceLocation.parse((String)"calcite"), SoundType.CALCITE);
        soundTypes.put(ResourceLocation.parse((String)"dripstone_block"), SoundType.DRIPSTONE_BLOCK);
        soundTypes.put(ResourceLocation.parse((String)"pointed_dripstone"), SoundType.POINTED_DRIPSTONE);
        soundTypes.put(ResourceLocation.parse((String)"copper"), SoundType.COPPER);
        soundTypes.put(ResourceLocation.parse((String)"cave_vines"), SoundType.CAVE_VINES);
        soundTypes.put(ResourceLocation.parse((String)"spore_blossom"), SoundType.SPORE_BLOSSOM);
        soundTypes.put(ResourceLocation.parse((String)"azalea"), SoundType.AZALEA);
        soundTypes.put(ResourceLocation.parse((String)"flowering_azalea"), SoundType.FLOWERING_AZALEA);
        soundTypes.put(ResourceLocation.parse((String)"moss_carpet"), SoundType.MOSS_CARPET);
        soundTypes.put(ResourceLocation.parse((String)"moss"), SoundType.MOSS);
        soundTypes.put(ResourceLocation.parse((String)"big_dripleaf"), SoundType.BIG_DRIPLEAF);
        soundTypes.put(ResourceLocation.parse((String)"small_dripleaf"), SoundType.SMALL_DRIPLEAF);
        soundTypes.put(ResourceLocation.parse((String)"rooted_dirt"), SoundType.ROOTED_DIRT);
        soundTypes.put(ResourceLocation.parse((String)"hanging_roots"), SoundType.HANGING_ROOTS);
        soundTypes.put(ResourceLocation.parse((String)"azalea_leaves"), SoundType.AZALEA_LEAVES);
        soundTypes.put(ResourceLocation.parse((String)"sculk_sensor"), SoundType.SCULK_SENSOR);
        soundTypes.put(ResourceLocation.parse((String)"glow_lichen"), SoundType.GLOW_LICHEN);
        soundTypes.put(ResourceLocation.parse((String)"deepslate"), SoundType.DEEPSLATE);
        soundTypes.put(ResourceLocation.parse((String)"deepslate_bricks"), SoundType.DEEPSLATE_BRICKS);
        soundTypes.put(ResourceLocation.parse((String)"deepslate_tiles"), SoundType.DEEPSLATE_TILES);
        soundTypes.put(ResourceLocation.parse((String)"polished_deepslate"), SoundType.POLISHED_DEEPSLATE);
    });

    public static void registerSoundType(ResourceLocation name, SoundType soundType) {
        SOUND_TYPES.putIfAbsent(name, soundType);
    }

    @Override
    public Result<SoundType, JsonElement> deserialize(JsonElement input) {
        return JsonDeserializers.RESOURCE_LOCATION.deserialize(input).map(SOUND_TYPES::get, "Could not get sound type from \"{}\".");
    }
}

