/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.model;

import com.dtteam.dynamictrees.api.network.RootConnections;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.client.RenderTypeGroup;
import net.neoforged.neoforge.client.model.IModelBuilder;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import net.neoforged.neoforge.client.model.geometry.IGeometryBakingContext;
import org.joml.Vector3f;

public class ModelHelper {
    public static final ModelProperty<RootConnections> ROOT_CONNECTIONS_PROPERTY = new ModelProperty();

    public static float[] getUVs(AABB box, Direction face) {
        float[] fArray;
        switch (face) {
            default: {
                float[] fArray2 = new float[4];
                fArray2[0] = (float)box.minX;
                fArray2[1] = 16.0f - (float)box.minZ;
                fArray2[2] = (float)box.maxX;
                fArray = fArray2;
                fArray2[3] = 16.0f - (float)box.maxZ;
                break;
            }
            case UP: {
                float[] fArray3 = new float[4];
                fArray3[0] = (float)box.minX;
                fArray3[1] = (float)box.minZ;
                fArray3[2] = (float)box.maxX;
                fArray = fArray3;
                fArray3[3] = (float)box.maxZ;
                break;
            }
            case NORTH: {
                float[] fArray4 = new float[4];
                fArray4[0] = 16.0f - (float)box.maxX;
                fArray4[1] = (float)box.minY;
                fArray4[2] = 16.0f - (float)box.minX;
                fArray = fArray4;
                fArray4[3] = (float)box.maxY;
                break;
            }
            case SOUTH: {
                float[] fArray5 = new float[4];
                fArray5[0] = (float)box.minX;
                fArray5[1] = (float)box.minY;
                fArray5[2] = (float)box.maxX;
                fArray = fArray5;
                fArray5[3] = (float)box.maxY;
                break;
            }
            case WEST: {
                float[] fArray6 = new float[4];
                fArray6[0] = (float)box.minZ;
                fArray6[1] = (float)box.minY;
                fArray6[2] = (float)box.maxZ;
                fArray = fArray6;
                fArray6[3] = (float)box.maxY;
                break;
            }
            case EAST: {
                float[] fArray7 = new float[4];
                fArray7[0] = 16.0f - (float)box.maxZ;
                fArray7[1] = (float)box.minY;
                fArray7[2] = 16.0f - (float)box.minZ;
                fArray = fArray7;
                fArray7[3] = (float)box.maxY;
            }
        }
        return fArray;
    }

    public static int getFaceAngle(Direction.Axis axis, Direction face) {
        if (axis == Direction.Axis.Y) {
            return 0;
        }
        if (axis == Direction.Axis.Z) {
            return switch (face) {
                case Direction.UP -> 0;
                case Direction.NORTH, Direction.WEST -> 270;
                case Direction.DOWN -> 180;
                default -> 90;
            };
        }
        return face == Direction.NORTH ? 270 : 90;
    }

    public static float[] modUV(float[] uvs) {
        uvs[0] = (int)uvs[0] & 0xF;
        uvs[1] = (int)uvs[1] & 0xF;
        uvs[2] = ((int)uvs[2] - 1 & 0xF) + 1;
        uvs[3] = ((int)uvs[3] - 1 & 0xF) + 1;
        return uvs;
    }

    public static Vector3f[] AABBLimits(AABB aabb) {
        return new Vector3f[]{new Vector3f((float)aabb.minX, (float)aabb.minY, (float)aabb.minZ), new Vector3f((float)aabb.maxX, (float)aabb.maxY, (float)aabb.maxZ)};
    }

    public static BakedQuad makeBakedQuad(BlockElement blockPart, BlockElementFace partFace, TextureAtlasSprite atlasSprite, Direction dir, BlockModelRotation modelRotation) {
        return new FaceBakery().bakeQuad(blockPart.from, blockPart.to, partFace, atlasSprite, dir, (ModelState)modelRotation, blockPart.rotation, true);
    }

    public static IModelBuilder<?> getModelBuilder(IGeometryBakingContext context, TextureAtlasSprite particle) {
        ResourceLocation renderTypeHint = context.getRenderTypeHint();
        RenderTypeGroup renderTypes = renderTypeHint != null ? context.getRenderType(renderTypeHint) : RenderTypeGroup.EMPTY;
        return IModelBuilder.of((boolean)context.useAmbientOcclusion(), (boolean)context.useBlockLight(), (boolean)context.isGui3d(), (ItemTransforms)context.getTransforms(), (ItemOverrides)ItemOverrides.EMPTY, (TextureAtlasSprite)particle, (RenderTypeGroup)renderTypes);
    }

    public static TextureAtlasSprite getTexture(ResourceLocation resLoc) {
        return ModelHelper.getTexture(resLoc, TextureAtlas.LOCATION_BLOCKS);
    }

    public static TextureAtlasSprite getTexture(ResourceLocation resLoc, ResourceLocation atlasResLoc) {
        return (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(atlasResLoc).apply(resLoc);
    }
}

