/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.systems;

import com.dtteam.dynamictrees.tree.species.Species;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;

public class GrowSignal {
    public float energy;
    public Direction dir;
    public int numTurns;
    public int numSteps;
    private final Species species;
    public final Direction defaultDir;
    public BlockPos rootPos;
    public BlockPos delta;
    public float radius;
    public float tapering;
    public boolean success;
    public boolean choked;
    public RandomSource rand;

    public GrowSignal(Species species, BlockPos rootPos, float energy, RandomSource random) {
        this(species, rootPos, energy, random, Direction.UP);
    }

    public GrowSignal(Species species, BlockPos rootPos, float energy, RandomSource random, Direction defaultDir) {
        this.species = species;
        this.energy = energy;
        this.defaultDir = defaultDir;
        this.dir = defaultDir;
        this.radius = 0.0f;
        this.numTurns = 0;
        this.numSteps = 0;
        this.tapering = 0.3f;
        this.rand = random;
        this.success = true;
        this.choked = false;
        this.rootPos = rootPos;
        this.delta = new BlockPos(0, 0, 0);
    }

    public Species getSpecies() {
        return this.species;
    }

    public boolean step() {
        float f;
        ++this.numSteps;
        this.delta = this.delta.relative(this.dir);
        this.energy -= 1.0f;
        if (f <= 0.0f) {
            this.success = false;
        }
        return this.success;
    }

    public boolean doTurn(Direction targetDir) {
        if (this.dir != targetDir) {
            this.dir = targetDir;
            ++this.numTurns;
            return true;
        }
        return false;
    }

    public boolean isInTrunk() {
        return this.numTurns == 0;
    }
}

