/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.systems.poissondisc;

import com.dtteam.dynamictrees.api.worldgen.LevelContext;
import com.dtteam.dynamictrees.api.worldgen.PoissonDiscProvider;
import com.dtteam.dynamictrees.systems.poissondisc.LevelPoissonDiscProvider;
import com.dtteam.dynamictrees.systems.poissondisc.PoissonDisc;
import com.dtteam.dynamictrees.worldgen.BiomeRadiusCoordinator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;

public class UniversalPoissonDiscProvider {
    public static final String CIRCLE_DATA_ID = "GTCD";
    private final Map<ResourceLocation, PoissonDiscProvider> providerMap = new ConcurrentHashMap<ResourceLocation, PoissonDiscProvider>();

    protected PoissonDiscProvider createCircleProvider(LevelContext levelContext) {
        BiomeRadiusCoordinator radiusCoordinator = new BiomeRadiusCoordinator(levelContext.dimensionName(), levelContext.accessor());
        return new LevelPoissonDiscProvider(radiusCoordinator).setSeed(levelContext.seed());
    }

    public PoissonDiscProvider getProvider(LevelContext levelContext) {
        return this.providerMap.computeIfAbsent(levelContext.dimensionName(), k -> this.createCircleProvider(levelContext));
    }

    public List<PoissonDisc> getPoissonDiscs(LevelContext levelContext, ChunkPos chunkPos) {
        PoissonDiscProvider provider = this.getProvider(levelContext);
        return provider.getPoissonDiscs(chunkPos.x, 0, chunkPos.z);
    }

    public void unloadWorld(ServerLevel level) {
        this.providerMap.remove(level.dimension().location());
    }

    public void setChunkPoissonData(LevelContext levelContext, ChunkPos chunkPos, byte[] circleData) {
        this.getProvider(levelContext).setChunkPoissonData(chunkPos.x, 0, chunkPos.z, circleData);
    }

    public byte[] getChunkPoissonData(LevelContext levelContext, ChunkPos chunkPos) {
        return this.getProvider(levelContext).getChunkPoissonData(chunkPos.x, 0, chunkPos.z);
    }

    public void unloadChunkPoissonData(LevelContext levelContext, ChunkPos chunkPos) {
        this.getProvider(levelContext).unloadChunkPoissonData(chunkPos.x, 0, chunkPos.z);
    }
}

