/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.api.configuration;

import com.dtteam.dynamictrees.api.configuration.ConfigurationProperty;
import com.dtteam.dynamictrees.api.configuration.PropertiesAccessor;
import com.google.common.collect.Maps;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public final class Properties
implements PropertiesAccessor {
    public static final Properties NONE = new Properties();
    private final Map<ConfigurationProperty<?>, Object> map = Maps.newHashMap();

    public <V> void put(ConfigurationProperty<V> property, @Nullable V value) {
        this.map.put(property, value);
    }

    public void putAll(PropertiesAccessor properties) {
        properties.forEach(this::put);
    }

    @Override
    @Nullable
    public <V> V get(ConfigurationProperty<V> property) {
        return (V)this.map.get(property);
    }

    @Override
    public boolean has(ConfigurationProperty<?> property) {
        return this.map.containsKey(property);
    }

    @Override
    public void forEach(PropertiesAccessor.IterationAction<?> action) {
        this.map.forEach((? super K property, ? super V value) -> this.applyIteration(action, (ConfigurationProperty<?>)property, value));
    }

    private <V> void applyIteration(PropertiesAccessor.IterationAction<V> action, ConfigurationProperty<?> property, Object value) {
        action.apply(property, value);
    }

    public String toString() {
        return this.map.toString();
    }
}

