/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.block.fruit;

import com.dtteam.dynamictrees.DynamicTrees;
import com.dtteam.dynamictrees.api.lazyvalue.LazyValue;
import com.dtteam.dynamictrees.api.registry.RegistryEntry;
import com.dtteam.dynamictrees.api.registry.RegistryHandler;
import com.dtteam.dynamictrees.api.registry.TypedRegistry;
import com.dtteam.dynamictrees.api.worldgen.LevelContext;
import com.dtteam.dynamictrees.block.DynamicBlockProperties;
import com.dtteam.dynamictrees.block.Growable;
import com.dtteam.dynamictrees.block.fruit.FruitBlock;
import com.dtteam.dynamictrees.data.DTLootTableBuilder;
import com.dtteam.dynamictrees.platform.Services;
import com.dtteam.dynamictrees.systems.season.SeasonHelper;
import com.dtteam.dynamictrees.treepack.Resettable;
import com.dtteam.dynamictrees.utility.ResourceLocationUtils;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.logging.log4j.LogManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Fruit
extends RegistryEntry<Fruit>
implements Resettable<Fruit> {
    public static final TypedRegistry.EntryType<Fruit> TYPE = TypedRegistry.newType(Fruit::new);
    public static final Fruit NULL = new Fruit(DynamicTrees.NULL);
    public static final TypedRegistry<Fruit> REGISTRY = new TypedRegistry<Fruit>(Fruit.class, NULL, TYPE);
    private Supplier<FruitBlock> block;
    private int maxAge = 3;
    private IntegerProperty ageProperty = BlockStateProperties.AGE_3;
    private VoxelShape[] blockShapes = new VoxelShape[]{Shapes.block(), Shapes.block(), Shapes.block(), Shapes.block()};
    private boolean canBoneMeal;
    private ItemStack itemStack;
    private float growthChance = 0.2f;
    @Nullable
    private Float seasonOffset = Float.valueOf(0.0f);
    private float flowerHoldPeriodLength = 0.5f;
    private float minProductionFactor = 0.3f;
    private Growable.MatureAction matureAction = Growable.MatureAction.DEFAULT;
    private int minDropCount = 1;
    private int maxDropCount = 1;
    private final LazyValue<ResourceLocation> blockDropsPath = LazyValue.supplied(() -> ResourceLocationUtils.prefix(BuiltInRegistries.BLOCK.getKey((Object)this.block.get()), "blocks/"));

    public Fruit(ResourceLocation registryName) {
        super(registryName);
    }

    public final FruitBlock getBlock() {
        if (this.block == null) {
            throw new IllegalStateException("Invoked too early (before the block was created).");
        }
        return this.block.get();
    }

    public final void createBlock(@Nullable ResourceLocation name, BlockBehaviour.Properties properties) {
        this.block = RegistryHandler.addBlock(name == null ? this.getRegistryName() : name, () -> this.createBlock(properties));
    }

    protected FruitBlock createBlock(BlockBehaviour.Properties properties) {
        return new FruitBlock(properties, this);
    }

    public MapColor getDefaultMapColor() {
        return MapColor.PLANT;
    }

    public BlockBehaviour.Properties getDefaultBlockProperties() {
        return this.getDefaultBlockProperties(this.getDefaultMapColor());
    }

    public BlockBehaviour.Properties getDefaultBlockProperties(MapColor mapColor) {
        return BlockBehaviour.Properties.of().mapColor(mapColor).noCollission().sound(SoundType.CROP).randomTicks().strength(0.3f);
    }

    public final IntegerProperty getAgeProperty() {
        return this.ageProperty;
    }

    public final int getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(int maxAge) {
        this.maxAge = maxAge;
        this.ageProperty = DynamicBlockProperties.getOrCreateAge(maxAge);
    }

    public void setDropCount(int dropCount) {
        this.setMaxDropCount(dropCount);
        this.setMinDropCount(dropCount);
    }

    public void setMaxDropCount(int maxDropCount) {
        this.maxDropCount = maxDropCount;
    }

    public void setMinDropCount(int minDropCount) {
        this.minDropCount = minDropCount;
    }

    public final VoxelShape getBlockShape(int age) {
        return this.blockShapes[age];
    }

    public void setBlockShapes(VoxelShape[] blockShapes) {
        if (blockShapes.length <= this.maxAge) {
            throw new IllegalArgumentException("Insufficient number of block shapes provided for the maximum age " + this.maxAge + " on fruit " + String.valueOf(this));
        }
        this.blockShapes = blockShapes;
    }

    public final boolean canBoneMeal() {
        return this.canBoneMeal;
    }

    public void setCanBoneMeal(boolean canBoneMeal) {
        this.canBoneMeal = canBoneMeal;
    }

    public final ItemStack getItemStack() {
        if (this.itemStack == null) {
            LogManager.getLogger().warn("Invoked too early or item was not set on \"{}\".", (Object)this.getRegistryName());
            return new ItemStack((ItemLike)Items.AIR);
        }
        return this.itemStack.copy();
    }

    public void setItemStack(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    public final float getGrowthChance() {
        return this.growthChance;
    }

    public void setGrowthChance(float growthChance) {
        this.growthChance = growthChance;
    }

    public final boolean isInFlowerHoldPeriod(LevelAccessor level, BlockPos rootPos, Float seasonValue) {
        if (this.seasonOffset == null) {
            return false;
        }
        Float peakSeasonValue = SeasonHelper.getSeasonManager().getPeakFruitProductionSeasonValue(LevelContext.create(level).level(), rootPos, this.seasonOffset.floatValue());
        if (peakSeasonValue == null || this.flowerHoldPeriodLength == 0.0f) {
            return false;
        }
        float min = peakSeasonValue.floatValue() - 1.5f;
        float max = min + this.flowerHoldPeriodLength;
        return SeasonHelper.isSeasonBetween(seasonValue, min, max);
    }

    @Nullable
    public final Float getSeasonOffset() {
        return this.seasonOffset;
    }

    public void setSeasonOffset(@Nullable Float offset) {
        this.seasonOffset = offset;
    }

    public float seasonalFruitProductionFactor(LevelContext levelContext, BlockPos pos) {
        return this.seasonOffset != null ? SeasonHelper.globalSeasonalFruitProductionFactor(levelContext, pos, -this.seasonOffset.floatValue(), false) : 1.0f;
    }

    public float getFlowerHoldPeriodLength() {
        return this.flowerHoldPeriodLength;
    }

    public void setFlowerHoldPeriodLength(float flowerHoldPeriodLength) {
        this.flowerHoldPeriodLength = flowerHoldPeriodLength;
    }

    public final float getMinProductionFactor() {
        return this.minProductionFactor;
    }

    public void setMinProductionFactor(float minProductionFactor) {
        this.minProductionFactor = minProductionFactor;
    }

    public boolean isOutOfSeason(Level level, BlockPos pos) {
        return this.seasonalFruitProductionFactor(LevelContext.create((LevelAccessor)level), pos) < this.minProductionFactor;
    }

    public void place(LevelAccessor level, BlockPos pos, @Nullable Float seasonValue) {
        BlockState state = this.getStateForAge(0);
        level.setBlock(pos, state, 3);
    }

    public void placeDuringWorldGen(LevelAccessor level, BlockPos pos, @Nullable Float seasonValue) {
        BlockState state = this.getStateForAge(this.getAgeForWorldGen(level, pos, seasonValue));
        level.setBlock(pos, state, 3);
    }

    protected BlockState getStateForAge(int age) {
        if (age < 0) {
            throw new IllegalArgumentException("Cannot get state for negative fruit age.");
        }
        if (age > this.maxAge) {
            throw new IllegalArgumentException("Cannot get state for age " + age + " as it is greater than maximum " + this.maxAge + " for fruit \"" + String.valueOf(this.getRegistryName()) + "\".");
        }
        return (BlockState)this.block.get().defaultBlockState().setValue((Property)this.ageProperty, (Comparable)Integer.valueOf(age));
    }

    protected int getAgeForWorldGen(LevelAccessor level, BlockPos pos, @Nullable Float seasonValue) {
        if (seasonValue != null && this.isInFlowerHoldPeriod(level, pos, seasonValue)) {
            return 0;
        }
        return Math.min(level.getRandom().nextInt(this.maxAge * 2), this.maxAge);
    }

    public void performMatureAction(Growable.Info blockInfo) {
        this.matureAction.perform(this.block.get(), blockInfo);
    }

    public Growable.MatureAction getMatureAction() {
        return this.matureAction;
    }

    public void setMatureAction(Growable.MatureAction matureAction) {
        this.matureAction = matureAction;
    }

    public boolean shouldGenerateBlockDrops() {
        return true;
    }

    public ResourceLocation getBlockDropsPath() {
        return this.blockDropsPath.get();
    }

    public LootTable.Builder createBlockDrops(HolderLookup.Provider registries) {
        if (this.minDropCount > this.maxDropCount || this.maxDropCount <= 0) {
            throw new IllegalArgumentException("Attempted to create loot tables for " + String.valueOf(this.getRegistryName()) + " with an invalid drop count range [" + this.minDropCount + "," + this.maxDropCount + "].");
        }
        return DTLootTableBuilder.createFruitPodDrops(this.block.get(), this.getItemStack().getItem(), this.ageProperty, this.maxAge, this.minDropCount, this.maxDropCount, registries);
    }

    @Override
    @NotNull
    public Fruit reset() {
        this.canBoneMeal = Services.CONFIG.isServerConfigLoaded() && Services.CONFIG.getBoolConfig("canBoneMealFruit") != false;
        this.seasonOffset = Float.valueOf(0.0f);
        this.flowerHoldPeriodLength = 0.5f;
        this.minProductionFactor = 0.3f;
        this.matureAction = Growable.MatureAction.DEFAULT;
        return this;
    }
}

