/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.compat;

import com.dtteam.dynamictrees.DynamicTrees;
import com.dtteam.dynamictrees.item.DendroPotion;
import com.dtteam.dynamictrees.recipe.DendroPotionRecipeHandler;
import com.dtteam.dynamictrees.registry.DTRegistries;
import java.util.ArrayList;
import java.util.Collections;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.vanilla.IJeiBrewingRecipe;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

@JeiPlugin
public final class DTJeiPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return DynamicTrees.location("dynamictrees");
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter((Item)DTRegistries.DENDRO_POTION.get(), (ISubtypeInterpreter)new DendroSubtypeInterpreter());
    }

    public void registerRecipes(IRecipeRegistration registration) {
        IVanillaRecipeFactory factory = registration.getVanillaRecipeFactory();
        ArrayList brewingRecipes = new ArrayList();
        DendroPotionRecipeHandler.getAllDendroRecipes().forEach(recipe -> brewingRecipes.add(DTJeiPlugin.makeJeiBrewingRecipe(factory, recipe.input(), recipe.ingredient(), recipe.output())));
        registration.addRecipes(RecipeTypes.BREWING, brewingRecipes);
    }

    private static IJeiBrewingRecipe makeJeiBrewingRecipe(IVanillaRecipeFactory factory, ItemStack inputStack, ItemStack ingredientStack, ItemStack output) {
        return factory.createBrewingRecipe(Collections.singletonList(ingredientStack), inputStack, output);
    }

    static final class DendroSubtypeInterpreter
    implements ISubtypeInterpreter<ItemStack> {
        DendroSubtypeInterpreter() {
        }

        @Nullable
        public Object getSubtypeData(ItemStack itemStack, UidContext uidContext) {
            if (itemStack.getItem() instanceof DendroPotion) {
                return DendroPotion.getPotionType(itemStack);
            }
            return null;
        }

        public String getLegacyStringSubtypeInfo(ItemStack itemStack, UidContext uidContext) {
            if (itemStack.getItem() instanceof DendroPotion) {
                return DendroPotion.getPotionType(itemStack).getName();
            }
            return "";
        }
    }
}

