/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.data.generator;

import com.dtteam.dynamictrees.DynamicTrees;
import com.dtteam.dynamictrees.block.soil.AerialRootsSoilProperties;
import com.dtteam.dynamictrees.block.soil.SoilProperties;
import com.dtteam.dynamictrees.data.DTDataProvider;
import com.dtteam.dynamictrees.data.Generator;
import com.dtteam.dynamictrees.data.generator.SoilStateGenerator;
import com.dtteam.dynamictrees.data.provider.DTBlockStateProvider;
import com.dtteam.dynamictrees.utility.ResourceLocationUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.VariantBlockStateBuilder;

public final class AerialRootSoilGenerator
extends SoilStateGenerator {
    public static final Generator.DependencyKey<Block> ROOTS = new Generator.DependencyKey("roots");

    @Override
    public void generate(DTDataProvider.BlockState prov, SoilProperties input, Generator.Dependencies dependencies) {
        if (prov instanceof DTBlockStateProvider) {
            DTBlockStateProvider provider = (DTBlockStateProvider)prov;
            VariantBlockStateBuilder builder = provider.getVariantBuilder((Block)dependencies.get(SOIL));
            for (int i = 1; i <= 8; ++i) {
                builder = (VariantBlockStateBuilder)builder.partialState().with((Property)AerialRootsSoilProperties.RootSoilBlock.RADIUS, (Comparable)Integer.valueOf(i)).modelForState().modelFile((ModelFile)this.soilModelBuilder(provider, input, i, provider.blockTexture((Block)dependencies.get(SOIL)).getPath(), (Block)dependencies.get(PRIMITIVE_SOIL), dependencies.get(ROOTS))).addModel();
            }
        }
    }

    @Override
    public Generator.Dependencies gatherDependencies(SoilProperties input) {
        AerialRootsSoilProperties aerialInput = (AerialRootsSoilProperties)input;
        return new Generator.Dependencies().append(SOIL, input.getBlock()).append(PRIMITIVE_SOIL, input.getPrimitiveSoilBlockOptional()).append(ROOTS, aerialInput.getFamily().getPrimitiveRoots());
    }

    private BlockModelBuilder soilModelBuilder(BlockStateProvider provider, SoilProperties input, int radius, String name, Block primitiveBlock, Block roots) {
        AerialRootsSoilProperties aerialInput = (AerialRootsSoilProperties)input;
        ResourceLocation side = aerialInput.getFamily().getTexturePath("branch").orElse(provider.blockTexture(primitiveBlock));
        ResourceLocation top = aerialInput.getFamily().getTexturePath("branch_top").orElse(ResourceLocationUtils.suffix(provider.blockTexture(primitiveBlock), "_top"));
        ResourceLocation roots_side = aerialInput.getFamily().getTexturePath("roots_side").orElse(ResourceLocationUtils.suffix(provider.blockTexture(roots), "_side"));
        ResourceLocation roots_top = aerialInput.getFamily().getTexturePath("roots_side").orElse(ResourceLocationUtils.suffix(provider.blockTexture(roots), "_top"));
        BlockModelBuilder builder = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)provider.models().withExistingParent(name + "_radius" + radius, DynamicTrees.location("block/smartmodel/rooty/aerial_roots_radius" + radius))).texture("side", side)).texture("end", top)).texture("overlay", roots_side)).texture("overlay_end", roots_top);
        input.getTexturePath("roots").ifPresent(r -> builder.texture("roots", r));
        return builder;
    }
}

