/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.data.generator;

import com.dtteam.dynamictrees.block.sapling.DynamicSaplingBlock;
import com.dtteam.dynamictrees.data.DTDataProvider;
import com.dtteam.dynamictrees.data.Generator;
import com.dtteam.dynamictrees.data.provider.DTBlockStateProvider;
import com.dtteam.dynamictrees.tree.species.Species;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;

public class SaplingStateGenerator
implements Generator<DTDataProvider.BlockState, Species> {
    public static final Generator.DependencyKey<DynamicSaplingBlock> SAPLING = new Generator.DependencyKey("sapling");
    public static final Generator.DependencyKey<Block> PRIMITIVE_LOG = new Generator.DependencyKey("primitive_log");
    public static final Generator.DependencyKey<Block> PRIMITIVE_LEAVES = new Generator.DependencyKey("primitive_leaves", true);

    @Override
    public void generate(DTDataProvider.BlockState prov, Species input, Generator.Dependencies dependencies) {
        if (prov instanceof DTBlockStateProvider) {
            DTBlockStateProvider provider = (DTBlockStateProvider)prov;
            Optional<ResourceLocation> leavesTextureLocation = dependencies.getOptional(PRIMITIVE_LEAVES).map(primitiveLeaves -> provider.block(Objects.requireNonNull(BuiltInRegistries.BLOCK.getKey(primitiveLeaves))));
            ResourceLocation primitiveLogLocation = Objects.requireNonNull(BuiltInRegistries.BLOCK.getKey((Object)dependencies.get(PRIMITIVE_LOG)));
            BlockModelBuilder builder = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)provider.models().getBuilder(input.getSaplingModelName())).parent((ModelFile)provider.models().getExistingFile(input.getSaplingSmartModelLocation()))).renderType("cutout_mipped");
            input.addSaplingTextures((arg_0, arg_1) -> ((BlockModelBuilder)builder).texture(arg_0, arg_1), leavesTextureLocation.orElse(primitiveLogLocation), provider.block(primitiveLogLocation));
            provider.simpleBlock(dependencies.get(SAPLING), (ModelFile)builder);
        }
    }

    @Override
    public Generator.Dependencies gatherDependencies(Species input) {
        return new Generator.Dependencies().append(SAPLING, input.getSapling()).append(PRIMITIVE_LOG, input.getFamily().getPrimitiveLog()).append(PRIMITIVE_LEAVES, input.getPrimitiveLeaves());
    }
}

