/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.entity;

import com.dtteam.dynamictrees.api.substance.SubstanceEffect;
import com.dtteam.dynamictrees.block.soil.SoilBlock;
import com.dtteam.dynamictrees.systems.substance.LingeringSubstances;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class LingeringEffectorEntity
extends Entity {
    public static final EntityDataAccessor<CompoundTag> effectorDataParameter = SynchedEntityData.defineId(LingeringEffectorEntity.class, (EntityDataSerializer)EntityDataSerializers.COMPOUND_TAG);
    private BlockPos blockPos;
    private SubstanceEffect effect;
    protected boolean clientBuilt = false;
    private byte invalidTicks = 0;

    public LingeringEffectorEntity(EntityType<? extends LingeringEffectorEntity> entityTypeIn, Level level) {
        super(entityTypeIn, level);
    }

    public void setData(Level level, BlockPos pos, SubstanceEffect effect) {
        this.noPhysics = true;
        this.setBlockPos(pos);
        this.effect = effect;
        if (this.effect != null) {
            for (LingeringEffectorEntity effector : level.getEntitiesOfClass(LingeringEffectorEntity.class, new AABB(pos))) {
                if (effector.getEffect() == null || !effector.getEffect().getName().equals(effect.getName())) continue;
                effector.kill();
            }
        }
        this.setEffectorData(this.buildEffectorData(pos, effect));
    }

    public static boolean treeHasEffectorForEffect(LevelAccessor level, BlockPos pos, SubstanceEffect effect) {
        for (LingeringEffectorEntity effector : level.getEntitiesOfClass(LingeringEffectorEntity.class, new AABB(pos))) {
            if (effector.getEffect() == null || !effector.getEffect().getName().equals(effect.getName())) continue;
            return true;
        }
        return false;
    }

    public void setBlockPos(BlockPos pos) {
        this.blockPos = pos;
        this.setPos((double)this.blockPos.getX() + 0.5, this.blockPos.getY(), (double)this.blockPos.getZ() + 0.5);
    }

    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    public SubstanceEffect getEffect() {
        return this.effect;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(effectorDataParameter, (Object)new CompoundTag());
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        CompoundTag effector = (CompoundTag)tag.get("effector");
        if (effector != null) {
            this.setEffectorData(effector);
        }
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        tag.put("effector", (Tag)this.getEffectorData());
    }

    public CompoundTag buildEffectorData(BlockPos pos, @Nullable SubstanceEffect substance) {
        CompoundTag tag = new CompoundTag();
        tag.putInt("posx", pos.getX());
        tag.putInt("posy", pos.getY());
        tag.putInt("posz", pos.getZ());
        tag.putInt("effect", substance == null ? 0 : LingeringSubstances.indexOf(substance.getClass()));
        return tag;
    }

    public void setEffectorData(CompoundTag tag) {
        this.blockPos = new BlockPos(tag.getInt("posx"), tag.getInt("posy"), tag.getInt("posz"));
        this.effect = (SubstanceEffect)LingeringSubstances.fromIndex(tag.getInt("effect")).get();
        this.getEntityData().set(effectorDataParameter, (Object)tag);
    }

    public CompoundTag getEffectorData() {
        return (CompoundTag)this.getEntityData().get(effectorDataParameter);
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide() && !this.clientBuilt) {
            this.setEffectorData(this.getEffectorData());
            this.clientBuilt = true;
        }
        if (this.effect == null) {
            this.invalidTicks = (byte)(this.invalidTicks + 1);
            if (this.invalidTicks > 20) {
                this.kill();
            }
            return;
        }
        if (this.blockPos == null) {
            return;
        }
        BlockState blockState = this.level().getBlockState(this.blockPos);
        if (blockState.getBlock() instanceof SoilBlock) {
            if (!this.effect.update(this.level(), this.blockPos, this.tickCount, (Integer)blockState.getValue((Property)SoilBlock.FERTILITY))) {
                this.kill();
            }
        } else {
            this.kill();
        }
    }
}

