/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.model;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class QuadManipulator {
    public static final Direction[] everyFace = new Direction[]{Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST, null};

    public static List<BakedQuad> getQuads(BakedModel modelIn, BlockState stateIn, Vec3 offset, RandomSource rand, ModelData modelData) {
        return QuadManipulator.getQuads(modelIn, stateIn, offset, everyFace, rand, modelData);
    }

    public static List<BakedQuad> getQuads(BakedModel modelIn, BlockState stateIn, Vec3 offset, Direction[] sides, RandomSource rand, ModelData modelData) {
        ArrayList<BakedQuad> outQuads = new ArrayList<BakedQuad>();
        if (stateIn != null) {
            for (Direction dir : sides) {
                outQuads.addAll(modelIn.getQuads(stateIn, dir, rand, modelData, null));
            }
        }
        return offset.equals((Object)Vec3.ZERO) ? outQuads : QuadManipulator.moveQuads(outQuads, offset);
    }

    public static List<BakedQuad> moveQuads(List<BakedQuad> inQuads, Vec3 offset) {
        ArrayList<BakedQuad> outQuads = new ArrayList<BakedQuad>();
        for (BakedQuad inQuad : inQuads) {
            BakedQuad quadCopy = new BakedQuad((int[])inQuad.getVertices().clone(), inQuad.getTintIndex(), inQuad.getDirection(), inQuad.getSprite(), inQuad.isShade());
            int[] vertexData = quadCopy.getVertices();
            block1: for (int i = 0; i < vertexData.length; i += DefaultVertexFormat.BLOCK.getVertexSize() / 4) {
                int pos = 0;
                for (VertexFormatElement vfe : DefaultVertexFormat.BLOCK.getElements()) {
                    if (vfe.usage() == VertexFormatElement.Usage.POSITION) {
                        float x = Float.intBitsToFloat(vertexData[i + pos + 0]);
                        float y = Float.intBitsToFloat(vertexData[i + pos + 1]);
                        float z = Float.intBitsToFloat(vertexData[i + pos + 2]);
                        vertexData[i + pos + 0] = Float.floatToIntBits(x += (float)offset.x);
                        vertexData[i + pos + 1] = Float.floatToIntBits(y += (float)offset.y);
                        vertexData[i + pos + 2] = Float.floatToIntBits(z += (float)offset.z);
                        continue block1;
                    }
                    pos += vfe.byteSize() / 4;
                }
            }
            outQuads.add(quadCopy);
        }
        outQuads.trimToSize();
        return outQuads;
    }

    @Nullable
    public static BakedModel getModelForState(BlockState state) {
        BakedModel model = null;
        try {
            model = QuadManipulator.getModel(state);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return model;
    }

    public static ModelManager getModelManager() {
        return Minecraft.getInstance().getModelManager();
    }

    public static BakedModel getModel(BlockState state) {
        return Minecraft.getInstance().getBlockRenderer().getBlockModel(state);
    }

    @Nullable
    public static ResourceLocation getModelTexture(BakedModel model, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter, BlockState state, Direction dir) {
        float[] uvs = QuadManipulator.getSpriteUVFromBlockState(state, dir);
        if (uvs != null) {
            ArrayList<TextureAtlasSprite> sprites = new ArrayList<TextureAtlasSprite>();
            float closest = Float.POSITIVE_INFINITY;
            ResourceLocation closestTex = ResourceLocation.parse((String)"missingno");
            if (model != null) {
                ResourceLocation tex = model.getParticleIcon(ModelData.EMPTY).contents().name();
                TextureAtlasSprite tas = bakedTextureGetter.apply(tex);
                float u = tas.getU(8.0f);
                float v = tas.getV(8.0f);
                sprites.add(tas);
                float du = u - uvs[0];
                float dv = v - uvs[1];
                float distSq = du * du + dv * dv;
                if (distSq < closest) {
                    closest = distSq;
                    closestTex = tex;
                }
            }
            return closestTex;
        }
        return null;
    }

    @Nullable
    public static float[] getSpriteUVFromBlockState(BlockState state, Direction side) {
        BakedModel bakedModel = QuadManipulator.getModelManager().getBlockModelShaper().getBlockModel(state);
        ArrayList quads = new ArrayList();
        RandomSource random = RandomSource.create();
        quads.addAll(bakedModel.getQuads(state, side, random, ModelData.EMPTY, null));
        quads.addAll(bakedModel.getQuads(state, null, random, ModelData.EMPTY, null));
        Optional<BakedQuad> quad = quads.stream().filter(q -> q.getDirection() == side).findFirst();
        if (quad.isPresent()) {
            float u = 0.0f;
            float v = 0.0f;
            int[] vertexData = quad.get().getVertices();
            int numVertices = 0;
            for (int i = 0; i < vertexData.length; i += DefaultVertexFormat.BLOCK.getVertexSize() / 4) {
                int pos = 0;
                for (VertexFormatElement vfe : DefaultVertexFormat.BLOCK.getElements()) {
                    if (vfe.usage() == VertexFormatElement.Usage.UV) {
                        u += Float.intBitsToFloat(vertexData[i + pos + 0]);
                        v += Float.intBitsToFloat(vertexData[i + pos + 1]);
                    }
                    pos += vfe.byteSize() / 4;
                }
                ++numVertices;
            }
            return new float[]{u / (float)numVertices, v / (float)numVertices};
        }
        System.err.println("Warning: Could not get \"" + String.valueOf(side) + "\" side quads from blockstate: " + String.valueOf(state));
        return null;
    }
}

