/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.model.baked;

import com.dtteam.dynamictrees.api.network.RootConnections;
import com.dtteam.dynamictrees.block.branch.SurfaceRootBlock;
import com.dtteam.dynamictrees.model.ModelHelper;
import com.dtteam.dynamictrees.utility.CoordUtils;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.model.IDynamicBakedModel;
import net.neoforged.neoforge.client.model.IModelBuilder;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.geometry.IGeometryBakingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class SurfaceRootBlockBakedModel
implements IDynamicBakedModel {
    private final BlockModel blockModel;
    private final TextureAtlasSprite barkTexture;
    private final BakedModel[][] sleeves = new BakedModel[4][7];
    private final BakedModel[][] cores = new BakedModel[2][8];
    private final BakedModel[][] verts = new BakedModel[4][8];

    public SurfaceRootBlockBakedModel(ResourceLocation barkTextureLocation, Function<Material, TextureAtlasSprite> spriteGetter) {
        this.blockModel = new BlockModel(null, new ArrayList(), new HashMap(), Boolean.valueOf(false), BlockModel.GuiLight.FRONT, ItemTransforms.NO_TRANSFORMS, new ArrayList());
        this.barkTexture = spriteGetter.apply(new Material(InventoryMenu.BLOCK_ATLAS, barkTextureLocation));
        this.initModels();
    }

    public void initModels() {
        for (int r = 0; r < 8; ++r) {
            int radius = r + 1;
            if (radius < 8) {
                for (Direction dir : CoordUtils.HORIZONTALS) {
                    int horIndex = dir.get2DDataValue();
                    this.sleeves[horIndex][r] = this.bakeSleeve(radius, dir);
                    this.verts[horIndex][r] = this.bakeVert(radius, dir);
                }
            }
            this.cores[0][r] = this.bakeCore(radius, Direction.Axis.Z, this.barkTexture);
            this.cores[1][r] = this.bakeCore(radius, Direction.Axis.X, this.barkTexture);
        }
    }

    public int getRadialHeight(int radius) {
        return radius * 2;
    }

    public BakedModel bakeSleeve(int radius, Direction dir) {
        boolean sleeveNegative;
        int radialHeight = this.getRadialHeight(radius);
        int dradius = radius * 2;
        int halfSize = (16 - dradius) / 2;
        int halfSizeX = dir.getStepX() != 0 ? halfSize : dradius;
        int halfSizeZ = dir.getStepZ() != 0 ? halfSize : dradius;
        int move = 16 - halfSize;
        int centerX = 16 + dir.getStepX() * move;
        int centerZ = 16 + dir.getStepZ() * move;
        Vector3f posFrom = new Vector3f((float)((centerX - halfSizeX) / 2), 0.0f, (float)((centerZ - halfSizeZ) / 2));
        Vector3f posTo = new Vector3f((float)((centerX + halfSizeX) / 2), (float)radialHeight, (float)((centerZ + halfSizeZ) / 2));
        boolean bl = sleeveNegative = dir.getAxisDirection() == Direction.AxisDirection.NEGATIVE;
        if (dir.getAxis() == Direction.Axis.Z) {
            sleeveNegative = !sleeveNegative;
        }
        EnumMap mapFacesIn = Maps.newEnumMap(Direction.class);
        for (Direction face : Direction.values()) {
            if (dir.getOpposite() == face) continue;
            BlockFaceUV uvface = null;
            if (face.getAxis().isHorizontal()) {
                boolean facePositive = face.getAxisDirection() == Direction.AxisDirection.POSITIVE;
                uvface = new BlockFaceUV(new float[]{facePositive ? (float)(16 - radialHeight) : 0.0f, sleeveNegative ? 16 - halfSize : 0, facePositive ? 16.0f : (float)radialHeight, sleeveNegative ? 16 : halfSize}, ModelHelper.getFaceAngle(dir.getAxis(), face));
            } else {
                uvface = new BlockFaceUV(new float[]{8 - radius, sleeveNegative ? (float)(16 - halfSize) : 0.0f, 8 + radius, sleeveNegative ? 16.0f : (float)halfSize}, ModelHelper.getFaceAngle(dir.getAxis(), face));
            }
            if (uvface == null) continue;
            mapFacesIn.put(face, new BlockElementFace(null, -1, null, uvface));
        }
        BlockElement part = new BlockElement(posFrom, posTo, (Map)mapFacesIn, null, true);
        IModelBuilder<?> builder = ModelHelper.getModelBuilder((IGeometryBakingContext)this.blockModel.customData, this.barkTexture);
        for (Map.Entry e : part.faces.entrySet()) {
            Direction face = (Direction)e.getKey();
            builder.addCulledFace(face, ModelHelper.makeBakedQuad(part, (BlockElementFace)e.getValue(), this.barkTexture, face, BlockModelRotation.X0_Y0));
        }
        return builder.build();
    }

    private BakedModel bakeVert(int radius, Direction dir) {
        int radialHeight = this.getRadialHeight(radius);
        IModelBuilder<?> builder = ModelHelper.getModelBuilder((IGeometryBakingContext)this.blockModel.customData, this.barkTexture);
        AABB partBoundary = new AABB((double)(8 - radius), (double)radialHeight, (double)(8 - radius), (double)(8 + radius), (double)(16 + radialHeight), (double)(8 + radius)).move((double)(dir.getStepX() * 7), 0.0, (double)(dir.getStepZ() * 7));
        for (int i = 0; i < 2; ++i) {
            AABB pieceBoundary = partBoundary.intersect(new AABB(0.0, 0.0, 0.0, 16.0, 16.0, 16.0).move(0.0, (double)(16 * i), 0.0));
            for (Direction face : Direction.values()) {
                EnumMap mapFacesIn = Maps.newEnumMap(Direction.class);
                BlockFaceUV uvface = new BlockFaceUV(ModelHelper.modUV(ModelHelper.getUVs(pieceBoundary, face)), ModelHelper.getFaceAngle(Direction.Axis.Y, face));
                mapFacesIn.put(face, new BlockElementFace(null, -1, null, uvface));
                Vector3f[] limits = ModelHelper.AABBLimits(pieceBoundary);
                BlockElement part = new BlockElement(limits[0], limits[1], (Map)mapFacesIn, null, true);
                builder.addCulledFace(face, ModelHelper.makeBakedQuad(part, (BlockElementFace)part.faces.get(face), this.barkTexture, face, BlockModelRotation.X0_Y0));
            }
        }
        return builder.build();
    }

    public BakedModel bakeCore(int radius, Direction.Axis axis, TextureAtlasSprite icon) {
        int radialHeight = this.getRadialHeight(radius);
        Vector3f posFrom = new Vector3f((float)(8 - radius), 0.0f, (float)(8 - radius));
        Vector3f posTo = new Vector3f((float)(8 + radius), (float)radialHeight, (float)(8 + radius));
        EnumMap mapFacesIn = Maps.newEnumMap(Direction.class);
        for (Direction face : Direction.values()) {
            BlockFaceUV uvface;
            if (face.getAxis().isHorizontal()) {
                boolean positive = face.getAxisDirection() == Direction.AxisDirection.POSITIVE;
                uvface = new BlockFaceUV(new float[]{positive ? (float)(16 - radialHeight) : 0.0f, 8 - radius, positive ? 16.0f : (float)radialHeight, 8 + radius}, ModelHelper.getFaceAngle(axis, face));
            } else {
                uvface = new BlockFaceUV(new float[]{8 - radius, 8 - radius, 8 + radius, 8 + radius}, ModelHelper.getFaceAngle(axis, face));
            }
            mapFacesIn.put(face, new BlockElementFace(null, -1, null, uvface));
        }
        BlockElement part = new BlockElement(posFrom, posTo, (Map)mapFacesIn, null, true);
        IModelBuilder<?> builder = ModelHelper.getModelBuilder((IGeometryBakingContext)this.blockModel.customData, icon);
        for (Map.Entry e : part.faces.entrySet()) {
            Direction face = (Direction)e.getKey();
            builder.addCulledFace(face, ModelHelper.makeBakedQuad(part, (BlockElementFace)e.getValue(), icon, face, BlockModelRotation.X0_Y0));
        }
        return builder.build();
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData extraData, @Nullable RenderType renderType) {
        if (side != null || state == null) {
            return Collections.emptyList();
        }
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(24);
        int coreRadius = this.getRadius(state);
        int[] connections = new int[]{0, 0, 0, 0};
        RootConnections.ConnectionLevel[] connectionLevels = (RootConnections.ConnectionLevel[])RootConnections.PLACEHOLDER_CONNECTION_LEVELS.clone();
        RootConnections connectionData = (RootConnections)extraData.get(ModelHelper.ROOT_CONNECTIONS_PROPERTY);
        if (connectionData != null) {
            connections = connectionData.getAllRadii();
            connectionLevels = connectionData.getConnectionLevels();
        }
        for (int i = 0; i < connections.length; ++i) {
            connections[i] = Mth.clamp((int)connections[i], (int)0, (int)coreRadius);
        }
        Direction sourceDir = this.getSourceDir(coreRadius, connections);
        if (sourceDir == null) {
            sourceDir = Direction.DOWN;
        }
        int coreDir = this.resolveCoreDir(sourceDir);
        boolean isGrounded = state.getValue((Property)SurfaceRootBlock.GROUNDED) == Boolean.TRUE;
        for (Direction face : Direction.values()) {
            if (isGrounded) {
                quads.addAll(this.cores[coreDir][coreRadius - 1].getQuads(state, face, rand, extraData, renderType));
            }
            if (coreRadius == 8) continue;
            for (Direction connDir : CoordUtils.HORIZONTALS) {
                int idx = connDir.get2DDataValue();
                int connRadius = connections[idx];
                if (connRadius <= 0) continue;
                if (isGrounded) {
                    quads.addAll(this.sleeves[idx][connRadius - 1].getQuads(state, face, rand, extraData, renderType));
                }
                if (connectionLevels[idx] != RootConnections.ConnectionLevel.HIGH) continue;
                quads.addAll(this.verts[idx][connRadius - 1].getQuads(state, face, rand, extraData, renderType));
            }
        }
        return quads;
    }

    @NotNull
    public ModelData getModelData(@NotNull BlockAndTintGetter world, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull ModelData tileData) {
        RootConnections rootConnections;
        Block block = state.getBlock();
        if (block instanceof SurfaceRootBlock) {
            SurfaceRootBlock surfaceRootBlock = (SurfaceRootBlock)block;
            rootConnections = new RootConnections(surfaceRootBlock.getConnectionData(world, pos));
        } else {
            rootConnections = new RootConnections();
        }
        RootConnections rootConnections2 = rootConnections;
        return ModelData.builder().with(ModelHelper.ROOT_CONNECTIONS_PROPERTY, (Object)rootConnections2).build();
    }

    protected Direction getSourceDir(int coreRadius, int[] connections) {
        int largestConnection = 0;
        Direction sourceDir = null;
        for (Direction dir : CoordUtils.HORIZONTALS) {
            int horIndex = dir.get2DDataValue();
            int connRadius = connections[horIndex];
            if (connRadius <= largestConnection) continue;
            largestConnection = connRadius;
            sourceDir = dir;
        }
        if (largestConnection < coreRadius) {
            sourceDir = null;
        }
        return sourceDir;
    }

    protected int resolveCoreDir(Direction dir) {
        return dir.getAxis() == Direction.Axis.X ? 1 : 0;
    }

    protected int getRadius(BlockState blockState) {
        return ((SurfaceRootBlock)blockState.getBlock()).getRadius(blockState);
    }

    public boolean useAmbientOcclusion() {
        return true;
    }

    public boolean isGui3d() {
        return false;
    }

    public boolean isCustomRenderer() {
        return true;
    }

    public TextureAtlasSprite getParticleIcon() {
        return this.barkTexture;
    }

    public ItemOverrides getOverrides() {
        return ItemOverrides.EMPTY;
    }

    public boolean usesBlockLight() {
        return false;
    }
}

