/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.systems.genfeature;

import com.dtteam.dynamictrees.api.configuration.ConfigurationProperty;
import com.dtteam.dynamictrees.systems.genfeature.GenFeature;
import com.dtteam.dynamictrees.systems.genfeature.GenFeatureConfiguration;
import com.dtteam.dynamictrees.systems.genfeature.context.FullGenerationContext;
import com.dtteam.dynamictrees.systems.genfeature.context.PostGenerationContext;
import com.dtteam.dynamictrees.systems.genfeature.context.PostGrowContext;
import com.dtteam.dynamictrees.systems.genfeature.context.PostRotContext;
import com.dtteam.dynamictrees.systems.genfeature.context.PreGenerationContext;
import com.dtteam.dynamictrees.tree.species.Species;
import com.dtteam.dynamictrees.utility.CoordUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;

public class RandomPredicateGenFeature
extends GenFeature {
    public static final ConfigurationProperty<Boolean> ONLY_WORLD_GEN = ConfigurationProperty.bool("only_world_gen");
    public static final ConfigurationProperty<GenFeatureConfiguration> GEN_FEATURE = ConfigurationProperty.property("gen_feature", GenFeatureConfiguration.class);

    public RandomPredicateGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    protected void registerProperties() {
        this.register(PLACE_CHANCE, GEN_FEATURE, ONLY_WORLD_GEN);
    }

    @Override
    protected GenFeatureConfiguration createDefaultConfiguration() {
        return (GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)super.createDefaultConfiguration().with(PLACE_CHANCE, Float.valueOf(0.5f))).with(GEN_FEATURE, GenFeatureConfiguration.getNull())).with(ONLY_WORLD_GEN, false);
    }

    @Override
    public boolean shouldApply(Species species, GenFeatureConfiguration configuration) {
        return configuration.get(GEN_FEATURE).shouldApply(species);
    }

    @Override
    protected BlockPos preGenerate(GenFeatureConfiguration configuration, PreGenerationContext context) {
        if (configuration.get(ONLY_WORLD_GEN).booleanValue() && !context.isWorldGen() || Math.abs((float)CoordUtils.coordHashCode(context.pos(), 2) / 65535.0f) > ((Float)configuration.get(PLACE_CHANCE)).floatValue()) {
            return context.pos();
        }
        GenFeatureConfiguration configurationToPlace = configuration.get(GEN_FEATURE);
        if (!configuration.getGenFeature().isValid()) {
            return context.pos();
        }
        return configurationToPlace.generate(GenFeature.Type.PRE_GENERATION, context);
    }

    @Override
    protected boolean generate(GenFeatureConfiguration configuration, FullGenerationContext context) {
        if (configuration.get(ONLY_WORLD_GEN).booleanValue() && !context.isWorldGen() || Math.abs((float)CoordUtils.coordHashCode(context.pos(), 2) / 65535.0f) > ((Float)configuration.get(PLACE_CHANCE)).floatValue()) {
            return false;
        }
        GenFeatureConfiguration configurationToPlace = configuration.get(GEN_FEATURE);
        return configuration.getGenFeature().isValid() && configurationToPlace.generate(GenFeature.Type.FULL, context) != false;
    }

    @Override
    protected boolean postGenerate(GenFeatureConfiguration configuration, PostGenerationContext context) {
        if (configuration.get(ONLY_WORLD_GEN).booleanValue() && !context.isWorldGen() || Math.abs((float)CoordUtils.coordHashCode(context.pos(), 2) / 65535.0f) > ((Float)configuration.get(PLACE_CHANCE)).floatValue()) {
            return false;
        }
        GenFeatureConfiguration configurationToPlace = configuration.get(GEN_FEATURE);
        return configuration.getGenFeature().isValid() && configurationToPlace.generate(GenFeature.Type.POST_GENERATION, context) != false;
    }

    @Override
    protected boolean postGrow(GenFeatureConfiguration configuration, PostGrowContext context) {
        if (configuration.get(ONLY_WORLD_GEN).booleanValue() || Math.abs((float)CoordUtils.coordHashCode(context.pos(), 2) / 65535.0f) > ((Float)configuration.get(PLACE_CHANCE)).floatValue()) {
            return false;
        }
        GenFeatureConfiguration configurationToPlace = configuration.get(GEN_FEATURE);
        return configuration.getGenFeature().isValid() && configurationToPlace.generate(GenFeature.Type.POST_GROW, context) != false;
    }

    @Override
    protected boolean postRot(GenFeatureConfiguration configuration, PostRotContext context) {
        if (configuration.get(ONLY_WORLD_GEN).booleanValue() || Math.abs((float)CoordUtils.coordHashCode(context.pos(), 2) / 65535.0f) > ((Float)configuration.get(PLACE_CHANCE)).floatValue()) {
            return false;
        }
        GenFeatureConfiguration configurationToPlace = configuration.get(GEN_FEATURE);
        return configuration.getGenFeature().isValid() && configurationToPlace.generate(GenFeature.Type.POST_ROT, context) != false;
    }
}

