/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.systems.genfeature;

import com.dtteam.dynamictrees.api.configuration.ConfigurationProperty;
import com.dtteam.dynamictrees.api.function.TetraFunction;
import com.dtteam.dynamictrees.api.voxmap.SimpleVoxmap;
import com.dtteam.dynamictrees.block.branch.SurfaceRootBlock;
import com.dtteam.dynamictrees.block.branch.TrunkShellBlock;
import com.dtteam.dynamictrees.systems.genfeature.GenFeature;
import com.dtteam.dynamictrees.systems.genfeature.GenFeatureConfiguration;
import com.dtteam.dynamictrees.systems.genfeature.context.PostGenerationContext;
import com.dtteam.dynamictrees.systems.genfeature.context.PostGrowContext;
import com.dtteam.dynamictrees.tree.TreeHelper;
import com.dtteam.dynamictrees.tree.species.Species;
import com.dtteam.dynamictrees.utility.CoordUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class RootsGenFeature
extends GenFeature {
    public static final ConfigurationProperty<Integer> MIN_TRUNK_RADIUS = ConfigurationProperty.integer("min_trunk_radius");
    public static final ConfigurationProperty<Integer> LEVEL_LIMIT = ConfigurationProperty.integer("level_limit");
    public static final ConfigurationProperty<Float> SCALE_FACTOR = ConfigurationProperty.floatProperty("scale_factor");
    private TetraFunction<Integer, Integer, Integer, Float, Integer> scaler = (inRadius, trunkRadius, minTrunkRadius, scaleFactor) -> {
        float scale = Mth.clamp((float)(trunkRadius >= minTrunkRadius ? (float)trunkRadius.intValue() / scaleFactor.floatValue() : 0.0f), (float)0.0f, (float)1.0f);
        return (int)((float)inRadius.intValue() * scale);
    };
    private final SimpleVoxmap[] rootMaps = this.createRootMaps();

    public RootsGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    protected void registerProperties() {
        this.register(MIN_TRUNK_RADIUS, LEVEL_LIMIT, SCALE_FACTOR);
    }

    @Override
    protected GenFeatureConfiguration createDefaultConfiguration() {
        return (GenFeatureConfiguration)((GenFeatureConfiguration)((GenFeatureConfiguration)super.createDefaultConfiguration().with(MIN_TRUNK_RADIUS, 13)).with(LEVEL_LIMIT, 2)).with(SCALE_FACTOR, Float.valueOf(24.0f));
    }

    protected SimpleVoxmap[] createRootMaps() {
        byte[][] rootData = new byte[][]{{0, 3, 0, 0, 0, 0, 0, 0, 5, 6, 7, 0, 3, 2, 0, 0, 0, 8, 0, 5, 0, 0, 6, 8, 0, 8, 7, 0, 0, 0, 0, 7, 0, 0, 0, 0, 3, 4, 6, 4, 0, 0, 0, 2, 0, 0, 3, 2, 1}, {0, 3, 0, 0, 0, 0, 0, 0, 5, 6, 7, 0, 3, 2, 0, 0, 0, 8, 0, 5, 0, 0, 6, 8, 0, 8, 7, 0, 0, 0, 0, 7, 0, 0, 0, 0, 3, 4, 6, 4, 0, 0, 0, 2, 0, 0, 3, 2, 1}, {0, 0, 2, 0, 0, 0, 0, 3, 4, 6, 0, 0, 0, 0, 1, 0, 7, 8, 0, 0, 0, 0, 0, 0, 0, 7, 6, 0, 0, 0, 0, 8, 0, 5, 4, 0, 5, 6, 7, 0, 0, 2, 2, 4, 0, 0, 0, 0, 0}, {0, 4, 0, 0, 0, 0, 0, 0, 5, 6, 0, 0, 1, 0, 0, 0, 7, 0, 0, 3, 0, 0, 0, 8, 0, 8, 7, 0, 0, 0, 0, 8, 0, 5, 4, 0, 0, 6, 7, 3, 0, 2, 0, 4, 5, 0, 0, 0, 0}, {3, 4, 5, 0, 0, 0, 0, 2, 0, 6, 0, 0, 0, 0, 0, 0, 7, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 7, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 2, 3, 5, 2, 0}, {0, 0, 4, 0, 0, 0, 0, 0, 0, 6, 7, 0, 2, 0, 0, 0, 0, 8, 0, 3, 0, 5, 7, 8, 0, 6, 5, 0, 3, 0, 0, 8, 0, 2, 1, 0, 3, 0, 7, 0, 0, 0, 0, 4, 5, 6, 0, 0, 0}};
        SimpleVoxmap[] maps = new SimpleVoxmap[rootData.length];
        for (int i = 0; i < maps.length; ++i) {
            maps[i] = new SimpleVoxmap(7, 1, 7, rootData[i]).setCenter(new BlockPos(3, 0, 3));
        }
        return maps;
    }

    @Override
    protected boolean postGenerate(GenFeatureConfiguration configuration, PostGenerationContext context) {
        BlockPos treePos = context.pos().above();
        int trunkRadius = TreeHelper.getRadius((BlockGetter)context.level(), treePos);
        return trunkRadius >= configuration.get(MIN_TRUNK_RADIUS) && this.startRoots(configuration, context.level(), treePos, context.species(), trunkRadius);
    }

    @Override
    protected boolean postGrow(GenFeatureConfiguration configuration, PostGrowContext context) {
        LevelAccessor level = context.level();
        BlockPos treePos = context.treePos();
        int trunkRadius = TreeHelper.getRadius((BlockGetter)level, treePos);
        if (context.fertility() > 0 && trunkRadius >= configuration.get(MIN_TRUNK_RADIUS)) {
            CoordUtils.Surround surr = CoordUtils.Surround.values()[level.getRandom().nextInt(8)];
            BlockPos dPos = treePos.offset(surr.getOffset());
            if (level.getBlockState(dPos).getBlock() instanceof SurfaceRootBlock) {
                // empty if block
            }
            this.startRoots(configuration, level, treePos, context.species(), trunkRadius);
        }
        return true;
    }

    public boolean startRoots(GenFeatureConfiguration configuration, LevelAccessor level, BlockPos treePos, Species species, int trunkRadius) {
        int hash = CoordUtils.coordHashCode(treePos, 2);
        SimpleVoxmap rootMap = this.rootMaps[hash % this.rootMaps.length];
        this.nextRoot(level, rootMap, treePos, species, trunkRadius, configuration.get(MIN_TRUNK_RADIUS), configuration.get(SCALE_FACTOR).floatValue(), BlockPos.ZERO, 0, -1, null, 0, configuration.get(LEVEL_LIMIT));
        return true;
    }

    protected void nextRoot(LevelAccessor level, SimpleVoxmap rootMap, BlockPos trunkPos, Species species, int trunkRadius, int minTrunkRadius, float scaleFactor, BlockPos pos, int height, int levelCount, Direction fromDir, int radius, int levelLimit) {
        for (int depth = 0; depth < 2; ++depth) {
            BlockPos currPos = trunkPos.offset((Vec3i)pos).above(height - depth);
            BlockState placeState = level.getBlockState(currPos);
            BlockState belowState = level.getBlockState(currPos.below());
            boolean onNormalCube = belowState.isFaceSturdy((BlockGetter)level, currPos.below(), Direction.UP);
            if (pos != BlockPos.ZERO && (!this.isReplaceableWithRoots(level, placeState, currPos) || depth != 1 && !onNormalCube)) continue;
            if (radius > 0) {
                species.getFamily().getSurfaceRoot().ifPresent(root -> root.setRadius(level, currPos, radius, 3));
            }
            if (!onNormalCube) break;
            for (Direction dir : CoordUtils.HORIZONTALS) {
                int thisLevelCount;
                if (dir == fromDir) continue;
                BlockPos dPos = pos.relative(dir);
                int nextRad = this.scaler.apply(Integer.valueOf(rootMap.getVoxel(dPos)), trunkRadius, minTrunkRadius, Float.valueOf(scaleFactor));
                if (pos != BlockPos.ZERO && nextRad >= radius) {
                    nextRad = radius - 1;
                }
                int n = thisLevelCount = depth == 1 ? 1 : levelCount + 1;
                if (nextRad <= 0 || thisLevelCount > levelLimit) continue;
                this.nextRoot(level, rootMap, trunkPos, species, trunkRadius, minTrunkRadius, scaleFactor, dPos, height - depth, thisLevelCount, dir.getOpposite(), nextRad, levelLimit);
            }
            break;
        }
    }

    protected boolean isReplaceableWithRoots(LevelAccessor level, BlockState placeState, BlockPos pos) {
        if (level.isEmptyBlock(pos) || placeState.getBlock() instanceof TrunkShellBlock) {
            return true;
        }
        return placeState.canBeReplaced() && !placeState.getFluidState().is(FluidTags.LAVA);
    }
}

