/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.tree.family;

import com.dtteam.dynamictrees.DynamicTrees;
import com.dtteam.dynamictrees.api.lazyvalue.MutableLazyValue;
import com.dtteam.dynamictrees.api.registry.RegistryEntry;
import com.dtteam.dynamictrees.api.registry.RegistryHandler;
import com.dtteam.dynamictrees.api.registry.TypedRegistry;
import com.dtteam.dynamictrees.api.voxmap.BlockPosBounds;
import com.dtteam.dynamictrees.block.branch.BasicBranchBlock;
import com.dtteam.dynamictrees.block.branch.BranchBlock;
import com.dtteam.dynamictrees.block.branch.SurfaceRootBlock;
import com.dtteam.dynamictrees.block.branch.ThickBranchBlock;
import com.dtteam.dynamictrees.block.leaves.DynamicLeavesBlock;
import com.dtteam.dynamictrees.block.leaves.LeavesProperties;
import com.dtteam.dynamictrees.compat.WailaHelper;
import com.dtteam.dynamictrees.data.DTDataProvider;
import com.dtteam.dynamictrees.data.Generator;
import com.dtteam.dynamictrees.data.tags.DTBlockTags;
import com.dtteam.dynamictrees.data.tags.DTItemTags;
import com.dtteam.dynamictrees.entity.FallingTreeEntity;
import com.dtteam.dynamictrees.entity.animation.AnimationHandler;
import com.dtteam.dynamictrees.platform.Services;
import com.dtteam.dynamictrees.systems.cell.MetadataCell;
import com.dtteam.dynamictrees.tree.TreeHelper;
import com.dtteam.dynamictrees.tree.species.Species;
import com.dtteam.dynamictrees.treepack.Resettable;
import com.dtteam.dynamictrees.utility.Optionals;
import com.dtteam.dynamictrees.utility.ResourceLocationUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class Family
extends RegistryEntry<Family>
implements Resettable<Family> {
    public static final HashMap<ResourceLocation, Supplier<Generator<DTDataProvider.BlockState, Family>>> blockStateGenerators = new HashMap();
    public static final HashMap<ResourceLocation, Supplier<Generator<DTDataProvider.ItemModel, Family>>> itemModelGenerators = new HashMap();
    public static final HashMap<ResourceLocation, Supplier<Generator<DTDataProvider.Language, Family>>> languageGenerators = new HashMap();
    public static final TypedRegistry.EntryType<Family> TYPE = TypedRegistry.newType(Family::new);
    public static final Family NULL_FAMILY = new Family(){

        @Override
        public void setCommonSpecies(Species species) {
        }

        @Override
        public Species getCommonSpecies() {
            return Species.NULL_SPECIES;
        }

        @Override
        public boolean onTreeActivated(TreeActivationContext context) {
            return false;
        }

        @Override
        public ItemStack getStick(int qty) {
            return ItemStack.EMPTY;
        }

        @Override
        public BranchBlock getValidBranchBlock(int index) {
            return null;
        }

        @Override
        public Species getSpeciesForLocation(LevelAccessor level, BlockPos trunkPos) {
            return Species.NULL_SPECIES;
        }
    };
    public static final TypedRegistry<Family> REGISTRY = new TypedRegistry<Family>(Family.class, NULL_FAMILY, TYPE);
    protected Species commonSpecies;
    protected LeavesProperties commonLeaves = LeavesProperties.NULL;
    private Supplier<BranchBlock> branch;
    private Supplier<BranchBlock> strippedBranch;
    protected boolean hasStrippedBranch = true;
    protected Integer minRadiusForStripping = null;
    protected boolean reduceRadiusWhenStripping = true;
    private Supplier<Item> branchItem;
    private Supplier<SurfaceRootBlock> surfaceRoot;
    protected boolean hasSurfaceRoot = false;
    private Block primitiveLog = Blocks.AIR;
    private Block primitiveStrippedLog = Blocks.AIR;
    private final List<BranchBlock> validBranches = new LinkedList<BranchBlock>();
    private int maxBranchRadius = 8;
    private Item stick = Items.STICK;
    protected float lootVolumeMultiplier = 1.0f;
    public int woodRingColor;
    public int woodBarkColor;
    private final Set<Species> species = new HashSet<Species>();
    private boolean isFireProof = false;
    private BlockBehaviour.Properties properties;
    private int primaryThickness = 1;
    private int secondaryThickness = 2;
    private boolean branchIsLadder = true;
    private int maxSignalDepth = 32;
    protected final MutableLazyValue<Generator<DTDataProvider.BlockState, Family>> branchStateGenerator = MutableLazyValue.supplied(blockStateGenerators.get(DynamicTrees.location("branch")));
    protected final MutableLazyValue<Generator<DTDataProvider.BlockState, Family>> strippedBranchStateGenerator = MutableLazyValue.supplied(blockStateGenerators.get(DynamicTrees.location("stripped_branch")));
    protected final MutableLazyValue<Generator<DTDataProvider.BlockState, Family>> surfaceRootStateGenerator = MutableLazyValue.supplied(blockStateGenerators.get(DynamicTrees.location("surface_root")));
    protected final MutableLazyValue<Generator<DTDataProvider.ItemModel, Family>> branchItemModelGenerator = MutableLazyValue.supplied(itemModelGenerators.get(DynamicTrees.location("branch_item")));
    protected final MutableLazyValue<Generator<DTDataProvider.Language, Family>> familyLangGenerator = MutableLazyValue.supplied(languageGenerators.get(DynamicTrees.location("family_lang")));
    protected List<String> onlyIfLoaded = new ArrayList<String>();
    protected HashMap<String, ResourceLocation> textureOverrides = new HashMap();
    protected HashMap<String, ResourceLocation> modelOverrides = new HashMap();
    protected HashMap<String, String> langOverrides = new HashMap();
    public static final String BRANCH = "branch";
    public static final String BRANCH_TOP = "branch_top";
    public static final String STRIPPED_BRANCH = "stripped_branch";
    public static final String STRIPPED_BRANCH_TOP = "stripped_branch_top";
    public static final String ROOTS_SIDE = "roots_side";
    public static final String ROOTS_TOP = "roots_top";
    public static final String COVERED_ROOTS_BLOCK = "covered_roots_block";

    private Family() {
        this.setRegistryName(DynamicTrees.NULL);
    }

    public Family(ResourceLocation name) {
        this.setRegistryName(name);
        this.commonSpecies = Species.NULL_SPECIES;
    }

    public void setupBlocks() {
        this.setBranch(this.createBranch(this.getBranchName()));
        this.setBranchItem(this.createBranchItem(this.getBranchName(), this.branch));
        if (this.hasStrippedBranch()) {
            this.setStrippedBranch(this.createBranch(this.getBranchName("stripped_")));
        }
        if (this.hasSurfaceRoot()) {
            this.setSurfaceRoot(this.createSurfaceRoot());
        }
    }

    public void setCommonSpecies(Species species) {
        this.commonSpecies = species.setShouldGenerateSeedIfNull(true).setShouldGenerateSaplingIfNull(true).generateSeed().generateSapling();
    }

    public Species getCommonSpecies() {
        return this.commonSpecies;
    }

    public Family addSpecies(Species species) {
        this.species.add(species);
        return this;
    }

    public Set<Species> getSpecies() {
        return this.species;
    }

    public Species getSpeciesForLocation(LevelAccessor level, BlockPos trunkPos) {
        return this.getSpeciesForLocation((BlockGetter)level, trunkPos, this.commonSpecies);
    }

    public Species getSpeciesForLocation(BlockGetter level, BlockPos trunkPos, Species defaultSpecies) {
        for (Species species : this.species) {
            if (!species.shouldOverrideCommon(level, trunkPos)) continue;
            return species;
        }
        return defaultSpecies;
    }

    public boolean onTreeActivated(TreeActivationContext context) {
        if (this.canStripBranch(context.hitState, context.level, context.hitPos, context.player, context.heldItem)) {
            return this.stripBranch(context.hitState, context.level, context.hitPos, context.player, context.heldItem);
        }
        if (context.rootPos != BlockPos.ZERO) {
            return TreeHelper.getExactSpecies(context.level, context.hitPos).onTreeActivated(context);
        }
        return false;
    }

    public boolean canStripBranch(BlockState state, Level level, BlockPos pos, Player player, ItemStack heldItem) {
        BranchBlock branchBlock = TreeHelper.getBranch(state);
        if (branchBlock == null) {
            return false;
        }
        return branchBlock.canBeStripped(state, level, pos, player, heldItem);
    }

    public boolean stripBranch(BlockState state, Level level, BlockPos pos, Player player, ItemStack heldItem) {
        if (this.hasStrippedBranch()) {
            this.getBranch().ifPresent(branch -> {
                branch.stripBranch(state, level, pos, player, heldItem);
                if (level.isClientSide) {
                    level.playSound(player, pos, SoundEvents.AXE_STRIP, SoundSource.BLOCKS, 1.0f, 1.0f);
                    WailaHelper.invalidateWailaPosition();
                }
            });
            return this.getBranch().isPresent();
        }
        return false;
    }

    public boolean isWood() {
        return true;
    }

    protected ResourceLocation getBranchName() {
        return this.getBranchName("");
    }

    protected ResourceLocation getBranchName(String prefix) {
        return ResourceLocationUtils.prefix(this.getRegistryName(), prefix);
    }

    protected String getBranchNameSuffix() {
        return "_branch";
    }

    protected BranchBlock createBranchBlock(ResourceLocation name) {
        BasicBranchBlock branch;
        BasicBranchBlock basicBranchBlock = branch = this.isThick() ? new ThickBranchBlock(name, this.getProperties()) : new BasicBranchBlock(name, this.getProperties());
        if (this.isFireProof()) {
            branch.setFireSpreadSpeed(0).setFlammability(0);
        }
        return branch;
    }

    protected Supplier<BranchBlock> createBranch(ResourceLocation name) {
        return RegistryHandler.addBlock(ResourceLocationUtils.suffix(name, this.getBranchNameSuffix()), () -> this.createBranchBlock(name));
    }

    public Supplier<BlockItem> createBranchItem(ResourceLocation registryName, Supplier<BranchBlock> branchSup) {
        return RegistryHandler.addItem(ResourceLocationUtils.suffix(registryName, this.getBranchNameSuffix()), () -> new BlockItem((Block)branchSup.get(), new Item.Properties()));
    }

    protected Family setBranch(Supplier<BranchBlock> branchSup) {
        this.branch = this.setupBranch(branchSup, this.hasStrippedBranch);
        return this;
    }

    protected Family setStrippedBranch(Supplier<BranchBlock> branch) {
        this.strippedBranch = this.setupBranch(branch, false);
        return this;
    }

    protected Supplier<BranchBlock> setupBranch(Supplier<BranchBlock> branchBlockSup, boolean canBeStripped) {
        return () -> {
            BranchBlock branchBlock = (BranchBlock)branchBlockSup.get();
            branchBlock.setFamily(this);
            branchBlock.setCanBeStripped(canBeStripped);
            this.addValidBranches(branchBlock);
            return branchBlock;
        };
    }

    protected <T extends Item> Family setBranchItem(Supplier<T> branchItemSup) {
        this.branchItem = branchItemSup;
        return this;
    }

    public Optional<BranchBlock> getBranch() {
        return Optionals.ofBlock(this.branch);
    }

    public Optional<BranchBlock> getBranchForPlacement(LevelAccessor level, Species species, BlockPos pos) {
        return this.getBranch();
    }

    public Optional<BranchBlock> getBranchForRootsPlacement(LevelAccessor level, Species species, BlockPos pos) {
        return this.getBranch();
    }

    public Optional<BranchBlock> getStrippedBranch() {
        return Optionals.ofBlock(this.strippedBranch);
    }

    public Optional<Item> getBranchItem() {
        return Optionals.ofItem(this.branchItem);
    }

    public boolean isThick() {
        return this.maxBranchRadius > 8;
    }

    public int getMaxBranchRadius() {
        return this.maxBranchRadius;
    }

    public void setMaxBranchRadius(int maxBranchRadius) {
        this.maxBranchRadius = maxBranchRadius;
    }

    public int getRootColor(BlockState state, boolean getBark) {
        return getBark ? this.woodBarkColor : this.woodRingColor;
    }

    public Family setStick(Item item) {
        this.stick = item;
        return this;
    }

    public ItemStack getStick(int qty) {
        return this.stick == Items.AIR ? ItemStack.EMPTY : new ItemStack((ItemLike)this.stick, Mth.clamp((int)qty, (int)0, (int)64));
    }

    public Family setPrimitiveLog(Block primitiveLog) {
        this.primitiveLog = primitiveLog;
        if (this.branch != null) {
            this.branch.get().setPrimitiveLogDrops(new ItemStack((ItemLike)primitiveLog));
        }
        return this;
    }

    public Family setPrimitiveStrippedLog(Block primitiveStrippedLog) {
        this.primitiveStrippedLog = primitiveStrippedLog;
        if (this.strippedBranch != null) {
            this.strippedBranch.get().setPrimitiveLogDrops(new ItemStack((ItemLike)primitiveStrippedLog));
        }
        return this;
    }

    public Optional<Block> getPrimitiveLog() {
        return Optionals.ofBlock(this.primitiveLog);
    }

    public Optional<Block> getPrimitiveStrippedLog() {
        return Optionals.ofBlock(this.primitiveStrippedLog);
    }

    public List<ItemStack> getLogDropsForBranch(float volume, int branch) {
        BranchBlock branchBlock = this.getValidBranchBlock(branch);
        LinkedList<ItemStack> logs = new LinkedList<ItemStack>();
        if (branchBlock != null) {
            branchBlock.getPrimitiveLogs(volume, logs);
        }
        return logs;
    }

    public boolean isFireProof() {
        return this.isFireProof;
    }

    public void setIsFireProof(boolean isFireProof) {
        this.isFireProof = isFireProof;
    }

    @Nullable
    public Tier getDefaultBranchHarvestTier() {
        return null;
    }

    @Nullable
    public Tier getDefaultStrippedBranchHarvestTier() {
        return null;
    }

    public MapColor getDefaultBranchMapColor() {
        return MapColor.WOOD;
    }

    public boolean getDefaultFlammable() {
        return true;
    }

    public SoundType getDefaultBranchSoundType() {
        return SoundType.WOOD;
    }

    public BlockBehaviour.Properties getDefaultBranchProperties(MapColor mapColor) {
        BlockBehaviour.Properties properties = BlockBehaviour.Properties.of().sound(this.getDefaultBranchSoundType()).mapColor(mapColor).noLootTable();
        if (!this.isFireProof()) {
            properties.ignitedByLava();
        }
        return properties;
    }

    public BlockBehaviour.Properties getProperties() {
        return this.properties == null ? this.getDefaultBranchProperties(this.getDefaultBranchMapColor()) : this.properties;
    }

    public Family setProperties(BlockBehaviour.Properties properties) {
        this.properties = properties;
        return this;
    }

    public float getLootVolumeMultiplier() {
        return this.lootVolumeMultiplier;
    }

    public void setLootVolumeMultiplier(float lootVolumeMultiplier) {
        this.lootVolumeMultiplier = lootVolumeMultiplier;
    }

    public int getRadiusForCellKit(BlockGetter blockAccess, BlockPos pos, BlockState blockState, Direction dir, BranchBlock branch) {
        int radius = branch.getRadius(blockState);
        int meta = 0;
        if (radius == this.getPrimaryThickness() && blockAccess.getBlockState(pos.below()).getBlock() == branch) {
            meta = 1;
        }
        return MetadataCell.radiusAndMeta(radius, meta);
    }

    public void setPrimaryThickness(int primaryThickness) {
        this.primaryThickness = primaryThickness;
    }

    public void setSecondaryThickness(int secondaryThickness) {
        this.secondaryThickness = secondaryThickness;
    }

    public int getPrimaryThickness() {
        return this.primaryThickness;
    }

    public int getSecondaryThickness() {
        return this.secondaryThickness;
    }

    public boolean hasStrippedBranch() {
        return this.hasStrippedBranch;
    }

    public void setHasStrippedBranch(boolean hasStrippedBranch) {
        this.hasStrippedBranch = hasStrippedBranch;
    }

    public int getMinRadiusForStripping() {
        if (this.minRadiusForStripping == null) {
            return Services.CONFIG.getIntConfig("minRadiusForStrip");
        }
        return this.minRadiusForStripping;
    }

    public void setMinRadiusForStripping(int radius) {
        this.minRadiusForStripping = radius;
    }

    public boolean reduceRadiusWhenStripping() {
        if (Services.CONFIG.getBoolConfig("enableStripRadiusReduction").booleanValue()) {
            return this.reduceRadiusWhenStripping;
        }
        return false;
    }

    public void setReduceRadiusWhenStripping(boolean reduceRadiusWhenStripping) {
        this.reduceRadiusWhenStripping = reduceRadiusWhenStripping;
    }

    public void addValidBranches(BranchBlock ... branches) {
        this.validBranches.addAll(Arrays.asList(branches));
    }

    public int getBranchBlockIndex(BranchBlock block) {
        int index = this.validBranches.indexOf(block);
        if (index < 0) {
            DynamicTrees.LOG.warn("Block {} not valid branch for {}.", (Object)block, (Object)this);
            return 0;
        }
        return index;
    }

    @Nullable
    public BranchBlock getValidBranchBlock(int index) {
        if (index < this.validBranches.size()) {
            return this.validBranches.get(index);
        }
        DynamicTrees.LOG.warn("Attempted to get branch block of index {} but {} only has {} valid branches.", new Object[]{index, this, this.validBranches.size()});
        return this.validBranches.getFirst();
    }

    public boolean isValidBranchBlock(BranchBlock block) {
        return this.validBranches.contains(block);
    }

    public int getNumberOfValidBranchBlocks() {
        return this.validBranches.size();
    }

    public void setBranchIsLadder(boolean branchIsLadder) {
        this.branchIsLadder = branchIsLadder;
    }

    public boolean branchIsLadder() {
        return this.branchIsLadder;
    }

    public int getMaxSignalDepth() {
        return this.maxSignalDepth;
    }

    public void setMaxSignalDepth(int maxSignalDepth) {
        this.maxSignalDepth = maxSignalDepth;
    }

    public boolean hasSurfaceRoot() {
        return this.hasSurfaceRoot;
    }

    public void setHasSurfaceRoot(boolean hasSurfaceRoot) {
        this.hasSurfaceRoot = hasSurfaceRoot;
    }

    public Supplier<SurfaceRootBlock> createSurfaceRoot() {
        return RegistryHandler.addBlock(ResourceLocationUtils.suffix(this.getRegistryName(), "_root"), () -> new SurfaceRootBlock(this));
    }

    public Optional<SurfaceRootBlock> getSurfaceRoot() {
        return Optionals.ofBlock(this.surfaceRoot);
    }

    protected Family setSurfaceRoot(Supplier<SurfaceRootBlock> surfaceRootSup) {
        this.surfaceRoot = surfaceRootSup;
        return this;
    }

    public boolean isAcceptableSoilForRootSystem(BlockState soilBlockState) {
        return this.getCommonSpecies().isAcceptableSoil(soilBlockState);
    }

    public boolean hasRootSystem() {
        return false;
    }

    public AnimationHandler selectAnimationHandler(FallingTreeEntity fallingEntity) {
        return fallingEntity.defaultAnimationHandler();
    }

    public BlockPosBounds expandLeavesBlockBounds(BlockPosBounds bounds) {
        return bounds.expand(3);
    }

    public boolean isCompatibleDynamicLeaves(Species species, BlockState blockState, BlockGetter blockAccess, BlockPos pos) {
        DynamicLeavesBlock leaves = TreeHelper.getLeaves(blockState);
        return leaves != null && (this == leaves.getFamily(blockState, blockAccess, pos) || species.isValidLeafBlock(leaves));
    }

    public boolean isCompatibleGenericLeaves(Species species, BlockState blockState, LevelAccessor blockAccess, BlockPos pos) {
        return this.isCompatibleDynamicLeaves(species, blockState, (BlockGetter)blockAccess, pos);
    }

    public LeavesProperties getCommonLeaves() {
        return this.commonLeaves;
    }

    public void setCommonLeaves(LeavesProperties properties) {
        this.commonLeaves = properties;
        properties.setFamily(this);
    }

    public List<TagKey<Block>> defaultBranchTags() {
        return this.isFireProof ? Collections.singletonList(DTBlockTags.BRANCHES) : Collections.singletonList(DTBlockTags.BRANCHES_THAT_BURN);
    }

    public List<TagKey<Item>> defaultBranchItemTags() {
        return this.isFireProof ? Collections.singletonList(DTItemTags.BRANCHES) : Collections.singletonList(DTItemTags.BRANCHES_THAT_BURN);
    }

    public List<TagKey<Block>> defaultStrippedBranchTags() {
        return this.isFireProof ? Collections.singletonList(DTBlockTags.STRIPPED_BRANCHES) : Collections.singletonList(DTBlockTags.STRIPPED_BRANCHES_THAT_BURN);
    }

    public void addGeneratedBlockTags(Function<TagKey<Block>, IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block>> tagAppender) {
        this.getBranch().ifPresent(branch -> {
            this.tierTag(this.getDefaultBranchHarvestTier(), tagAppender).ifPresent(tagBuilder -> tagBuilder.add(branch));
            this.defaultBranchTags().forEach(tag -> {
                if (!this.isOnlyIfLoaded()) {
                    ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)tagAppender.apply((TagKey<Block>)tag)).add(branch);
                } else {
                    ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)tagAppender.apply((TagKey<Block>)tag)).addOptional(BuiltInRegistries.BLOCK.getKey(branch));
                }
            });
        });
        this.getStrippedBranch().ifPresent(strippedBranch -> {
            this.tierTag(this.getDefaultStrippedBranchHarvestTier(), tagAppender).ifPresent(tagBuilder -> tagBuilder.add(strippedBranch));
            this.defaultStrippedBranchTags().forEach(tag -> {
                if (!this.isOnlyIfLoaded()) {
                    ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)tagAppender.apply((TagKey<Block>)tag)).add(strippedBranch);
                } else {
                    ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)tagAppender.apply((TagKey<Block>)tag)).addOptional(BuiltInRegistries.BLOCK.getKey(strippedBranch));
                }
            });
        });
    }

    protected Optional<IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block>> tierTag(@Nullable Tier tier, Function<TagKey<Block>, IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block>> tagAppender) {
        if (tier == null) {
            return Optional.empty();
        }
        TagKey tag = tier.getIncorrectBlocksForDrops();
        return Optional.of(tagAppender.apply((TagKey<Block>)tag));
    }

    public void addGeneratedItemTags(Function<TagKey<Item>, IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>> tagAppender) {
        this.getBranchItem().ifPresent(item -> {
            if (!this.isOnlyIfLoaded()) {
                this.defaultBranchItemTags().forEach(tag -> ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)tagAppender.apply((TagKey<Item>)tag)).add(item));
            } else {
                this.defaultBranchItemTags().forEach(tag -> ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)tagAppender.apply((TagKey<Item>)tag)).addOptional(BuiltInRegistries.ITEM.getKey(item)));
            }
        });
    }

    public ResourceLocation getSurfaceRootLoader() {
        return DynamicTrees.location("surface_root");
    }

    public ResourceLocation getBranchLoader() {
        return DynamicTrees.location(BRANCH);
    }

    public ResourceLocation getRootsLoader() {
        return DynamicTrees.location("roots");
    }

    public ResourceLocation getBranchItemParentLocation() {
        return DynamicTrees.location("item/branch");
    }

    public ResourceLocation getRootItemParentLocation() {
        return DynamicTrees.location("item/root_branch");
    }

    @Override
    public void generateStateData(DTDataProvider.BlockState provider) {
        this.branchStateGenerator.get().generate(provider, this);
        this.strippedBranchStateGenerator.get().generate(provider, this);
        this.surfaceRootStateGenerator.get().generate(provider, this);
    }

    @Override
    public void generateItemModelData(DTDataProvider.ItemModel provider) {
        this.branchItemModelGenerator.get().generate(provider, this);
    }

    @Override
    public void generateLangData(DTDataProvider.Language provider) {
        this.familyLangGenerator.get().generate(provider, this);
    }

    public void setOnlyIfLoaded(String onlyIfLoaded) {
        this.onlyIfLoaded.add(onlyIfLoaded);
    }

    public boolean isOnlyIfLoaded() {
        return !this.onlyIfLoaded.isEmpty();
    }

    public void setTextureOverrides(Map<String, ResourceLocation> textureOverrides) {
        this.textureOverrides.putAll(textureOverrides);
    }

    public Optional<ResourceLocation> getTexturePath(String key) {
        return Optional.ofNullable(this.textureOverrides.getOrDefault(key, null));
    }

    public void setModelOverrides(Map<String, ResourceLocation> modelOverrides) {
        this.modelOverrides.putAll(modelOverrides);
    }

    public Optional<ResourceLocation> getModelPath(String key) {
        return Optional.ofNullable(this.modelOverrides.getOrDefault(key, null));
    }

    public void setLangOverrides(Map<String, String> langOverrides) {
        this.langOverrides.putAll(langOverrides);
    }

    public Optional<String> getLangOverride(String key) {
        return Optional.ofNullable(this.langOverrides.getOrDefault(key, null));
    }

    public void addBranchTextures(BiConsumer<String, ResourceLocation> textureConsumer, ResourceLocation primitiveLogLocation, Block sourceBlock) {
        ResourceLocation bark = primitiveLogLocation;
        ResourceLocation rings = ResourceLocationUtils.suffix(primitiveLogLocation, "_top");
        AtomicBoolean isStripped = new AtomicBoolean(false);
        this.getPrimitiveStrippedLog().ifPresent(l -> isStripped.set(l.equals(sourceBlock)));
        if (isStripped.get()) {
            if (this.textureOverrides.containsKey(STRIPPED_BRANCH)) {
                bark = this.textureOverrides.get(STRIPPED_BRANCH);
            }
            if (this.textureOverrides.containsKey(STRIPPED_BRANCH_TOP)) {
                rings = this.textureOverrides.get(STRIPPED_BRANCH_TOP);
            }
        } else {
            if (this.textureOverrides.containsKey(BRANCH)) {
                bark = this.textureOverrides.get(BRANCH);
            }
            if (this.textureOverrides.containsKey(BRANCH_TOP)) {
                rings = this.textureOverrides.get(BRANCH_TOP);
            }
        }
        textureConsumer.accept("bark", bark);
        textureConsumer.accept("rings", rings);
    }

    public void addRootTextures(BiConsumer<String, ResourceLocation> textureConsumer, ResourceLocation primitiveLogLocation) {
        ResourceLocation bark = ResourceLocationUtils.suffix(primitiveLogLocation, "_side");
        ResourceLocation rings = ResourceLocationUtils.suffix(primitiveLogLocation, "_top");
        if (this.textureOverrides.containsKey(ROOTS_SIDE)) {
            bark = this.textureOverrides.get(ROOTS_SIDE);
        }
        if (this.textureOverrides.containsKey(ROOTS_TOP)) {
            rings = this.textureOverrides.get(ROOTS_TOP);
        }
        textureConsumer.accept("bark", bark);
        textureConsumer.accept("rings", rings);
    }

    public List<ResourceLocation> topBranchTextureLocations() {
        ArrayList<ResourceLocation> locations = new ArrayList<ResourceLocation>();
        if (this.getPrimitiveLog().isPresent()) {
            locations.add(this.topBranchTextureLocation(this.getPrimitiveLog().get(), BRANCH_TOP));
        }
        if (this.getPrimitiveStrippedLog().isPresent()) {
            locations.add(this.topBranchTextureLocation(this.getPrimitiveStrippedLog().get(), STRIPPED_BRANCH_TOP));
        }
        return locations;
    }

    protected ResourceLocation topBranchTextureLocation(Block block, String key) {
        if (this.textureOverrides.containsKey(key)) {
            return this.textureOverrides.get(key);
        }
        ResourceLocation textureLoc = BuiltInRegistries.BLOCK.getKey((Object)block);
        textureLoc = ResourceLocationUtils.surround(textureLoc, "block/", "_top");
        return textureLoc;
    }

    @Override
    public String toLoadDataString() {
        return this.getString(Pair.of((Object)"commonLeaves", (Object)this.commonLeaves), Pair.of((Object)"maxBranchRadius", (Object)this.maxBranchRadius), Pair.of((Object)"hasSurfaceRoot", (Object)this.hasSurfaceRoot), Pair.of((Object)"hasStrippedBranch", (Object)this.hasStrippedBranch));
    }

    @Override
    public String toReloadDataString() {
        return this.getString(Pair.of((Object)"commonLeaves", (Object)this.commonLeaves), Pair.of((Object)"maxBranchRadius", (Object)this.maxBranchRadius), Pair.of((Object)"commonSpecies", (Object)this.commonSpecies), Pair.of((Object)"primitiveLog", (Object)this.primitiveLog), Pair.of((Object)"primitiveStrippedLog", (Object)this.primitiveStrippedLog), Pair.of((Object)"stick", (Object)this.stick), Pair.of((Object)"minRadiusForStrip", (Object)this.minRadiusForStripping));
    }

    public record TreeActivationContext(Level level, BlockPos rootPos, BlockPos hitPos, BlockState hitState, Player player, InteractionHand hand, @Nullable ItemStack heldItem, BlockHitResult hitResult) {
    }
}

