/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.treepack.loader;

import com.dtteam.dynamictrees.api.resource.loading.preparation.JsonRegistryResourceLoader;
import com.dtteam.dynamictrees.block.leaves.LeavesProperties;
import com.dtteam.dynamictrees.block.soil.SoilHelper;
import com.dtteam.dynamictrees.block.soil.SoilProperties;
import com.dtteam.dynamictrees.deserialization.JsonHelper;
import com.dtteam.dynamictrees.deserialization.applier.PropertyApplierResult;
import com.dtteam.dynamictrees.tree.family.Family;
import com.dtteam.dynamictrees.tree.family.UndergroundRootsFamily;
import com.dtteam.dynamictrees.tree.species.Species;
import com.dtteam.dynamictrees.utility.ResourceLocationUtils;
import com.google.gson.JsonObject;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class FamilyResourceLoader
extends JsonRegistryResourceLoader<Family> {
    private static final Logger LOGGER = LogManager.getLogger();

    public FamilyResourceLoader() {
        super(Family.REGISTRY, "families", "family");
    }

    @Override
    public void registerAppliers() {
        this.commonAppliers.register("common_species", ResourceLocation.class, (family, registryName) -> {
            registryName = ResourceLocationUtils.parseDTLocation(registryName);
            Species.REGISTRY.runOnNextLock(Species.REGISTRY.generateIfValidRunnable((ResourceLocation)registryName, family::setCommonSpecies, FamilyResourceLoader.setCommonWarn(family, registryName)));
        }).register("common_leaves", LeavesProperties.class, Family::setCommonLeaves).register("max_branch_radius", Integer.class, Family::setMaxBranchRadius);
        this.gatherDataAppliers.register("primitive_log", Block.class, Family::setPrimitiveLog).register("primitive_stripped_log", Block.class, Family::setPrimitiveStrippedLog).register("only_if_loaded", String.class, Family::setOnlyIfLoaded).registerArrayApplier("only_if_loaded", String.class, Family::setOnlyIfLoaded).registerMapApplier("texture_overrides", ResourceLocation.class, Family::setTextureOverrides).registerMapApplier("model_overrides", ResourceLocation.class, Family::setModelOverrides).registerMapApplier("lang_overrides", String.class, Family::setLangOverrides).register("stick", Item.class, Family::setStick);
        this.setupAppliers.register("primitive_log", Block.class, Family::setPrimitiveLog).register("primitive_stripped_log", Block.class, Family::setPrimitiveStrippedLog).register("stick", Item.class, Family::setStick);
        this.loadAppliers.register("generate_surface_root", Boolean.class, Family::setHasSurfaceRoot).register("generate_stripped_branch", Boolean.class, Family::setHasStrippedBranch).register("fire_proof", Boolean.class, Family::setIsFireProof);
        this.reloadAppliers.register("primary_thickness", Integer.class, Family::setPrimaryThickness).register("secondary_thickness", Integer.class, Family::setSecondaryThickness).register("branch_is_ladder", Boolean.class, Family::setBranchIsLadder).register("max_signal_depth", Integer.class, Family::setMaxSignalDepth).register("loot_volume_multiplier", Float.class, Family::setLootVolumeMultiplier).register("min_radius_for_stripping", Integer.class, Family::setMinRadiusForStripping).register("reduce_radius_when_stripping", Boolean.class, Family::setReduceRadiusWhenStripping);
        this.registerMangroveAppliers();
        super.registerAppliers();
    }

    private void registerMangroveAppliers() {
        this.gatherDataAppliers.register("primitive_root", UndergroundRootsFamily.class, Block.class, UndergroundRootsFamily::setPrimitiveRoots).register("primitive_filled_root", UndergroundRootsFamily.class, Block.class, UndergroundRootsFamily::setPrimitiveRootsFilled).register("primitive_covered_root", UndergroundRootsFamily.class, Block.class, UndergroundRootsFamily::setPrimitiveRootsCovered).register("default_soil", UndergroundRootsFamily.class, SoilProperties.class, UndergroundRootsFamily::setDefaultSoil);
        this.setupAppliers.register("primitive_root", UndergroundRootsFamily.class, Block.class, UndergroundRootsFamily::setPrimitiveRoots).register("primitive_filled_root", UndergroundRootsFamily.class, Block.class, UndergroundRootsFamily::setPrimitiveRootsFilled).register("primitive_covered_root", UndergroundRootsFamily.class, Block.class, UndergroundRootsFamily::setPrimitiveRootsCovered);
        this.reloadAppliers.register("default_soil", UndergroundRootsFamily.class, SoilProperties.class, UndergroundRootsFamily::setDefaultSoil).registerArrayApplier("root_system_acceptable_soils", UndergroundRootsFamily.class, String.class, this::addAcceptableSoilForRootSystem);
    }

    private static Runnable setCommonWarn(Family family, ResourceLocation registryName) {
        return () -> LOGGER.warn("Could not set common species for \"{}\" as species with name  \"{}\" was not found.", (Object)family, (Object)registryName);
    }

    @Override
    protected void applyLoadAppliers(JsonRegistryResourceLoader.LoadData loadData, JsonObject json) {
        this.setBranchProperties((Family)loadData.getResource(), json);
        super.applyLoadAppliers(loadData, json);
    }

    private void setBranchProperties(Family family, JsonObject json) {
        family.setProperties(JsonHelper.getBlockProperties(JsonHelper.getOrDefault(json, "branch_properties", JsonObject.class, new JsonObject()), family.getDefaultBranchMapColor(), family::getDefaultBranchProperties, error -> this.logError(family.getRegistryName(), (String)error), warning -> this.logWarning(family.getRegistryName(), (String)warning)));
    }

    @Override
    protected void postLoadOnLoad(JsonRegistryResourceLoader.LoadData loadData, JsonObject json) {
        super.postLoadOnLoad(loadData, json);
        ((Family)loadData.getResource()).setupBlocks();
    }

    private PropertyApplierResult addAcceptableSoilForRootSystem(UndergroundRootsFamily family, String acceptableSoil) {
        return SoilHelper.applyIfSoilIsAcceptable(family, acceptableSoil, (rec$, xva$0) -> ((UndergroundRootsFamily)rec$).addAcceptableSoilsForRootSystem((String)xva$0));
    }
}

