/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.worldgen;

import com.dtteam.dynamictrees.api.worldgen.RadiusCoordinator;
import com.dtteam.dynamictrees.worldgen.BiomeDatabases;
import java.util.ArrayList;
import java.util.Collections;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.synth.PerlinSimplexNoise;

public class BiomeRadiusCoordinator
implements RadiusCoordinator {
    public PerlinSimplexNoise noiseGenerator = new PerlinSimplexNoise((RandomSource)new WorldgenRandom(WorldgenRandom.Algorithm.LEGACY.newInstance(96L)), new ArrayList<Integer>(Collections.singletonList(1)));
    protected final LevelAccessor level;
    protected final ResourceLocation dimensionName;
    protected int pass;
    protected Function<Integer, Integer> chunkMultipass;

    public BiomeRadiusCoordinator(ResourceLocation dimensionName, LevelAccessor level) {
        this.level = level;
        this.dimensionName = dimensionName;
    }

    @Override
    public int getRadiusAtCoords(int x, int z) {
        int rad = this.chunkMultipass.apply(this.pass);
        if (rad >= 2 && rad <= 8) {
            return rad;
        }
        double scale = 128.0;
        Holder biome = this.level.getUncachedNoiseBiome(x + 8 >> 2, this.level.getMaxBuildHeight() >> 2, z + 8 >> 2);
        double noiseDensity = (this.noiseGenerator.getValue((double)x / 128.0, (double)z / 128.0, false) + 1.0) / 2.0;
        double density = BiomeDatabases.getDimensionalOrDefault(this.dimensionName).getDensitySelector((Holder<Biome>)biome).getDensity(this.level.getRandom(), noiseDensity);
        double size = (1.0 - density) * 9.0;
        int kindaRandom = (x * 674365771 ^ z * 254326997) >> 4;
        int shakelow = (kindaRandom & 3) % 3;
        int shakehigh = (kindaRandom & 0xC) % 3;
        return Mth.clamp((int)((int)size), (int)(2 + shakelow), (int)(8 - shakehigh));
    }

    @Override
    public boolean runPass(int chunkX, int chunkZ, int pass) {
        this.pass = pass;
        if (pass == 0) {
            Holder biome = this.level.getUncachedNoiseBiome((chunkX << 4) + 8 >> 2, this.level.getMaxBuildHeight() >> 2, (chunkZ << 4) + 8 >> 2);
            this.chunkMultipass = BiomeDatabases.getDimensionalOrDefault(this.dimensionName).getMultipass((Holder<Biome>)biome);
        }
        return this.chunkMultipass.apply(pass) >= 0;
    }
}

