/*
 * Decompiled with CFR 0.152.
 */
package com.dtteam.dynamictrees.worldgen.feature;

import com.dtteam.dynamictrees.api.worldgen.BiomePropertySelectors;
import com.dtteam.dynamictrees.api.worldgen.GroundFinder;
import com.dtteam.dynamictrees.api.worldgen.LevelContext;
import com.dtteam.dynamictrees.systems.poissondisc.PoissonDisc;
import com.dtteam.dynamictrees.worldgen.BiomeDatabase;
import com.dtteam.dynamictrees.worldgen.BiomeDatabases;
import com.dtteam.dynamictrees.worldgen.feature.DynamicTreeFeature;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class CaveRootedTreeFeature
extends DynamicTreeFeature {
    @Override
    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.level();
        ResourceLocation dimensionName = level.getLevel().dimension().location();
        if (BiomeDatabases.isBlacklisted(dimensionName)) {
            return false;
        }
        BlockPos originPos = context.origin();
        ChunkPos chunkPos = new ChunkPos(originPos);
        LevelContext levelContext = LevelContext.create((LevelAccessor)level);
        PoissonDisc disc = this.getDisc(levelContext, chunkPos, originPos).orElse(null);
        if (disc == null) {
            return false;
        }
        List<BlockPos> groundPositions = GroundFinder.getGroundFinder((Level)level.getLevel()).findGround((LevelAccessor)level, originPos, null);
        if (groundPositions.isEmpty()) {
            return false;
        }
        BiomeDatabase.Entry biomeEntry = BiomeDatabases.getDefault().getEntry(CaveRootedTreeFeature.getNoiseBiome(levelContext, originPos));
        if (biomeEntry.getCaveRootedData() == null) {
            return false;
        }
        BiomeDatabase.CaveRootedData caveRootedData = biomeEntry.getCaveRootedData();
        if ((groundPositions = groundPositions.stream().filter(pos -> pos != BlockPos.ZERO).sorted(Comparator.comparingInt(Vec3i::getY)).toList()).isEmpty()) {
            return false;
        }
        if (caveRootedData.shouldGenerateOnSurface()) {
            groundPositions = List.of(groundPositions.getLast());
        }
        AtomicBoolean generated = new AtomicBoolean(false);
        groundPositions.forEach(groundPos -> {
            DynamicTreeFeature.GeneratorResult result = this.generateTree(levelContext, biomeEntry, disc, originPos, (BlockPos)groundPos);
            if (result == DynamicTreeFeature.GeneratorResult.GENERATED) {
                generated.set(true);
            }
        });
        return generated.get();
    }

    @Override
    protected BiomePropertySelectors.SpeciesSelector getSpeciesSelector(BiomeDatabase.EntryReader biomeEntry) {
        BiomeDatabase.Entry entry;
        if (biomeEntry instanceof BiomeDatabase.Entry && (entry = (BiomeDatabase.Entry)biomeEntry).getCaveRootedData() != null) {
            return entry.getCaveRootedData().getCaveRootedSpeciesSelector();
        }
        return biomeEntry.getSpeciesSelector();
    }

    @Override
    protected BiomePropertySelectors.ChanceSelector getChanceSelector(BiomeDatabase.EntryReader biomeEntry) {
        BiomeDatabase.Entry entry;
        if (biomeEntry instanceof BiomeDatabase.Entry && (entry = (BiomeDatabase.Entry)biomeEntry).getCaveRootedData() != null) {
            return entry.getCaveRootedData().getCaveRootedChanceSelector();
        }
        return biomeEntry.getChanceSelector();
    }

    private Optional<PoissonDisc> getDisc(LevelContext levelContext, ChunkPos chunkPos, BlockPos originPos) {
        return DISC_PROVIDER.getPoissonDiscs(levelContext, chunkPos).stream().filter(disc -> disc.x == originPos.getX() && disc.z == originPos.getZ()).findFirst();
    }

    private Optional<BlockPos> getNextGroundPos(BlockPos originPos, List<BlockPos> groundPositions) {
        for (BlockPos groundPos : groundPositions) {
            if (groundPos.getY() <= originPos.getY()) continue;
            return Optional.of(groundPos);
        }
        return Optional.empty();
    }
}

