/*
 * Decompiled with CFR 0.152.
 */
package me.yleoft.zHomes.commands;

import com.zhomes.api.event.player.ExecuteHomesCommandEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import me.yleoft.zHomes.Main;
import me.yleoft.zHomes.shaded.zAPI.inventory.CustomInventory;
import me.yleoft.zHomes.shaded.zAPI.managers.FileManager;
import me.yleoft.zHomes.shaded.zAPI.utils.ConfigUtils;
import me.yleoft.zHomes.shaded.zAPI.utils.StringUtils;
import me.yleoft.zHomes.utils.HomesUtils;
import me.yleoft.zHomes.utils.LanguageUtils;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.Inventory;
import org.jetbrains.annotations.NotNull;

public class HomesCommand
extends HomesUtils
implements CommandExecutor {
    public boolean onCommand(@NotNull CommandSender s, @NotNull Command cmd, @NotNull String label, String[] args) {
        if (!(s instanceof Player)) {
            return false;
        }
        Player p = (Player)s;
        LanguageUtils.CommandsMSG cmdm = new LanguageUtils.CommandsMSG();
        if (!p.hasPermission(this.CmdHomesPermission())) {
            cmdm.sendMsg(p, cmdm.getNoPermission());
            return false;
        }
        ExecuteHomesCommandEvent event = new ExecuteHomesCommandEvent(p);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        LanguageUtils.Homes lang = new LanguageUtils.Homes();
        if (args.length >= 1) {
            if (StringUtils.isInteger(args[0])) {
                int page = Integer.parseInt(args[0]);
                if (page < 1) {
                    lang.sendMsg(p, lang.getInvalidPage());
                    return false;
                }
                this.code(p, (OfflinePlayer)p, page, lang, cmdm);
                return true;
            }
            String player = args[0];
            if (p.hasPermission(this.CmdHomesOthersPermission())) {
                OfflinePlayer t = Bukkit.getOfflinePlayer((String)player);
                if (t == null) {
                    lang.sendMsg(p, cmdm.getCantFindPlayer());
                    return false;
                }
                if (args.length >= 2 && StringUtils.isInteger(args[1])) {
                    int page = Integer.parseInt(args[1]);
                    if (page < 1) {
                        lang.sendMsg(p, lang.getInvalidPage());
                        return false;
                    }
                    this.code(p, t, page, lang, cmdm);
                    return true;
                }
                this.code(p, t, lang, cmdm);
                return true;
            }
        }
        this.code(p, (OfflinePlayer)p, lang, cmdm);
        return false;
    }

    public void code(String type, Player p, OfflinePlayer t, int page, LanguageUtils.Homes lang, LanguageUtils.CommandsMSG cmdm) {
        if (this.cfguExtras.canAfford(p, this.CmdHomesPermission(), this.CmdHomesCost())) {
            switch (type) {
                case "menu": {
                    try {
                        p.openInventory(this.getInventory(p, t, page));
                        break;
                    }
                    catch (Exception e) {
                        this.code("text", p, t, page, lang, cmdm);
                        return;
                    }
                }
                case "text": {
                    if (p != t) {
                        lang.sendMsg(p, lang.getOutput(t));
                        break;
                    }
                    lang.sendMsg(p, lang.getOutput());
                    break;
                }
                default: {
                    lang.sendMsg(p, cmdm.getCantFindPlayer());
                }
            }
        }
    }

    public void code(Player p, OfflinePlayer t, int page, LanguageUtils.Homes lang, LanguageUtils.CommandsMSG cmdm) {
        this.code(this.CmdHomesType(), p, t, page, lang, cmdm);
    }

    public void code(Player p, OfflinePlayer t, LanguageUtils.Homes lang, LanguageUtils.CommandsMSG cmdm) {
        this.code(this.CmdHomesType(), p, t, 1, lang, cmdm);
    }

    public Inventory getInventory(Player p, OfflinePlayer t, int page) {
        List<String> finalHomes;
        YamlConfiguration config = FileManager.getFile("menus/menu-homes.yml");
        String path = ConfigUtils.formPath("Config", "homes-item");
        String pathPP = ConfigUtils.formPath("Config", "previous-page-item");
        String pathNP = ConfigUtils.formPath("Config", "next-page-item");
        CustomInventory inv = new CustomInventory(p, config);
        List<String> homes = Main.hu.homesW(t);
        if (p != t) {
            finalHomes = new ArrayList<String>();
            inv.setInventoryName(t, Objects.requireNonNull(Objects.requireNonNull(config.getString(ConfigUtils.formPath("Inventory", "title-other"))).replace("%player%", Objects.requireNonNull(t.getName()))));
            homes.forEach(home -> finalHomes.add(t.getName() + ":" + home));
        } else {
            finalHomes = homes;
        }
        int slots = 45;
        if (page > 1) {
            int startIndex = 0;
            int endIndex = Math.min(startIndex + slots * (page - 1), finalHomes.size());
            finalHomes.subList(startIndex, endIndex).clear();
            inv.setItem(p, config, pathPP, "%previous-page%", Collections.singletonList(String.valueOf(page - 1)));
        }
        if (!finalHomes.isEmpty()) {
            if (finalHomes.size() > 45) {
                inv.setItem(p, config, pathNP, "%next-page%", Collections.singletonList(String.valueOf(page + 1)));
            }
            inv.setItem(p, config, path, "%home%", finalHomes);
        }
        return inv.getInventory();
    }
}

