/*
 * Decompiled with CFR 0.152.
 */
package me.yleoft.zHomes.shaded.zAPI.utils;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import me.yleoft.zHomes.shaded.zAPI.utils.SkullUtils;
import me.yleoft.zHomes.shaded.zAPI.zAPI;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public abstract class HeadUtils {
    private static final Map<String, ItemStack> cacheName = new ConcurrentHashMap<String, ItemStack>();
    private static final Map<String, ItemStack> cacheBase64 = new ConcurrentHashMap<String, ItemStack>();

    public static ItemStack getPlayerHeadFromString(@NotNull String type, @NotNull String value) {
        switch (type) {
            case "head": {
                return HeadUtils.getPlayerHead(value);
            }
            case "base64head": {
                return HeadUtils.getPlayerHeadB64(value);
            }
        }
        return SkullUtils.originalHead.clone();
    }

    public static ItemStack getPlayerHead(@NotNull String playerName) {
        try {
            return cacheName.computeIfAbsent(playerName, SkullUtils::getSkullByName).clone();
        }
        catch (Exception exception) {
            zAPI.getPlugin().getLogger().severe("[zAPI] Failed to get head for player: " + playerName);
            return SkullUtils.originalHead.clone();
        }
    }

    public static ItemStack getPlayerHeadB64(@NotNull String base64Url) {
        try {
            return cacheBase64.computeIfAbsent(base64Url, SkullUtils::getSkullByBase64EncodedTextureUrl).clone();
        }
        catch (Exception exception) {
            zAPI.getPlugin().getLogger().severe("[zAPI] Failed to get head for base64: " + base64Url);
            return SkullUtils.originalHead.clone();
        }
    }
}

