/*
 * Decompiled with CFR 0.152.
 */
package me.yleoft.zHomes.shaded.zAPI.utils;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;

public class ModrinthDownloader {
    private static final String BASE = "https://api.modrinth.com/v2";
    private static final Gson GSON = new Gson();

    public static String getLatestDownloadUrl(String projectIdentifier) throws IOException {
        Project project = ModrinthDownloader.getJson("https://api.modrinth.com/v2/project/" + ModrinthDownloader.encode(projectIdentifier), Project.class);
        if (project == null || project.versions == null || project.versions.isEmpty()) {
            throw new IOException("No versions found for project: " + projectIdentifier);
        }
        String latestVersionId = project.versions.get(project.versions.size() - 1);
        Version version = ModrinthDownloader.getJson("https://api.modrinth.com/v2/version/" + ModrinthDownloader.encode(latestVersionId), Version.class);
        if (version == null || version.files == null || version.files.isEmpty()) {
            throw new IOException("No files for version: " + latestVersionId);
        }
        return version.files.get((int)0).url;
    }

    private static <T> T getJson(String url, Class<T> clazz) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
        conn.setRequestProperty("User-Agent", "YourAppName/1.0 (contact@example.com)");
        conn.setRequestProperty("Accept", "application/json");
        int code = conn.getResponseCode();
        if (code != 200) {
            throw new IOException("HTTP " + code + " from " + url);
        }
        try {
            Object object;
            try (BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));){
                object = GSON.fromJson((Reader)br, clazz);
            }
            return (T)object;
        }
        finally {
            conn.disconnect();
        }
    }

    private static String encode(String s) {
        return s;
    }

    static class Project {
        List<String> versions;

        Project() {
        }
    }

    static class Version {
        List<FileInfo> files;

        Version() {
        }
    }

    static class FileInfo {
        String url;
        String filename;
        boolean primary;
        @SerializedName(value="hashes")
        Hashes hashes;

        FileInfo() {
        }
    }

    static class Hashes {
        String sha1;
        String sha512;

        Hashes() {
        }
    }
}

