/*
 * Decompiled with CFR 0.152.
 */
package me.yleoft.zHomes.shaded.zAPI.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.Nullable;

public abstract class ProtocolUtils {
    public static int getProtocolVersion() {
        try {
            Method method;
            String packageName = Bukkit.getServer().getClass().getPackage().getName();
            String version = packageName.contains("v") ? packageName.substring(packageName.lastIndexOf(46) + 1) : "";
            Class<?> sharedConstantsClass = ProtocolUtils.getNMSClass();
            if (sharedConstantsClass == null) {
                System.out.println("[ProtocolUtils] SharedConstants class not found for version " + version);
                return -1;
            }
            Object mcVersion = sharedConstantsClass.getMethod("getCurrentVersion", new Class[0]).invoke(null, new Object[0]);
            try {
                method = mcVersion.getClass().getMethod("protocolVersion", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                method = mcVersion.getClass().getMethod("getProtocolVersion", new Class[0]);
            }
            return (Integer)method.invoke(mcVersion, new Object[0]);
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.out.println("[ProtocolUtils] Falling back to legacy protocol version.");
            return ProtocolUtils.tryLegacyProtocolVersion();
        }
    }

    private static int tryLegacyProtocolVersion() {
        try {
            Class<?> serverClass = ProtocolUtils.getLegacyNMSClass();
            Method getServerMethod = serverClass.getMethod("getServer", new Class[0]);
            Object server = getServerMethod.invoke(null, new Object[0]);
            Field pingField = server.getClass().getDeclaredField("K");
            pingField.setAccessible(true);
            return pingField.getInt(server);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return -1;
        }
    }

    @Nullable
    private static Class<?> getNMSClass() {
        try {
            return Class.forName("net.minecraft.SharedConstants");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @Nullable
    private static Class<?> getLegacyNMSClass() {
        try {
            String packageName = Bukkit.getServer().getClass().getPackage().getName();
            String version = packageName.contains("v") ? packageName.substring(packageName.lastIndexOf(46) + 1) : "";
            String className = version.isEmpty() ? "net.minecraft.server.MinecraftServer" : "net.minecraft.server." + version + ".MinecraftServer";
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }
}

