/*
 * Decompiled with CFR 0.152.
 */
package me.yleoft.zHomes.storage;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import me.yleoft.zHomes.Main;
import me.yleoft.zHomes.shaded.hikari.HikariConfig;
import me.yleoft.zHomes.shaded.hikari.HikariDataSource;
import me.yleoft.zHomes.shaded.zAPI.folia.FoliaRunnable;
import me.yleoft.zHomes.shaded.zAPI.utils.LocationUtils;
import me.yleoft.zHomes.shaded.zAPI.utils.PlayerUtils;
import me.yleoft.zHomes.shaded.zAPI.utils.SchedulerUtils;
import me.yleoft.zHomes.storage.database_type;
import me.yleoft.zHomes.utils.ConfigUtils;
import me.yleoft.zHomes.utils.LanguageUtils;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseConnection
extends ConfigUtils {
    boolean retry = false;

    public void connect() {
        block18: {
            try {
                if (Main.dataSource != null && !Main.dataSource.isClosed()) break block18;
                long start = System.currentTimeMillis();
                HikariConfig config = new HikariConfig();
                switch (this.databaseType().toLowerCase()) {
                    case "mariadb": {
                        if (Main.mariadbDriver == null) {
                            File mariadbjarFile = new File(Main.getInstance().libsFolder, Main.getInstance().mariadbJar);
                            URL mariadbjarURL = mariadbjarFile.toURI().toURL();
                            URLClassLoader mariadbclassLoader = new URLClassLoader(new URL[]{mariadbjarURL}, Main.class.getClassLoader());
                            Class<?> mariadbdriverClass = Class.forName("org.mariadb.jdbc.Driver", true, mariadbclassLoader);
                            Main.mariadbDriver = (Driver)mariadbdriverClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                            DriverManager.registerDriver(new DriverShim(Main.mariadbDriver));
                        }
                        Main.type = database_type.EXTERNAL;
                        config.setJdbcUrl(this.mariadbUrl());
                        config.setUsername(this.databaseUsername());
                        config.setPassword(this.databasePassword());
                        break;
                    }
                    case "mysql": {
                        if (Main.mysqlDriver == null) {
                            try {
                                if (DriverManager.getDriver("jdbc:mysql://") != null) {
                                    DriverManager.deregisterDriver(DriverManager.getDriver("jdbc:mysql://"));
                                }
                            }
                            catch (Exception mariadbjarFile) {
                                // empty catch block
                            }
                            File mysqljarFile = new File(Main.getInstance().libsFolder, Main.getInstance().mysqlJar);
                            URL mysqljarURL = mysqljarFile.toURI().toURL();
                            URLClassLoader mysqlclassLoader = new URLClassLoader(new URL[]{mysqljarURL}, Main.class.getClassLoader());
                            Class<?> mysqldriverClass = Class.forName("com.mysql.cj.jdbc.Driver", true, mysqlclassLoader);
                            Main.mysqlDriver = (Driver)mysqldriverClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                            DriverManager.registerDriver(new DriverShim(Main.mysqlDriver));
                        }
                        Main.type = database_type.EXTERNAL;
                        config.setJdbcUrl(this.mysqlUrl());
                        config.setUsername(this.databaseUsername());
                        config.setPassword(this.databasePassword());
                        break;
                    }
                    case "h2": {
                        if (Main.h2Driver == null) {
                            File h2jarFile = new File(Main.getInstance().libsFolder, Main.getInstance().h2Jar);
                            URL h2jarURL = h2jarFile.toURI().toURL();
                            URLClassLoader h2classLoader = new URLClassLoader(new URL[]{h2jarURL}, Main.class.getClassLoader());
                            Class<?> h2driverClass = Class.forName("org.h2.Driver", true, h2classLoader);
                            Main.h2Driver = (Driver)h2driverClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                            DriverManager.registerDriver(new DriverShim(Main.h2Driver));
                        }
                        Main.type = database_type.H2;
                        config.setJdbcUrl(this.h2Url());
                        break;
                    }
                    default: {
                        Main.type = database_type.SQLITE;
                        config.setJdbcUrl(this.sqliteUrl());
                    }
                }
                config.setMaximumPoolSize(this.databasePoolsize());
                Main.dataSource = new HikariDataSource(config);
                long end = System.currentTimeMillis();
                Main.getInstance().getLogger().info("HikariCP startup took " + (end - start) + "ms");
            }
            catch (Exception e) {
                throw new RuntimeException("Error setting up HikariCP connection pool", e);
            }
        }
    }

    public String mariadbUrl() {
        return "jdbc:mariadb://" + this.databaseHost() + ":" + this.databasePort() + "/" + this.databaseDatabase() + "?allowPublicKeyRetrieval=" + this.databaseAllowPublicKeyRetrieval() + "&useSSL=" + this.databaseUseSSL();
    }

    public String mysqlUrl() {
        return "jdbc:mysql://" + this.databaseHost() + ":" + this.databasePort() + "/" + this.databaseDatabase() + "?allowPublicKeyRetrieval=" + this.databaseAllowPublicKeyRetrieval() + "&useSSL=" + this.databaseUseSSL();
    }

    public String h2Url() {
        return "jdbc:h2:" + Main.getInstance().getDataFolder().getAbsolutePath() + "/database-h2";
    }

    public String sqliteUrl() {
        File old = new File(Main.getInstance().getDataFolder(), "database.db");
        if (old.exists()) {
            old.renameTo(new File(Main.getInstance().getDataFolder(), "database-sqlite.db"));
        }
        return "jdbc:sqlite:" + Main.getInstance().getDataFolder().getAbsolutePath() + "/database-sqlite.db";
    }

    public void disconnect() {
        HikariDataSource dataSource = Main.dataSource;
        if (dataSource != null) {
            this.closePool();
        }
    }

    public Connection getConnection() {
        HikariDataSource dataSource = Main.dataSource;
        try {
            if (dataSource != null) {
                return dataSource.getConnection();
            }
            this.disconnect();
            this.connect();
            return dataSource.getConnection();
        }
        catch (SQLException e) {
            throw new RuntimeException("Unable to access database", e);
        }
    }

    public void closePool() {
        HikariDataSource dataSource = Main.dataSource;
        if (dataSource != null) {
            dataSource.close();
        }
    }

    public void migrateData(final @Nullable Player p, final @NotNull String type) {
        SchedulerUtils.runTaskAsynchronously((Runnable)((Object)new FoliaRunnable(){
            final database_type dbType = Main.type;

            @Override
            public void run() {
                LanguageUtils.MainCMD.MainConverter lang = new LanguageUtils.MainCMD.MainConverter();
                switch (type) {
                    case "sqlitetoh2": {
                        DatabaseConnection.this.migrateLocalDatabase(p, DatabaseConnection.this.sqliteUrl(), DatabaseConnection.this.h2Url(), "MERGE INTO " + DatabaseConnection.this.databaseTable() + " (UUID, HOME, LOCATION) KEY(UUID, HOME) VALUES (?, LEFT(?, 100), ?)");
                        break;
                    }
                    case "sqlitetomysql": {
                        DatabaseConnection.this.migrateDatabase(p, DatabaseConnection.this.sqliteUrl(), DatabaseConnection.this.mysqlUrl(), "INSERT IGNORE INTO " + DatabaseConnection.this.databaseTable() + " (UUID, HOME, LOCATION) VALUES (?, ?, ?) ON DUPLICATE KEY UPDATE LOCATION = VALUES(LOCATION)");
                        break;
                    }
                    case "sqlitetomariadb": {
                        DatabaseConnection.this.migrateDatabase(p, DatabaseConnection.this.sqliteUrl(), DatabaseConnection.this.mariadbUrl(), "INSERT IGNORE INTO " + DatabaseConnection.this.databaseTable() + " (UUID, HOME, LOCATION) VALUES (?, ?, ?) ON DUPLICATE KEY UPDATE LOCATION = VALUES(LOCATION)");
                        break;
                    }
                    case "mysqltosqlite": {
                        DatabaseConnection.this.migrateDatabase2(p, DatabaseConnection.this.mysqlUrl(), DatabaseConnection.this.sqliteUrl(), "INSERT OR REPLACE INTO " + DatabaseConnection.this.databaseTable() + " (UUID, HOME, LOCATION) VALUES (?, ?, ?)");
                        break;
                    }
                    case "mysqltoh2": {
                        DatabaseConnection.this.migrateDatabase2(p, DatabaseConnection.this.mysqlUrl(), DatabaseConnection.this.h2Url(), "MERGE INTO " + DatabaseConnection.this.databaseTable() + " (UUID, HOME, LOCATION) KEY(UUID, HOME) VALUES (?, LEFT(?, 100), ?)");
                        break;
                    }
                    case "mariadbtosqlite": {
                        DatabaseConnection.this.migrateDatabase2(p, DatabaseConnection.this.mariadbUrl(), DatabaseConnection.this.sqliteUrl(), "INSERT OR REPLACE INTO " + DatabaseConnection.this.databaseTable() + " (UUID, HOME, LOCATION) VALUES (?, ?, ?)");
                        break;
                    }
                    case "mariadbtoh2": {
                        DatabaseConnection.this.migrateDatabase2(p, DatabaseConnection.this.mariadbUrl(), DatabaseConnection.this.h2Url(), "MERGE INTO " + DatabaseConnection.this.databaseTable() + " (UUID, HOME, LOCATION) KEY(UUID, HOME) VALUES (?, LEFT(?, 100), ?)");
                        break;
                    }
                    case "h2tosqlite": {
                        DatabaseConnection.this.migrateLocalDatabase(p, DatabaseConnection.this.h2Url(), DatabaseConnection.this.sqliteUrl(), "INSERT OR REPLACE INTO " + DatabaseConnection.this.databaseTable() + " (UUID, HOME, LOCATION) VALUES (?, ?, ?)");
                        break;
                    }
                    case "h2tomysql": {
                        DatabaseConnection.this.migrateDatabase(p, DatabaseConnection.this.h2Url(), DatabaseConnection.this.mysqlUrl(), "INSERT INTO " + DatabaseConnection.this.databaseTable() + " (UUID, HOME, LOCATION) VALUES (?, ?, ?) ON DUPLICATE KEY UPDATE LOCATION = VALUES(LOCATION)");
                        break;
                    }
                    case "h2tomariadb": {
                        DatabaseConnection.this.migrateDatabase(p, DatabaseConnection.this.h2Url(), DatabaseConnection.this.mariadbUrl(), "INSERT INTO " + DatabaseConnection.this.databaseTable() + " (UUID, HOME, LOCATION) VALUES (?, ?, ?) ON DUPLICATE KEY UPDATE LOCATION = VALUES(LOCATION)");
                        break;
                    }
                    case "essentials": {
                        File directory = new File(Main.getInstance().getDataFolder() + "/../Essentials/userdata");
                        if (!directory.exists() || !directory.isDirectory()) {
                            System.out.println("Invalid directory: " + directory.getPath());
                            return;
                        }
                        try (Connection conn = DatabaseConnection.this.getConnection();){
                            String insertQuery = this.dbType.equals((Object)database_type.H2) ? "MERGE INTO " + DatabaseConnection.this.databaseTable() + " (UUID, HOME, LOCATION) KEY(UUID, HOME) VALUES (?, LEFT(?, 100), ?)" : (this.dbType.equals((Object)database_type.SQLITE) ? "INSERT OR REPLACE INTO " + DatabaseConnection.this.databaseTable() + " (UUID, HOME, LOCATION) VALUES (?, SUBSTR(?, 1, 100), ?)" : "INSERT INTO " + DatabaseConnection.this.databaseTable() + " (UUID, HOME, LOCATION) VALUES (?, LEFT(?, 100), ?) ON DUPLICATE KEY UPDATE LOCATION = VALUES(LOCATION)");
                            try (PreparedStatement pstmt = conn.prepareStatement(insertQuery);){
                                File[] files = directory.listFiles((dir, name) -> name.endsWith(".yml"));
                                if (files == null) {
                                    lang.sendMsg((CommandSender)Main.getInstance().getServer().getConsoleSender(), lang.getError());
                                }
                                assert (files != null);
                                int totalUsers = files.length;
                                System.out.println("Starting migration for " + totalUsers + " users...");
                                int count = 0;
                                int countH = 0;
                                for (File file : files) {
                                    YamlConfiguration yaml = YamlConfiguration.loadConfiguration((File)file);
                                    String uuid = file.getName().replace(".yml", "");
                                    if (!yaml.contains("homes")) {
                                        ++count;
                                        if (p == null) continue;
                                        String message = ChatColor.translateAlternateColorCodes((char)'&', (String)("&aConverting Data... &8[&7" + count + " users/" + totalUsers + " users&8]"));
                                        p.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)message));
                                        continue;
                                    }
                                    ConfigurationSection homesSection = yaml.getConfigurationSection("homes");
                                    assert (homesSection != null);
                                    for (String homeName : homesSection.getKeys(false)) {
                                        ConfigurationSection home = homesSection.getConfigurationSection(homeName);
                                        if (home == null) continue;
                                        String worldName = home.getString("world-name", "");
                                        double x = home.getDouble("x");
                                        double y = home.getDouble("y");
                                        double z = home.getDouble("z");
                                        float yaw = (float)home.getDouble("yaw");
                                        float pitch = (float)home.getDouble("pitch");
                                        String location = LocationUtils.serialize(worldName, x, y, z, yaw, pitch);
                                        pstmt.setString(1, uuid);
                                        pstmt.setString(2, homeName);
                                        pstmt.setString(3, location);
                                        pstmt.executeUpdate();
                                        ++countH;
                                    }
                                    ++count;
                                    if (p == null) continue;
                                    String message = ChatColor.translateAlternateColorCodes((char)'&', (String)("&aConverting Data... &8[&7" + count + " users/" + totalUsers + " users&8]"));
                                    p.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)message));
                                }
                                if (p != null) {
                                    String string = ChatColor.translateAlternateColorCodes((char)'&', (String)("&aConverted Data! &8[&7" + count + " users/" + totalUsers + " users&8]"));
                                    p.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)string));
                                    p.playSound(p.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 100.0f, 1.0f);
                                }
                                System.out.println("Migration completed! " + count + " users and " + countH + " homes transferred from Essentials.");
                            }
                        }
                        catch (SQLException e) {
                            Main.getInstance().getLogger().log(Level.SEVERE, "Unable to migrate data from Essentials", e);
                        }
                        break;
                    }
                    case "sethome": {
                        File directory = new File(Main.getInstance().getDataFolder() + "/../SetHome/homes");
                        if (!directory.exists() || !directory.isDirectory()) {
                            System.out.println("Invalid directory: " + directory.getPath());
                            return;
                        }
                        try (Connection conn = DatabaseConnection.this.getConnection();){
                            String insertQuery = this.dbType.equals((Object)database_type.H2) ? "MERGE INTO " + DatabaseConnection.this.databaseTable() + " (UUID, HOME, LOCATION) KEY(UUID, HOME) VALUES (?, LEFT(?, 100), ?)" : (this.dbType.equals((Object)database_type.SQLITE) ? "INSERT OR REPLACE INTO " + DatabaseConnection.this.databaseTable() + " (UUID, HOME, LOCATION) VALUES (?, SUBSTR(?, 1, 100), ?)" : "INSERT INTO " + DatabaseConnection.this.databaseTable() + " (UUID, HOME, LOCATION) VALUES (?, LEFT(?, 100), ?) ON DUPLICATE KEY UPDATE LOCATION = VALUES(LOCATION)");
                            try (PreparedStatement pstmt = conn.prepareStatement(insertQuery);){
                                File[] files = directory.listFiles((dir, name) -> name.endsWith(".yml"));
                                if (files == null) {
                                    lang.sendMsg((CommandSender)Main.getInstance().getServer().getConsoleSender(), lang.getError());
                                }
                                assert (files != null);
                                int totalUsers = files.length;
                                System.out.println("Starting migration for " + totalUsers + " users...");
                                int count = 0;
                                int countH = 0;
                                for (File file : files) {
                                    YamlConfiguration yaml = YamlConfiguration.loadConfiguration((File)file);
                                    String uuid = file.getName().replace(".yml", "");
                                    if (!yaml.contains("Homes")) {
                                        ++count;
                                        if (p == null) continue;
                                        String message = ChatColor.translateAlternateColorCodes((char)'&', (String)("&aConverting Data... &8[&7" + count + " users/" + totalUsers + " users&8]"));
                                        p.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)message));
                                        continue;
                                    }
                                    ConfigurationSection homesSection = yaml.getConfigurationSection("Homes");
                                    assert (homesSection != null);
                                    for (String homeName : homesSection.getKeys(false)) {
                                        ConfigurationSection home = homesSection.getConfigurationSection(homeName);
                                        if (home == null) continue;
                                        String worldName = home.getString("world", "");
                                        double x = home.getDouble("x");
                                        double y = home.getDouble("y");
                                        double z = home.getDouble("z");
                                        float yaw = (float)home.getDouble("yaw");
                                        float pitch = (float)home.getDouble("pitch");
                                        String location = LocationUtils.serialize(worldName, x, y, z, yaw, pitch);
                                        pstmt.setString(1, uuid);
                                        pstmt.setString(2, homeName);
                                        pstmt.setString(3, location);
                                        pstmt.executeUpdate();
                                        ++countH;
                                    }
                                    ++count;
                                    if (p == null) continue;
                                    String message = ChatColor.translateAlternateColorCodes((char)'&', (String)("&aConverting Data... &8[&7" + count + " users/" + totalUsers + " users&8]"));
                                    p.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)message));
                                }
                                if (p != null) {
                                    String string = ChatColor.translateAlternateColorCodes((char)'&', (String)("&aConverted Data! &8[&7" + count + " users/" + totalUsers + " users&8]"));
                                    p.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)string));
                                    p.playSound(p.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 100.0f, 1.0f);
                                }
                                System.out.println("Migration completed! " + count + " users and " + countH + " homes transferred from SetHome.");
                            }
                        }
                        catch (SQLException e) {
                            Main.getInstance().getLogger().log(Level.SEVERE, "Unable to migrate data from SetHome", e);
                        }
                        break;
                    }
                    case "ultimatehomes": {
                        File directory = new File(Main.getInstance().getDataFolder() + "/../UltimateHomes/playerdata");
                        if (!directory.exists() || !directory.isDirectory()) {
                            System.out.println("Invalid directory: " + directory.getPath());
                            return;
                        }
                        try (Connection conn = DatabaseConnection.this.getConnection();){
                            String insertQuery = this.dbType.equals((Object)database_type.H2) ? "MERGE INTO " + DatabaseConnection.this.databaseTable() + " (UUID, HOME, LOCATION) KEY(UUID, HOME) VALUES (?, LEFT(?, 100), ?)" : (this.dbType.equals((Object)database_type.SQLITE) ? "INSERT OR REPLACE INTO " + DatabaseConnection.this.databaseTable() + " (UUID, HOME, LOCATION) VALUES (?, SUBSTR(?, 1, 100), ?)" : "INSERT INTO " + DatabaseConnection.this.databaseTable() + " (UUID, HOME, LOCATION) VALUES (?, LEFT(?, 100), ?) ON DUPLICATE KEY UPDATE LOCATION = VALUES(LOCATION)");
                            try (PreparedStatement pstmt = conn.prepareStatement(insertQuery);){
                                File[] files = directory.listFiles((dir, name) -> name.endsWith(".yml"));
                                if (files == null) {
                                    lang.sendMsg((CommandSender)Main.getInstance().getServer().getConsoleSender(), lang.getError());
                                }
                                assert (files != null);
                                int totalUsers = files.length;
                                System.out.println("Starting migration for " + totalUsers + " users...");
                                int count = 0;
                                int countH = 0;
                                for (File file : files) {
                                    YamlConfiguration yaml = YamlConfiguration.loadConfiguration((File)file);
                                    String uuid = file.getName().replace(".yml", "");
                                    if (!yaml.contains("homes")) {
                                        ++count;
                                        if (p == null) continue;
                                        String message = ChatColor.translateAlternateColorCodes((char)'&', (String)("&aConverting Data... &8[&7" + count + " users/" + totalUsers + " users&8]"));
                                        p.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)message));
                                        continue;
                                    }
                                    ConfigurationSection homesSection = yaml.getConfigurationSection("homes");
                                    assert (homesSection != null);
                                    for (String homeName : homesSection.getKeys(false)) {
                                        ConfigurationSection home = homesSection.getConfigurationSection(homeName);
                                        if (home == null) continue;
                                        String worldName = home.getString("world", "");
                                        double x = home.getDouble("x");
                                        double y = home.getDouble("y");
                                        double z = home.getDouble("z");
                                        float yaw = (float)home.getDouble("yaw");
                                        float pitch = (float)home.getDouble("pitch");
                                        String location = LocationUtils.serialize(worldName, x, y, z, yaw, pitch);
                                        pstmt.setString(1, uuid);
                                        pstmt.setString(2, homeName);
                                        pstmt.setString(3, location);
                                        pstmt.executeUpdate();
                                        ++countH;
                                    }
                                    ++count;
                                    if (p == null) continue;
                                    String message = ChatColor.translateAlternateColorCodes((char)'&', (String)("&aConverting Data... &8[&7" + count + " users/" + totalUsers + " users&8]"));
                                    p.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)message));
                                }
                                if (p != null) {
                                    String string = ChatColor.translateAlternateColorCodes((char)'&', (String)("&aConverted Data! &8[&7" + count + " users/" + totalUsers + " users&8]"));
                                    p.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)string));
                                    p.playSound(p.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 100.0f, 1.0f);
                                }
                                System.out.println("Migration completed! " + count + " users and " + countH + " homes transferred from UltimateHomes.");
                            }
                        }
                        catch (SQLException e) {
                            Main.getInstance().getLogger().log(Level.SEVERE, "Unable to migrate data from UltimateHomes", e);
                        }
                        break;
                    }
                    case "xhomes": {
                        File file = new File(Main.getInstance().getDataFolder() + "/../Xhomes/playerhomes.yml");
                        if (!file.exists()) {
                            System.out.println("Invalid file: " + file.getPath());
                            return;
                        }
                        try (Connection conn = DatabaseConnection.this.getConnection();){
                            String insertQuery = this.dbType.equals((Object)database_type.H2) ? "MERGE INTO " + DatabaseConnection.this.databaseTable() + " (UUID, HOME, LOCATION) KEY(UUID, HOME) VALUES (?, LEFT(?, 100), ?)" : (this.dbType.equals((Object)database_type.SQLITE) ? "INSERT OR REPLACE INTO " + DatabaseConnection.this.databaseTable() + " (UUID, HOME, LOCATION) VALUES (?, SUBSTR(?, 1, 100), ?)" : "INSERT INTO " + DatabaseConnection.this.databaseTable() + " (UUID, HOME, LOCATION) VALUES (?, LEFT(?, 100), ?) ON DUPLICATE KEY UPDATE LOCATION = VALUES(LOCATION)");
                            try (PreparedStatement pstmt = conn.prepareStatement(insertQuery);){
                                YamlConfiguration fYaml = YamlConfiguration.loadConfiguration((File)file);
                                int totalUsers = fYaml.getKeys(false).size();
                                System.out.println("Starting migration for " + totalUsers + " users...");
                                int count = 0;
                                int countH = 0;
                                for (String player : fYaml.getKeys(false)) {
                                    OfflinePlayer offplayer = PlayerUtils.getOfflinePlayer(player);
                                    if (offplayer == null) {
                                        ++count;
                                        if (p == null) continue;
                                        String message = ChatColor.translateAlternateColorCodes((char)'&', (String)("&aConvertion failed, skipping user... &8[&7" + count + " users/" + totalUsers + " users&8]"));
                                        p.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)message));
                                        continue;
                                    }
                                    String uuid = offplayer.getUniqueId().toString();
                                    ConfigurationSection homesSection = fYaml.getConfigurationSection(player);
                                    assert (homesSection != null);
                                    for (String homeName : homesSection.getKeys(false)) {
                                        String[] homeS;
                                        String homeRaw = homesSection.getString(homeName);
                                        if (homeRaw == null || (homeS = homeRaw.split(",")).length != 11) continue;
                                        String worldName = homeS[0];
                                        double x = Double.parseDouble(homeS[1] + "." + homeS[2]);
                                        double y = Double.parseDouble(homeS[3] + "." + homeS[4]);
                                        double z = Double.parseDouble(homeS[5] + "." + homeS[6]);
                                        float yaw = Float.parseFloat(homeS[7] + "." + homeS[8]);
                                        float pitch = Float.parseFloat(homeS[9] + "." + homeS[10]);
                                        String location = LocationUtils.serialize(worldName, x, y, z, yaw, pitch);
                                        pstmt.setString(1, uuid);
                                        pstmt.setString(2, homeName);
                                        pstmt.setString(3, location);
                                        pstmt.addBatch();
                                        ++countH;
                                    }
                                    ++count;
                                    if (p == null) continue;
                                    String message = ChatColor.translateAlternateColorCodes((char)'&', (String)("&aConverting Data... &8[&7" + count + " users/" + totalUsers + " users&8]"));
                                    p.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)message));
                                }
                                pstmt.executeBatch();
                                if (p != null) {
                                    String string = ChatColor.translateAlternateColorCodes((char)'&', (String)("&aConverted Data! &8[&7" + count + " users/" + totalUsers + " users&8]"));
                                    p.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)string));
                                    p.playSound(p.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 100.0f, 1.0f);
                                }
                                System.out.println("Migration completed! " + count + " users and " + countH + " homes transferred from XHomes.");
                            }
                        }
                        catch (SQLException e) {
                            Main.getInstance().getLogger().log(Level.SEVERE, "Unable to migrate data from XHomes", e);
                        }
                        break;
                    }
                    case "zhome": {
                        File directory = new File(Main.getInstance().getDataFolder() + "/../zHome/homes");
                        if (!directory.exists() || !directory.isDirectory()) {
                            System.out.println("Invalid directory: " + directory.getPath());
                            return;
                        }
                        try (Connection conn = DatabaseConnection.this.getConnection();){
                            String insertQuery = this.dbType.equals((Object)database_type.H2) ? "MERGE INTO " + DatabaseConnection.this.databaseTable() + " (UUID, HOME, LOCATION) KEY(UUID, HOME) VALUES (?, LEFT(?, 100), ?)" : (this.dbType.equals((Object)database_type.SQLITE) ? "INSERT OR REPLACE INTO " + DatabaseConnection.this.databaseTable() + " (UUID, HOME, LOCATION) VALUES (?, SUBSTR(?, 1, 100), ?)" : "INSERT INTO " + DatabaseConnection.this.databaseTable() + " (UUID, HOME, LOCATION) VALUES (?, LEFT(?, 100), ?) ON DUPLICATE KEY UPDATE LOCATION = VALUES(LOCATION)");
                            try (PreparedStatement pstmt = conn.prepareStatement(insertQuery);){
                                File[] files = directory.listFiles((dir, name) -> name.endsWith(".yml"));
                                if (files == null) {
                                    lang.sendMsg((CommandSender)Main.getInstance().getServer().getConsoleSender(), lang.getError());
                                }
                                assert (files != null);
                                int totalUsers = files.length;
                                System.out.println("Starting migration for " + totalUsers + " users...");
                                int count = 0;
                                int countH = 0;
                                for (File file : files) {
                                    Object message;
                                    YamlConfiguration yaml = YamlConfiguration.loadConfiguration((File)file);
                                    String uuid = file.getName().replace(".yml", "");
                                    if (yaml.getKeys(false).isEmpty()) {
                                        ++count;
                                        if (p == null) continue;
                                        message = ChatColor.translateAlternateColorCodes((char)'&', (String)("&aConverting Data... &8[&7" + count + " users/" + totalUsers + " users&8]"));
                                        p.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)message));
                                        continue;
                                    }
                                    for (String homeName : yaml.getKeys(false)) {
                                        ConfigurationSection home = yaml.getConfigurationSection(homeName);
                                        if (home == null) continue;
                                        String worldName = home.getString("world", "");
                                        double x = home.getDouble("x");
                                        double y = home.getDouble("y");
                                        double z = home.getDouble("z");
                                        float yaw = (float)home.getDouble("yaw");
                                        float pitch = (float)home.getDouble("pitch");
                                        String location = LocationUtils.serialize(worldName, x, y, z, yaw, pitch);
                                        pstmt.setString(1, uuid);
                                        pstmt.setString(2, homeName);
                                        pstmt.setString(3, location);
                                        pstmt.executeUpdate();
                                        ++countH;
                                    }
                                    ++count;
                                    if (p == null) continue;
                                    message = ChatColor.translateAlternateColorCodes((char)'&', (String)("&aConverting Data... &8[&7" + count + " users/" + totalUsers + " users&8]"));
                                    p.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)message));
                                }
                                if (p != null) {
                                    String string = ChatColor.translateAlternateColorCodes((char)'&', (String)("&aConverted Data! &8[&7" + count + " users/" + totalUsers + " users&8]"));
                                    p.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)string));
                                    p.playSound(p.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 100.0f, 1.0f);
                                }
                                System.out.println("Migration completed! " + count + " users and " + countH + " homes transferred from Essentials.");
                            }
                        }
                        catch (SQLException e) {
                            Main.getInstance().getLogger().log(Level.SEVERE, "Unable to migrate data from Essentials", e);
                        }
                        break;
                    }
                    default: {
                        if (p == null) break;
                        lang.sendMsg(p, lang.getUsage());
                    }
                }
            }
        }));
    }

    private void migrateDatabase(Player p, String sourceUrl, String targetUrl, String insertQuery) {
        this.disconnect();
        try (Connection sourceConn = DriverManager.getConnection(sourceUrl);
             Connection targetConn = DriverManager.getConnection(targetUrl, this.databaseUsername(), this.databasePassword());){
            System.out.println("Connected to both source and target databases.");
            try (Statement stmt = sourceConn.createStatement();
                 ResultSet countResult = stmt.executeQuery("SELECT COUNT(*) AS total FROM " + this.databaseTable());){
                countResult.next();
                int totalRows = countResult.getInt("total");
                if (totalRows == 0) {
                    System.out.println("No data to migrate.");
                    return;
                }
                System.out.println("Starting migration of " + totalRows + " records...");
                try (ResultSet resultSet = stmt.executeQuery("SELECT UUID, HOME, LOCATION FROM " + this.databaseTable());
                     PreparedStatement pstmt = targetConn.prepareStatement(insertQuery);){
                    int count = 0;
                    while (resultSet.next()) {
                        pstmt.setString(1, resultSet.getString("UUID"));
                        pstmt.setString(2, resultSet.getString("HOME"));
                        pstmt.setString(3, resultSet.getString("LOCATION"));
                        pstmt.executeUpdate();
                        this.updateProgress(p, ++count, totalRows);
                    }
                    this.completeMigration(p, count, totalRows);
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.connect();
    }

    private void migrateDatabase2(Player p, String sourceUrl, String targetUrl, String insertQuery) {
        this.disconnect();
        try (Connection sourceConn = DriverManager.getConnection(sourceUrl, this.databaseUsername(), this.databasePassword());
             Connection targetConn = DriverManager.getConnection(targetUrl);){
            System.out.println("Connected to both source and target databases.");
            try (Statement stmt = sourceConn.createStatement();
                 ResultSet countResult = stmt.executeQuery("SELECT COUNT(*) AS total FROM " + this.databaseTable());){
                countResult.next();
                int totalRows = countResult.getInt("total");
                if (totalRows == 0) {
                    System.out.println("No data to migrate.");
                    return;
                }
                System.out.println("Starting migration of " + totalRows + " records...");
                try (ResultSet resultSet = stmt.executeQuery("SELECT UUID, HOME, LOCATION FROM " + this.databaseTable());
                     PreparedStatement pstmt = targetConn.prepareStatement(insertQuery);){
                    int count = 0;
                    while (resultSet.next()) {
                        pstmt.setString(1, resultSet.getString("UUID"));
                        pstmt.setString(2, resultSet.getString("HOME"));
                        pstmt.setString(3, resultSet.getString("LOCATION"));
                        pstmt.executeUpdate();
                        this.updateProgress(p, ++count, totalRows);
                    }
                    this.completeMigration(p, count, totalRows);
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.connect();
    }

    private void migrateLocalDatabase(Player p, String sourceUrl, String targetUrl, String insertQuery) {
        this.disconnect();
        try (Connection sourceConn = DriverManager.getConnection(sourceUrl);
             Connection targetConn = DriverManager.getConnection(targetUrl);){
            System.out.println("Connected to both source and target databases.");
            try (Statement stmt = sourceConn.createStatement();
                 ResultSet countResult = stmt.executeQuery("SELECT COUNT(*) AS total FROM " + this.databaseTable());){
                countResult.next();
                int totalRows = countResult.getInt("total");
                if (totalRows == 0) {
                    System.out.println("No data to migrate.");
                    return;
                }
                System.out.println("Starting migration of " + totalRows + " records...");
                try (ResultSet resultSet = stmt.executeQuery("SELECT UUID, HOME, LOCATION FROM " + this.databaseTable());
                     PreparedStatement pstmt = targetConn.prepareStatement(insertQuery);){
                    int count = 0;
                    while (resultSet.next()) {
                        pstmt.setString(1, resultSet.getString("UUID"));
                        pstmt.setString(2, resultSet.getString("HOME"));
                        pstmt.setString(3, resultSet.getString("LOCATION"));
                        pstmt.executeUpdate();
                        this.updateProgress(p, ++count, totalRows);
                    }
                    this.completeMigration(p, count, totalRows);
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.connect();
    }

    private void updateProgress(Player p, int count, int totalRows) {
        if (p != null) {
            String message = ChatColor.translateAlternateColorCodes((char)'&', (String)("&aConverting Data... &8[&7" + count + "/" + totalRows + "&8]"));
            p.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)message));
        }
    }

    private void completeMigration(Player p, int count, int totalRows) {
        if (p != null) {
            String message = ChatColor.translateAlternateColorCodes((char)'&', (String)("&aConverted Data! &8[&7" + count + "/" + totalRows + "&8]"));
            p.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)message));
            p.playSound(p.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 100.0f, 1.0f);
        }
        System.out.println("\nMigration completed! " + count + " records transferred.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean existsTableColumnValue(String table, String columnName, String value) {
        try (Connection con = this.getConnection();
             PreparedStatement ps = con.prepareStatement("SELECT * FROM " + table + " WHERE " + columnName + "=?");){
            ps.setString(1, value);
            try (ResultSet results = ps.executeQuery();){
                if (!results.next()) return false;
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean existsTableColumnValueDouble(String table, String columnName, String value, String columnName2, String value2) {
        try (Connection con = this.getConnection();
             PreparedStatement ps = con.prepareStatement("SELECT * FROM " + table + " WHERE " + columnName + "=? AND " + columnName2 + "=?");){
            ps.setString(1, value);
            ps.setString(2, value2);
            try (ResultSet results = ps.executeQuery();){
                if (!results.next()) return false;
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static class DriverShim
    implements Driver {
        private final Driver driver;

        public DriverShim(Driver driver) {
            this.driver = driver;
        }

        @Override
        public boolean acceptsURL(String u) throws SQLException {
            return this.driver.acceptsURL(u);
        }

        @Override
        public Connection connect(String u, Properties p) throws SQLException {
            return this.driver.connect(u, p);
        }

        @Override
        public int getMajorVersion() {
            return this.driver.getMajorVersion();
        }

        @Override
        public int getMinorVersion() {
            return this.driver.getMinorVersion();
        }

        @Override
        public DriverPropertyInfo[] getPropertyInfo(String u, Properties p) throws SQLException {
            return this.driver.getPropertyInfo(u, p);
        }

        @Override
        public boolean jdbcCompliant() {
            return this.driver.jdbcCompliant();
        }

        @Override
        public Logger getParentLogger() throws SQLFeatureNotSupportedException {
            return this.driver.getParentLogger();
        }
    }
}

