/*
 * Decompiled with CFR 0.152.
 */
package me.yleoft.zHomes.storage;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import me.yleoft.zHomes.Main;
import me.yleoft.zHomes.storage.DatabaseConnection;
import me.yleoft.zHomes.storage.database_type;
import org.bukkit.OfflinePlayer;

public class DatabaseEditor
extends DatabaseConnection {
    public void createTable(String table, String coluns) {
        try (Connection con = this.getConnection();
             PreparedStatement ps = con.prepareStatement("CREATE TABLE IF NOT EXISTS " + table + coluns);){
            ps.executeUpdate();
        }
        catch (SQLException e) {
            Main.getInstance().getLogger().log(Level.SEVERE, "Error creating table: " + table, e);
        }
    }

    public void renameTable(String oldtable, String newtable) {
        try (Connection con = this.getConnection();
             PreparedStatement ps = con.prepareStatement("ALTER TABLE " + oldtable + " RENAME TO " + newtable);){
            ps.executeUpdate();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void setHome(OfflinePlayer p, String home, String location) {
        block26: {
            database_type type = Main.type;
            try (Connection con = this.getConnection();){
                if (this.isInTable(p, home)) {
                    try (PreparedStatement ps = con.prepareStatement("UPDATE " + this.databaseTable() + " SET LOCATION=? WHERE UUID=? AND HOME=?");){
                        String uuid = p.getUniqueId().toString();
                        ps.setString(1, location);
                        ps.setString(2, uuid);
                        ps.setString(3, home);
                        ps.executeUpdate();
                        break block26;
                    }
                }
                String query = "INSERT OR IGNORE INTO " + this.databaseTable() + " (UUID,HOME,LOCATION) VALUES (?,?,?)";
                switch (type) {
                    case SQLITE: {
                        query = "INSERT OR IGNORE INTO " + this.databaseTable() + " (UUID,HOME,LOCATION) VALUES (?,?,?)";
                        break;
                    }
                    case H2: {
                        query = "MERGE INTO " + this.databaseTable() + " KEY(UUID, HOME) VALUES (?, ?, ?)";
                        break;
                    }
                    case EXTERNAL: {
                        query = "INSERT IGNORE INTO " + this.databaseTable() + " (UUID,HOME,LOCATION) VALUES (?,?,?)";
                    }
                }
                try (PreparedStatement ps = con.prepareStatement(query);){
                    String uuid = p.getUniqueId().toString();
                    ps.setString(1, uuid);
                    ps.setString(2, home);
                    ps.setString(3, location);
                    ps.executeUpdate();
                }
            }
            catch (SQLException e) {
                Main.getInstance().getLogger().log(Level.SEVERE, "Error setting home for player: " + p.getName(), e);
            }
        }
    }

    public void deleteHome(OfflinePlayer p, String home) {
        try (Connection con = this.getConnection();
             PreparedStatement ps2 = con.prepareStatement("DELETE FROM " + this.databaseTable() + " WHERE UUID=? AND HOME=?");){
            String uuid = p.getUniqueId().toString();
            ps2.setString(1, uuid);
            ps2.setString(2, home);
            ps2.executeUpdate();
        }
        catch (SQLException e) {
            Main.getInstance().getLogger().log(Level.SEVERE, "Error deleting home for player: " + p.getName(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getHome(OfflinePlayer p, String home) {
        try (Connection con = this.getConnection();){
            if (!this.isInTable(p, home)) return "";
            try (PreparedStatement ps = con.prepareStatement("SELECT LOCATION from " + this.databaseTable() + " WHERE UUID=? AND HOME=?");){
                String uuid = p.getUniqueId().toString();
                ps.setString(1, uuid);
                ps.setString(2, home);
                try (ResultSet rs = ps.executeQuery();){
                    if (!rs.next()) return "";
                    String returned = rs.getString("LOCATION");
                    rs.close();
                    ps.close();
                    String string = returned;
                    return string;
                }
            }
        }
        catch (SQLException e) {
            Main.getInstance().getLogger().log(Level.SEVERE, "Error getting homes for player: " + p.getName(), e);
        }
        return "";
    }

    public List<String> getHomes(OfflinePlayer p) {
        ArrayList<String> list = new ArrayList<String>();
        try (Connection con = this.getConnection();
             PreparedStatement ps = con.prepareStatement("SELECT * FROM " + this.databaseTable() + " WHERE UUID=?");){
            ps.setString(1, p.getUniqueId().toString());
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    list.add(rs.getString("HOME"));
                }
            }
        }
        catch (SQLException e) {
            Main.getInstance().getLogger().log(Level.SEVERE, "Error getting homes for player: " + p.getName(), e);
        }
        return list;
    }

    public boolean isInTable(OfflinePlayer p, String home) {
        try {
            String uuid = p.getUniqueId().toString();
            if (this.existsTableColumnValueDouble(this.databaseTable(), "UUID", uuid, "HOME", home)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

