/*
 * Decompiled with CFR 0.152.
 */
package me.yleoft.zHomes.shaded.zAPI.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import me.yleoft.zHomes.shaded.nbtapi.NBT;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NbtUtils {
    public static void markItem(@NotNull ItemStack item, @NotNull String mark, boolean value) {
        NBT.modify(item, nbt -> nbt.setBoolean(mark, value));
    }

    public static void markItem(@NotNull ItemStack item, @NotNull String mark) {
        NbtUtils.markItem(item, mark, true);
    }

    public static void unmarkItem(@NotNull ItemStack item, @NotNull String mark) {
        NBT.modify(item, nbt -> nbt.setBoolean(mark, false));
    }

    public static void removeMark(@NotNull ItemStack item, @NotNull String mark) {
        NBT.modify(item, nbt -> nbt.removeKey(mark));
    }

    public static boolean isMarked(@NotNull ItemStack item, @NotNull String mark) {
        return NBT.get(item, nbt -> {
            if (!nbt.hasTag(mark)) {
                return false;
            }
            return nbt.getBoolean(mark);
        });
    }

    public static boolean hasMark(@NotNull ItemStack item, @NotNull String mark) {
        return NBT.get(item, nbt -> nbt.hasTag(mark));
    }

    public static void addCustomCommand(@NotNull ItemStack item, @NotNull String command, @Nullable Map<String, String> replaces, boolean isConsole) {
        NBT.modify(item, nbt -> {
            String customCommand = command;
            if (replaces != null) {
                for (String key : replaces.keySet()) {
                    customCommand = customCommand.replace(key, (CharSequence)replaces.get(key));
                }
            }
            if (isConsole) {
                customCommand = "[CON]" + customCommand;
            }
            if (nbt.hasTag("zAPI:customCommand")) {
                if (nbt.getString("zAPI:customCommand").contains(customCommand)) {
                    return;
                }
                customCommand = nbt.getString("zAPI:customCommand") + "||" + customCommand;
            }
            nbt.setString("zAPI:customCommand", customCommand);
        });
    }

    public static void addCustomCommands(@NotNull ItemStack item, @NotNull List<String> commands, @Nullable Map<String, String> replaces, boolean isConsole) {
        for (String command : commands) {
            NbtUtils.addCustomCommand(item, command, replaces, isConsole);
        }
    }

    public static void addCustomCommands(@NotNull ItemStack item, @NotNull List<String> commands, boolean isConsole) {
        for (String command : commands) {
            NbtUtils.addCustomCommand(item, command, null, isConsole);
        }
    }

    public static void addCustomCommands(@NotNull ItemStack item, @NotNull List<String> commands) {
        for (String command : commands) {
            NbtUtils.addCustomCommand(item, command);
        }
    }

    public static void addCustomCommands(@NotNull ItemStack item, @NotNull List<String> commands, @Nullable Map<String, String> replaces) {
        for (String command : commands) {
            NbtUtils.addCustomCommand(item, command, replaces);
        }
    }

    public static void addCustomCommand(@NotNull ItemStack item, @NotNull String command, @Nullable Map<String, String> replaces) {
        NbtUtils.addCustomCommand(item, command, replaces, false);
    }

    public static void addCustomCommand(@NotNull ItemStack item, @NotNull String command) {
        NbtUtils.addCustomCommand(item, command, null);
    }

    public static void removeCustomCommand(@NotNull ItemStack item, @NotNull String command) {
        NBT.modify(item, nbt -> {
            String customCommand = nbt.getString("zAPI:customCommand");
            if (customCommand.equals(command)) {
                nbt.removeKey("zAPI:customCommand");
            }
            if (customCommand.contains("||") || customCommand.contains(command)) {
                if (customCommand.contains(command + "||")) {
                    customCommand = customCommand.replace(command + "||", "");
                }
                if (customCommand.contains("||" + command)) {
                    customCommand = customCommand.replace("||" + command, "");
                }
                nbt.setString("zAPI:customCommand", customCommand);
            }
        });
    }

    public static void removeCustomCommands(@NotNull ItemStack item) {
        NBT.modify(item, nbt -> nbt.removeKey("zAPI:customCommand"));
    }

    public static List<String> getCustomCommands(@NotNull ItemStack item) {
        return NBT.get(item, nbt -> {
            ArrayList<Object> commands = new ArrayList();
            if (nbt.hasTag("zAPI:customCommand")) {
                commands = new ArrayList<String>(Arrays.asList(nbt.getString("zAPI:customCommand").split("\\|\\|")));
            }
            return commands;
        });
    }
}

