/*
 * Decompiled with CFR 0.152.
 */
package me.yleoft.zHomes.shaded.zAPI.utils;

import io.papermc.paper.threadedregions.scheduler.GlobalRegionScheduler;
import io.papermc.paper.threadedregions.scheduler.RegionScheduler;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import me.yleoft.zHomes.shaded.zAPI.folia.FoliaRunnable;
import me.yleoft.zHomes.shaded.zAPI.zAPI;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SchedulerUtils {
    public static void runTaskLater(@Nullable Location loc, @NotNull Runnable task, long delay) {
        JavaPlugin plugin = zAPI.getPlugin();
        if (zAPI.isFolia()) {
            try {
                if (loc != null) {
                    Method getRegionScheduler = plugin.getServer().getClass().getMethod("getRegionScheduler", new Class[0]);
                    RegionScheduler regionScheduler = (RegionScheduler)getRegionScheduler.invoke((Object)plugin.getServer(), new Object[0]);
                    regionScheduler.runDelayed((Plugin)plugin, loc, scheduledTask -> task.run(), delay);
                } else {
                    Method getGlobalScheduler = plugin.getServer().getClass().getMethod("getGlobalRegionScheduler", new Class[0]);
                    GlobalRegionScheduler globalScheduler = (GlobalRegionScheduler)getGlobalScheduler.invoke((Object)plugin.getServer(), new Object[0]);
                    globalScheduler.runDelayed((Plugin)plugin, scheduledTask -> task.run(), delay);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return;
        }
        plugin.getServer().getScheduler().runTaskLater((Plugin)plugin, task, delay);
    }

    public static void runTaskTimer(@Nullable Location loc, @NotNull FoliaRunnable runnable, long delay, long period) {
        JavaPlugin plugin = zAPI.getPlugin();
        if (zAPI.isFolia()) {
            try {
                ScheduledTask task;
                if (loc != null) {
                    Method getRegionScheduler = plugin.getServer().getClass().getMethod("getRegionScheduler", new Class[0]);
                    RegionScheduler regionScheduler = (RegionScheduler)getRegionScheduler.invoke((Object)plugin.getServer(), new Object[0]);
                    task = regionScheduler.runAtFixedRate((Plugin)plugin, loc, t -> runnable.run(), delay, period);
                } else {
                    Method getGlobalScheduler = plugin.getServer().getClass().getMethod("getGlobalRegionScheduler", new Class[0]);
                    GlobalRegionScheduler globalScheduler = (GlobalRegionScheduler)getGlobalScheduler.invoke((Object)plugin.getServer(), new Object[0]);
                    task = globalScheduler.runAtFixedRate((Plugin)plugin, t -> runnable.run(), delay, period);
                }
                runnable.setScheduledTask(task);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return;
        }
        BukkitTask task = runnable.runTaskTimer((Plugin)plugin, delay, period);
        runnable.setBukkitTask(task);
    }

    public static void runTaskLaterAsynchronously(@Nullable Location loc, @NotNull Runnable task, long delay) {
        JavaPlugin plugin = zAPI.getPlugin();
        if (zAPI.isFolia()) {
            try {
                if (loc != null) {
                    Method getRegionScheduler = plugin.getServer().getClass().getMethod("getRegionScheduler", new Class[0]);
                    RegionScheduler regionScheduler = (RegionScheduler)getRegionScheduler.invoke((Object)plugin.getServer(), new Object[0]);
                    regionScheduler.runDelayed((Plugin)plugin, loc, scheduledTask -> task.run(), delay);
                } else {
                    Method getGlobalScheduler = plugin.getServer().getClass().getMethod("getGlobalRegionScheduler", new Class[0]);
                    GlobalRegionScheduler globalScheduler = (GlobalRegionScheduler)getGlobalScheduler.invoke((Object)plugin.getServer(), new Object[0]);
                    globalScheduler.runDelayed((Plugin)plugin, scheduledTask -> task.run(), delay);
                }
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        plugin.getServer().getScheduler().runTaskLaterAsynchronously((Plugin)plugin, task, delay);
    }

    public static void runTaskTimerAsynchronously(final @NotNull FoliaRunnable runnable, long delay, final long period) {
        final JavaPlugin plugin = zAPI.getPlugin();
        if (zAPI.isFolia()) {
            try {
                Method getGlobalScheduler = plugin.getServer().getClass().getMethod("getGlobalRegionScheduler", new Class[0]);
                final GlobalRegionScheduler globalScheduler = (GlobalRegionScheduler)getGlobalScheduler.invoke((Object)plugin.getServer(), new Object[0]);
                class AsyncRepeatingTask {
                    AsyncRepeatingTask() {
                    }

                    void start(long initialDelay) {
                        ScheduledTask task = globalScheduler.runDelayed((Plugin)plugin, t -> {
                            runnable.run();
                            this.start(period);
                        }, initialDelay);
                        runnable.setScheduledTask(task);
                    }
                }
                new AsyncRepeatingTask().start(delay);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return;
        }
        BukkitTask task = runnable.runTaskTimerAsynchronously((Plugin)plugin, delay, period);
        runnable.setBukkitTask(task);
    }

    public static void runTaskAsynchronously(@NotNull Runnable task) {
        JavaPlugin plugin = zAPI.getPlugin();
        if (zAPI.isFolia()) {
            try {
                Method getGlobalScheduler = plugin.getServer().getClass().getMethod("getGlobalRegionScheduler", new Class[0]);
                GlobalRegionScheduler globalScheduler = (GlobalRegionScheduler)getGlobalScheduler.invoke((Object)plugin.getServer(), new Object[0]);
                globalScheduler.execute((Plugin)plugin, task);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return;
        }
        plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)plugin, task);
    }

    public static void runTask(@Nullable Location loc, @NotNull Runnable task) {
        JavaPlugin plugin = zAPI.getPlugin();
        if (zAPI.isFolia()) {
            try {
                if (loc != null) {
                    Method getRegionScheduler = plugin.getServer().getClass().getMethod("getRegionScheduler", new Class[0]);
                    RegionScheduler regionScheduler = (RegionScheduler)getRegionScheduler.invoke((Object)plugin.getServer(), new Object[0]);
                    regionScheduler.execute((Plugin)plugin, loc, task);
                } else {
                    Method getGlobalScheduler = plugin.getServer().getClass().getMethod("getGlobalRegionScheduler", new Class[0]);
                    GlobalRegionScheduler globalScheduler = (GlobalRegionScheduler)getGlobalScheduler.invoke((Object)plugin.getServer(), new Object[0]);
                    globalScheduler.execute((Plugin)plugin, task);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return;
        }
        plugin.getServer().getScheduler().runTask((Plugin)plugin, task);
    }

    public static <T> CompletableFuture<T> callSyncMethod(@Nullable Location loc, @NotNull Callable<T> task) {
        JavaPlugin plugin = zAPI.getPlugin();
        if (zAPI.isFolia()) {
            CompletableFuture future = new CompletableFuture();
            try {
                if (loc != null) {
                    Method getRegionScheduler = plugin.getServer().getClass().getMethod("getRegionScheduler", new Class[0]);
                    RegionScheduler regionScheduler = (RegionScheduler)getRegionScheduler.invoke((Object)plugin.getServer(), new Object[0]);
                    regionScheduler.execute((Plugin)plugin, loc, () -> {
                        try {
                            future.complete(task.call());
                        }
                        catch (Exception e) {
                            future.completeExceptionally(e);
                        }
                    });
                } else {
                    Method getGlobalScheduler = plugin.getServer().getClass().getMethod("getGlobalRegionScheduler", new Class[0]);
                    GlobalRegionScheduler globalScheduler = (GlobalRegionScheduler)getGlobalScheduler.invoke((Object)plugin.getServer(), new Object[0]);
                    globalScheduler.execute((Plugin)plugin, () -> {
                        try {
                            future.complete(task.call());
                        }
                        catch (Exception e) {
                            future.completeExceptionally(e);
                        }
                    });
                }
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
            return future;
        }
        CompletableFuture cf = new CompletableFuture();
        try {
            Future bukkitFuture = plugin.getServer().getScheduler().callSyncMethod((Plugin)plugin, task);
            plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
                try {
                    Object result = bukkitFuture.get();
                    cf.complete(result);
                }
                catch (Throwable ex) {
                    cf.completeExceptionally(ex);
                }
            });
        }
        catch (Throwable e) {
            cf.completeExceptionally(e);
        }
        return cf;
    }
}

