/*
 * Decompiled with CFR 0.152.
 */
package me.yleoft.zHomes.shaded.zAPI.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.clip.placeholderapi.PlaceholderAPI;
import me.yleoft.zHomes.shaded.zAPI.zAPI;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StringUtils {
    public static boolean startsWithIgnoreCase(@NotNull String full, @NotNull String prefix) {
        if (prefix.length() > full.length()) {
            return false;
        }
        return full.substring(0, prefix.length()).equalsIgnoreCase(prefix);
    }

    @NotNull
    public static String transform(@Nullable OfflinePlayer p, @NotNull String string) {
        string = StringUtils.hex(string);
        string = StringUtils.color(string);
        string = StringUtils.applyPlaceholders(p, string);
        return string;
    }

    @NotNull
    public static String transform(@NotNull String string) {
        return StringUtils.transform(null, string);
    }

    @NotNull
    public static String applyPlaceholders(@Nullable OfflinePlayer p, @NotNull String string) {
        if (p != null && zAPI.getPlugin().getServer().getPluginManager().getPlugin("PlaceholderAPI") != null) {
            string = PlaceholderAPI.setPlaceholders((OfflinePlayer)p, (String)string);
        }
        return StringUtils.applyOwnPlaceholders(p, string);
    }

    @NotNull
    public static String applyOwnPlaceholders(@Nullable OfflinePlayer p, @NotNull String string) {
        return zAPI.getPlaceholderAPIHandler().applyPlaceholders(p, string);
    }

    @NotNull
    public static String color(@NotNull String string) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)string);
    }

    @NotNull
    public static String hex(@NotNull String string) {
        Pattern pattern = Pattern.compile("&#([A-Fa-f0-9]{6})");
        Matcher matcher = pattern.matcher(string);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String hex = matcher.group(1);
            StringBuilder replacement = new StringBuilder("&x");
            for (int i = 0; i < hex.length(); ++i) {
                replacement.append("&").append(hex.charAt(i));
            }
            matcher.appendReplacement(result, Matcher.quoteReplacement(replacement.toString()));
        }
        matcher.appendTail(result);
        return result.toString();
    }

    public static boolean isInteger(@NotNull String strNum) {
        try {
            Integer.parseInt(strNum);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    public static long parseAsTime(@NotNull String time) {
        return TimeParser.parseTimeToMilliseconds(time);
    }

    public static String parseAsString(long time) {
        return TimeParser.formatMsToString(time);
    }

    private static class TimeParser {
        private static final long MS_IN_YEAR = 31536000000L;
        private static final long MS_IN_MONTH = 2592000000L;
        private static final long MS_IN_WEEK = 604800000L;
        private static final long MS_IN_DAY = 86400000L;
        private static final long MS_IN_HOUR = 3600000L;
        private static final long MS_IN_MINUTE = 60000L;
        private static final Pattern TIME_PATTERN = Pattern.compile("(\\d+)(y|mo|w|d|h|m|s)", 2);

        private TimeParser() {
        }

        public static long parseTimeToMilliseconds(String timeString) {
            if (timeString == null || timeString.isEmpty()) {
                throw new IllegalArgumentException("Time string cannot be null or empty");
            }
            Matcher matcher = TIME_PATTERN.matcher(timeString);
            long totalMs = 0L;
            block18: while (matcher.find()) {
                String unit;
                long value = Long.parseLong(matcher.group(1));
                switch (unit = matcher.group(2).toLowerCase()) {
                    case "y": {
                        totalMs += value * 31536000000L;
                        continue block18;
                    }
                    case "mo": {
                        totalMs += value * 2592000000L;
                        continue block18;
                    }
                    case "w": {
                        totalMs += value * 604800000L;
                        continue block18;
                    }
                    case "d": {
                        totalMs += value * 86400000L;
                        continue block18;
                    }
                    case "h": {
                        totalMs += value * 3600000L;
                        continue block18;
                    }
                    case "m": {
                        totalMs += value * 60000L;
                        continue block18;
                    }
                    case "s": {
                        totalMs += value * 1000L;
                        continue block18;
                    }
                }
                throw new IllegalArgumentException("Unknown time unit: " + unit);
            }
            return totalMs;
        }

        public static String formatMsToString(long totalMs) {
            long seconds;
            long minutes;
            long hours;
            long days;
            long weeks;
            long months;
            if (totalMs <= 0L) {
                return "0s";
            }
            StringBuilder sb = new StringBuilder();
            long years = totalMs / 31536000000L;
            if (years > 0L) {
                sb.append(years).append("y");
                totalMs %= 31536000000L;
            }
            if ((months = totalMs / 2592000000L) > 0L) {
                sb.append(months).append("mo");
                totalMs %= 2592000000L;
            }
            if ((weeks = totalMs / 604800000L) > 0L) {
                sb.append(weeks).append("w");
                totalMs %= 604800000L;
            }
            if ((days = totalMs / 86400000L) > 0L) {
                sb.append(days).append("d");
                totalMs %= 86400000L;
            }
            if ((hours = totalMs / 3600000L) > 0L) {
                sb.append(hours).append("h");
                totalMs %= 3600000L;
            }
            if ((minutes = totalMs / 60000L) > 0L) {
                sb.append(minutes).append("m");
                totalMs %= 60000L;
            }
            if ((seconds = totalMs / 1000L) > 0L) {
                sb.append(seconds).append("s");
            }
            return sb.toString();
        }
    }
}

