/*
 * Decompiled with CFR 0.152.
 */
package top.syshub.lLobby.Command;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import top.syshub.lLobby.LLobby;
import top.syshub.lLobby.Manager.LocationManager;

public class LLobbyAdminCommand
implements TabExecutor {
    @ParametersAreNonnullByDefault
    public List<String> onTabComplete(CommandSender sender, Command cmd, String label, String[] args) {
        if (args.length == 1) {
            return List.of("reload", "add", "remove");
        }
        if (args.length == 2 && args[0].equals("remove")) {
            return LocationManager.worlds.keySet().stream().toList();
        }
        if (args.length == 3 && args[0].equals("remove")) {
            return ((Map)LocationManager.worlds.getOrDefault(args[1], new HashMap())).keySet().stream().toList();
        }
        return List.of();
    }

    @ParametersAreNonnullByDefault
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            return false;
        }
        try {
            if (args.length == 1 && args[0].equals("reload")) {
                LLobby.plugin.loadConfig();
                return true;
            }
            if ((args.length == 2 || args.length == 3) && args[0].equals("add")) {
                LLobbyAdminCommand.executeAdd((Player)sender, args[1], args.length == 3 ? args[2] : null);
                return true;
            }
            if (args.length == 3 && args[0].equals("remove")) {
                LLobbyAdminCommand.executeRemove((Player)sender, args[1], args[2]);
                return true;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return false;
    }

    private static void executeAdd(Player sender, String locationName, String nickName) throws IOException {
        List oldWorlds;
        Location senderLocation = sender.getLocation();
        String world = Objects.requireNonNull(senderLocation.getWorld()).getName();
        if (LocationManager.worlds.containsKey(world) && LocationManager.worlds.get(world).containsKey(locationName)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + locationName + "\u5df2\u5b58\u5728");
            return;
        }
        List<Float> location = List.of(Double.valueOf(senderLocation.getX()), Double.valueOf(senderLocation.getY()), Double.valueOf(senderLocation.getZ()), Float.valueOf(senderLocation.getYaw()), Float.valueOf(senderLocation.getPitch()));
        if (nickName == null) {
            nickName = locationName;
        }
        if ((oldWorlds = LLobby.config.getMapList("worlds")).stream().filter(p -> world.equals(p.get("name"))).findFirst().isEmpty()) {
            oldWorlds.add(Map.of("name", world, "nick", LocationManager.nicknames.getOrDefault(world, world), "locations", List.of(Map.of("name", locationName, "nick", nickName, "position", location))));
            LLobby.config.set("worlds", (Object)oldWorlds);
            LLobby.plugin.saveConfig();
            LLobby.plugin.loadConfig();
        } else {
            List oldLocations = oldWorlds.stream().filter(p -> p.get("name").equals(world)).findFirst().map(p -> (List)p.get("locations")).orElse(new ArrayList());
            ArrayList<Map<String, List<Float>>> newLocations = new ArrayList<Map<String, List<Float>>>(oldLocations);
            newLocations.add(Map.of("name", locationName, "nick", nickName, "position", location));
            LLobbyAdminCommand.setNewWorlds(oldWorlds, world, newLocations);
        }
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + locationName + "\u5df2\u6dfb\u52a0");
    }

    private static void executeRemove(Player sender, String world, String locationName) throws IOException {
        if (!LocationManager.worlds.containsKey(world) || !LocationManager.worlds.get(world).containsKey(locationName)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + locationName + "\u4e0d\u5b58\u5728");
            return;
        }
        List oldWorlds = LLobby.config.getMapList("worlds");
        ArrayList<Object> newLocations = new ArrayList<Object>(((List)oldWorlds.stream().filter(p -> p.get("name").equals(world)).findFirst().map(p -> (List)p.get("locations")).orElse(new ArrayList())).stream().filter(p -> !((Map)p).get("name").equals(locationName)).toList());
        LLobbyAdminCommand.setNewWorlds(oldWorlds, world, newLocations);
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + locationName + "\u5df2\u79fb\u9664");
    }

    private static void setNewWorlds(List<Map<?, ?>> oldWorlds, String world, List<?> newLocations) throws IOException {
        ArrayList<Map> newWorlds = new ArrayList<Map>(oldWorlds.stream().filter(p -> !p.get("name").equals(world)).toList());
        newWorlds.add(oldWorlds.stream().filter(p -> p.get("name").equals(world)).findFirst().map(p -> {
            HashMap<String, Object> newWorld = new HashMap<String, Object>();
            newWorld.put("name", world);
            newWorld.put("nick", LocationManager.nicknames.getOrDefault(world, world));
            newWorld.put("locations", newLocations);
            return newWorld;
        }).orElse(null));
        newWorlds.remove(null);
        LLobby.config.set("worlds", newWorlds);
        LLobby.plugin.saveConfig();
        LLobby.plugin.loadConfig();
    }
}

