/*
 * Decompiled with CFR 0.152.
 */
package top.syshub.lLobby.Hook;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.PluginMessageListener;
import top.syshub.lLobby.LLobby;
import top.syshub.lLobby.Manager.FakePlayerManager;
import top.syshub.lLobby.Manager.TabManager;

public class BungeeMessage
implements PluginMessageListener {
    public static Map<String, Set<String>> playerList = new ConcurrentHashMap<String, Set<String>>();
    public static Map<String, UUID> uuidMap = new ConcurrentHashMap<String, UUID>();
    public static String server;

    public void onPluginMessageReceived(String channel, @Nonnull Player player, @Nonnull byte[] message) {
        if (!channel.equals("BungeeCord")) {
            return;
        }
        ByteArrayDataInput in = ByteStreams.newDataInput((byte[])message);
        String subChannel = in.readUTF();
        if (subChannel.equals("GetServers")) {
            String[] serverList;
            String servers = in.readUTF();
            for (String s : serverList = servers.isEmpty() ? new String[]{} : servers.split(", ")) {
                BungeeMessage.sendPlayerListMsg(s);
            }
            BungeeMessage.sendServerMsg();
        }
        if (subChannel.equals("PlayerList")) {
            String server = in.readUTF();
            String players = in.readUTF();
            Set<String> playerSet = Set.of(players.isEmpty() ? new String[]{} : players.split(", "));
            for (String s : playerSet) {
                BungeeMessage.sendUUIDMsg(s);
            }
            playerList.put(server, new HashSet<String>(playerSet));
            TabManager.refreshTab();
        }
        if (subChannel.equals("UUIDOther")) {
            String name = in.readUTF();
            String uuidStr = in.readUTF();
            String formattedUUID = uuidStr.substring(0, 8) + "-" + uuidStr.substring(8, 12) + "-" + uuidStr.substring(12, 16) + "-" + uuidStr.substring(16, 20) + "-" + uuidStr.substring(20, 32);
            if (!uuidMap.containsKey(name)) {
                uuidMap.put(name, UUID.fromString(formattedUUID));
            }
        }
        if (subChannel.equals("GetServer")) {
            server = in.readUTF();
        }
    }

    public static void sendServerListMsg() {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF("GetServers");
        Collection players = Bukkit.getOnlinePlayers();
        if (players.isEmpty()) {
            FakePlayerManager.fakePlayers.clear();
            return;
        }
        ((Player)players.iterator().next()).sendPluginMessage((Plugin)LLobby.plugin, "BungeeCord", out.toByteArray());
    }

    public static void sendPlayerListMsg(String serverName) {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF("PlayerList");
        out.writeUTF(serverName);
        Collection players = Bukkit.getOnlinePlayers();
        if (players.isEmpty()) {
            return;
        }
        ((Player)players.iterator().next()).sendPluginMessage((Plugin)LLobby.plugin, "BungeeCord", out.toByteArray());
    }

    public static void sendServerMsg() {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF("GetServer");
        Collection players = Bukkit.getOnlinePlayers();
        if (players.isEmpty()) {
            return;
        }
        ((Player)players.iterator().next()).sendPluginMessage((Plugin)LLobby.plugin, "BungeeCord", out.toByteArray());
    }

    public static void sendUUIDMsg(String player) {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF("UUIDOther");
        out.writeUTF(player);
        Collection players = Bukkit.getOnlinePlayers();
        if (players.isEmpty()) {
            return;
        }
        ((Player)players.iterator().next()).sendPluginMessage((Plugin)LLobby.plugin, "BungeeCord", out.toByteArray());
    }
}

