/*
 * Decompiled with CFR 0.152.
 */
package top.syshub.lLobby.Command;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import top.syshub.lLobby.LLobby;
import top.syshub.lLobby.Manager.LocationManager;

public class LLobbyCommand
implements TabExecutor,
Listener {
    @ParametersAreNonnullByDefault
    public List<String> onTabComplete(CommandSender sender, Command cmd, String label, String[] args) {
        if (args.length == 1) {
            return LocationManager.worlds.keySet().stream().toList();
        }
        if (args.length == 2) {
            return ((Map)LocationManager.worlds.getOrDefault(args[0], new HashMap())).keySet().stream().toList();
        }
        return List.of();
    }

    @ParametersAreNonnullByDefault
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        List<String> locationName;
        if (!(sender instanceof Player)) {
            return false;
        }
        if (args.length == 0) {
            locationName = LLobbyCommand.getRandomLocation(null);
        } else if (args.length == 1) {
            locationName = LLobbyCommand.getRandomLocation(args[0]);
        } else if (args.length == 2) {
            locationName = List.of(args[0], args[1]);
        } else {
            return false;
        }
        return LLobbyCommand.playerTeleport((Player)sender, locationName);
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent e) {
        LLobbyCommand.playerTeleport(e.getPlayer(), LLobbyCommand.getRandomLocation(null));
    }

    @EventHandler
    public void onRespawn(PlayerRespawnEvent e) {
        List<String> locationName = LLobbyCommand.getRandomLocation(null);
        if (locationName == null) {
            return;
        }
        Location location = LLobbyCommand.getLocation(locationName.get(0), locationName.get(1));
        if (location == null) {
            return;
        }
        e.setRespawnLocation(location);
        LLobbyCommand.showTitle(e.getPlayer(), locationName.get(0), locationName.get(1));
    }

    private static boolean playerTeleport(Player player, List<String> locationName) {
        if (locationName == null) {
            return false;
        }
        Location location = LLobbyCommand.getLocation(locationName.get(0), locationName.get(1));
        if (location == null) {
            return false;
        }
        player.teleport(location);
        LLobbyCommand.showTitle(player, locationName.get(0), locationName.get(1));
        return true;
    }

    private static List<String> getRandomLocation(String world) {
        Map<String, String> worldLocations;
        if (LocationManager.worlds.isEmpty()) {
            return null;
        }
        ThreadLocalRandom random = ThreadLocalRandom.current();
        if (world == null) {
            ArrayList<String> worldList = new ArrayList<String>(LocationManager.worlds.keySet());
            world = (String)worldList.get(((Random)random).nextInt(worldList.size()));
        }
        if ((worldLocations = LocationManager.worlds.get(world)) == null || worldLocations.isEmpty()) {
            return null;
        }
        ArrayList<String> locations = new ArrayList<String>(worldLocations.keySet());
        String name = (String)locations.get(((Random)random).nextInt(locations.size()));
        return List.of(world, name);
    }

    private static Location getLocation(String world, String locationName) {
        if (!LocationManager.worlds.containsKey(world) || !LocationManager.worlds.get(world).containsKey(locationName)) {
            return null;
        }
        Map worldObj = LLobby.config.getMapList("worlds").stream().filter(p -> p.get("name").equals(world)).findFirst().orElse(Map.of());
        List position = ((List)worldObj.get("locations")).stream().map(p -> (Map)p).filter(p -> p.get("name").equals(locationName)).findFirst().map(p -> ((List)p.get("position")).stream().map(n -> ((Number)n).doubleValue()).collect(Collectors.toList())).orElse(Collections.emptyList());
        return new Location(LLobby.plugin.getServer().getWorld(world), ((Double)position.get(0)).doubleValue(), ((Double)position.get(1)).doubleValue(), ((Double)position.get(2)).doubleValue(), ((Double)position.get(3)).floatValue(), ((Double)position.get(4)).floatValue());
    }

    private static void showTitle(Player player, String world, String name) {
        player.resetTitle();
        player.sendTitle(LocationManager.worlds.get(world).get(name), LocationManager.nicknames.getOrDefault(world, world), 10, 30, 10);
    }
}

