/*
 * Decompiled with CFR 0.152.
 */
package top.syshub.lLobby.Manager;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.reflect.FieldAccessException;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.PlayerInfoData;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import com.comphenix.protocol.wrappers.WrappedSignedProperty;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import top.syshub.lLobby.Hook.BungeeMessage;
import top.syshub.lLobby.LLobby;
import top.syshub.lLobby.Manager.PlayerSkinManager;
import top.syshub.lLobby.Manager.TabManager;

public class FakePlayerManager {
    public static final Map<String, String> fakePlayers = new ConcurrentHashMap<String, String>();

    private static void addPlayer(String player) {
        try {
            String displayName = TabManager.prefixMap.get(player) + player;
            WrappedGameProfile gameProfile = new WrappedGameProfile(BungeeMessage.uuidMap.get(player), player);
            PlayerSkinManager.getPlayerSkin(player).thenAccept(skin -> {
                if (!skin.equals(PlayerSkinManager.NULL_SKIN)) {
                    gameProfile.getProperties().put((Object)"textures", (Object)new WrappedSignedProperty("textures", skin.texture(), skin.signature()));
                }
                PlayerInfoData playerInfoData = new PlayerInfoData(gameProfile, 0, EnumWrappers.NativeGameMode.SURVIVAL, WrappedChatComponent.fromText((String)displayName));
                PacketContainer packet = LLobby.protocolManager.createPacket(PacketType.Play.Server.PLAYER_INFO);
                packet.getPlayerInfoActions().write(0, EnumSet.of(EnumWrappers.PlayerInfoAction.ADD_PLAYER, EnumWrappers.PlayerInfoAction.UPDATE_DISPLAY_NAME, EnumWrappers.PlayerInfoAction.UPDATE_LISTED));
                packet.getPlayerInfoDataLists().write(1, Collections.singletonList(playerInfoData));
                LLobby.protocolManager.broadcastServerPacket(packet);
            });
        }
        catch (FieldAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static void updatePlayer(String player) {
        try {
            String displayName = TabManager.prefixMap.get(player) + player;
            WrappedGameProfile gameProfile = new WrappedGameProfile(BungeeMessage.uuidMap.get(player), "");
            PlayerInfoData playerInfoData = new PlayerInfoData(gameProfile, 0, EnumWrappers.NativeGameMode.SURVIVAL, WrappedChatComponent.fromText((String)displayName));
            PacketContainer packet = LLobby.protocolManager.createPacket(PacketType.Play.Server.PLAYER_INFO);
            packet.getPlayerInfoActions().write(0, Collections.singleton(EnumWrappers.PlayerInfoAction.UPDATE_DISPLAY_NAME));
            packet.getPlayerInfoDataLists().write(1, Collections.singletonList(playerInfoData));
            LLobby.protocolManager.broadcastServerPacket(packet);
        }
        catch (FieldAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static void removePlayer(String player) {
        UUID uuid = BungeeMessage.uuidMap.get(player);
        if (uuid == null) {
            return;
        }
        try {
            PacketContainer packet = LLobby.protocolManager.createPacket(PacketType.Play.Server.PLAYER_INFO_REMOVE);
            packet.getUUIDLists().write(0, Collections.singletonList(uuid));
            LLobby.protocolManager.broadcastServerPacket(packet);
        }
        catch (FieldAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static void sendFakePlayersTo(Player target) {
        for (String name : fakePlayers.keySet()) {
            UUID uuid = BungeeMessage.uuidMap.get(name);
            if (uuid == null) continue;
            String displayName = fakePlayers.get(name);
            try {
                WrappedGameProfile gameProfile = new WrappedGameProfile(uuid, name);
                PlayerSkinManager.getPlayerSkin(name).thenAccept(skin -> {
                    if (!skin.equals(PlayerSkinManager.NULL_SKIN)) {
                        gameProfile.getProperties().put((Object)"textures", (Object)new WrappedSignedProperty("textures", skin.texture(), skin.signature()));
                    }
                    PlayerInfoData infoData = new PlayerInfoData(gameProfile, 0, EnumWrappers.NativeGameMode.SURVIVAL, WrappedChatComponent.fromText((String)displayName));
                    PacketContainer packet = LLobby.protocolManager.createPacket(PacketType.Play.Server.PLAYER_INFO);
                    packet.getPlayerInfoActions().write(0, EnumSet.of(EnumWrappers.PlayerInfoAction.ADD_PLAYER, EnumWrappers.PlayerInfoAction.UPDATE_DISPLAY_NAME, EnumWrappers.PlayerInfoAction.UPDATE_LISTED));
                    packet.getPlayerInfoDataLists().write(1, Collections.singletonList(infoData));
                    LLobby.protocolManager.sendServerPacket(target, packet);
                });
            }
            catch (FieldAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void syncFakePlayer() {
        String player;
        HashMap newFakePlayer = new HashMap();
        HashMap<String, Set<String>> listCopy = new HashMap<String, Set<String>>(BungeeMessage.playerList);
        listCopy.keySet().retainAll(TabManager.servers.stream().map(map -> map.get("server").toString()).filter(Objects::nonNull).collect(Collectors.toSet()));
        listCopy.remove(BungeeMessage.server);
        listCopy.values().forEach(l -> l.forEach(player -> {
            String prefix = TabManager.prefixMap.get(player);
            if (prefix == null) {
                return;
            }
            newFakePlayer.put(player, prefix + player);
        }));
        for (Map.Entry entry : newFakePlayer.entrySet()) {
            player = (String)entry.getKey();
            String displayName = (String)entry.getValue();
            UUID uuid = BungeeMessage.uuidMap.get(player);
            if (uuid != null && !fakePlayers.containsKey(player)) {
                FakePlayerManager.addPlayer(player);
                fakePlayers.put(player, displayName);
                continue;
            }
            if (uuid == null || fakePlayers.get(player).equals(displayName)) continue;
            FakePlayerManager.updatePlayer(player);
            fakePlayers.put(player, displayName);
        }
        Iterator<Map.Entry<String, String>> it = fakePlayers.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> entry = it.next();
            player = entry.getKey();
            if (newFakePlayer.containsKey(player)) continue;
            if (!Bukkit.getOnlinePlayers().stream().map(Player::getName).toList().contains(player)) {
                FakePlayerManager.removePlayer(player);
            }
            it.remove();
        }
    }
}

