/*
 * Decompiled with CFR 0.152.
 */
package top.syshub.lLobby.Command;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import top.syshub.lLobby.LLobby;
import top.syshub.lLobby.Manager.LocationManager;

public class LLobbyCommand
implements TabExecutor,
Listener {
    @ParametersAreNonnullByDefault
    public List<String> onTabComplete(CommandSender sender, Command cmd, String label, String[] args) {
        if (args.length == 1) {
            return LocationManager.worlds.keySet().stream().toList();
        }
        if (args.length == 2) {
            return ((Map)LocationManager.worlds.getOrDefault(args[0], new HashMap())).keySet().stream().toList();
        }
        return List.of();
    }

    @ParametersAreNonnullByDefault
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            return false;
        }
        if (args.length == 0) {
            return LLobbyCommand.executeRandomTeleport((Player)sender, null);
        }
        if (args.length == 1) {
            return LLobbyCommand.executeRandomTeleport((Player)sender, args[0]);
        }
        if (args.length == 2) {
            return LLobbyCommand.executeTeleport((Player)sender, args[0], args[1]);
        }
        return false;
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent e) {
        Player player = e.getPlayer();
        LLobbyCommand.executeRandomTeleport(player, null);
    }

    private static boolean executeRandomTeleport(Player sender, String world) {
        List locations;
        if (LocationManager.worlds.isEmpty()) {
            return false;
        }
        ThreadLocalRandom random = ThreadLocalRandom.current();
        if (world == null) {
            ArrayList<String> worldList = new ArrayList<String>(LocationManager.worlds.keySet());
            world = (String)worldList.get(((Random)random).nextInt(worldList.size()));
        }
        if ((locations = ((Map)LocationManager.worlds.getOrDefault(world, new HashMap())).keySet().stream().toList()).isEmpty()) {
            return false;
        }
        String location = (String)locations.get(((Random)random).nextInt(locations.size()));
        return LLobbyCommand.executeTeleport(sender, world, location);
    }

    private static boolean executeTeleport(Player sender, String world, String locationName) {
        if (!LocationManager.worlds.containsKey(world) || !LocationManager.worlds.get(world).containsKey(locationName)) {
            return false;
        }
        Map worldObj = LLobby.config.getMapList("worlds").stream().filter(p -> p.get("name").equals(world)).findFirst().orElse(Map.of());
        List location = ((List)worldObj.get("locations")).stream().map(p -> (Map)p).filter(p -> p.get("name").equals(locationName)).findFirst().map(p -> ((List)p.get("position")).stream().map(n -> ((Number)n).doubleValue()).collect(Collectors.toList())).orElse(Collections.emptyList());
        sender.teleport(new Location(LLobby.plugin.getServer().getWorld(world), ((Double)location.get(0)).doubleValue(), ((Double)location.get(1)).doubleValue(), ((Double)location.get(2)).doubleValue(), ((Double)location.get(3)).floatValue(), ((Double)location.get(4)).floatValue()));
        sender.resetTitle();
        sender.sendTitle(LocationManager.worlds.get(world).get(locationName), LocationManager.nicknames.getOrDefault(world, world), 10, 60, 10);
        return true;
    }
}

