/*
 * Decompiled with CFR 0.152.
 */
package ru.logitechno;

import me.lucko.spark.api.Spark;
import me.lucko.spark.api.SparkProvider;
import me.lucko.spark.api.statistic.StatisticWindow;
import me.lucko.spark.api.statistic.misc.DoubleAverageInfo;
import me.lucko.spark.api.statistic.types.DoubleStatistic;
import me.lucko.spark.api.statistic.types.GenericStatistic;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class TabListVariables {
    public static String tablistChars(String string, ServerPlayer player) {
        Spark spark = SparkProvider.get();
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return string;
        }
        String output = string.replace("#TPS", String.valueOf(TabListVariables.getTPS(spark)));
        output = output.replace("#MSPT", String.valueOf(TabListVariables.getMSPT(spark)));
        output = output.replace("#PLAYERCOUNT", Integer.toString(TabListVariables.getPlayerCount(server)));
        output = output.replace("#PING", Integer.toString(TabListVariables.getPlayerPing(player)));
        output = output.replace("#N", "\n");
        return output.replace("&", "\u00a7");
    }

    private static double getTPS(Spark spark) {
        DoubleStatistic tps = spark.tps();
        if (tps == null) {
            return 0.0;
        }
        return (double)Math.round(tps.poll((Enum)StatisticWindow.TicksPerSecond.SECONDS_5) * 10.0) / 10.0;
    }

    private static double getMSPT(Spark spark) {
        GenericStatistic mspt = spark.mspt();
        if (mspt == null) {
            return 0.0;
        }
        return (double)Math.round(((DoubleAverageInfo)mspt.poll((Enum)StatisticWindow.MillisPerTick.SECONDS_10)).mean() * 10.0) / 10.0;
    }

    private static int getPlayerCount(MinecraftServer server) {
        return server.getPlayerList().getPlayerCount();
    }

    private static int getPlayerPing(ServerPlayer player) {
        return player.connection.latency();
    }
}

