/*
 * Decompiled with CFR 0.152.
 */
package ru.logitechno.tablist;

import me.lucko.spark.api.Spark;
import me.lucko.spark.api.SparkProvider;
import me.lucko.spark.api.statistic.StatisticWindow;
import me.lucko.spark.api.statistic.misc.DoubleAverageInfo;
import me.lucko.spark.api.statistic.types.DoubleStatistic;
import me.lucko.spark.api.statistic.types.GenericStatistic;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public class TabListVariables {
    public static String tablistChars(String string, ServerPlayer player) {
        Spark spark = SparkProvider.get();
        MinecraftServer server = player.m_20194_();
        if (server == null) {
            return string;
        }
        String output = string.replaceAll("#TPS", String.valueOf(TabListVariables.getTPS(spark)));
        output = output.replaceAll("#MSPT", String.valueOf(TabListVariables.getMSPT(spark)));
        output = output.replaceAll("#PLAYERCOUNT", Integer.toString(TabListVariables.getPlayerCount(server)));
        output = output.replaceAll("#PING", Integer.toString(TabListVariables.getPlayerPing(player)));
        output = output.replaceAll("#N", "\n");
        return output.replaceAll("&", "\u00a7");
    }

    private static double getTPS(Spark spark) {
        DoubleStatistic tps = spark.tps();
        assert (tps != null);
        return (double)Math.round(tps.poll((Enum)StatisticWindow.TicksPerSecond.SECONDS_10) * 10.0) / 10.0;
    }

    private static double getMSPT(Spark spark) {
        GenericStatistic mspt = spark.mspt();
        assert (mspt != null);
        return (double)Math.round(((DoubleAverageInfo)mspt.poll((Enum)StatisticWindow.MillisPerTick.SECONDS_10)).mean() * 10.0) / 10.0;
    }

    private static int getPlayerCount(MinecraftServer server) {
        return server.m_6846_().m_11309_();
    }

    private static int getPlayerPing(ServerPlayer player) {
        return player.f_8943_;
    }
}

