/*
 * Decompiled with CFR 0.152.
 */
package com.itsjustmiaouss.ijmtweaks.config;

import com.google.gson.GsonBuilder;
import com.itsjustmiaouss.ijmtweaks.config.OptionRequirement;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.NameableEnum;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionFlag;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.controller.BooleanControllerBuilder;
import dev.isxander.yacl3.api.controller.EnumControllerBuilder;
import dev.isxander.yacl3.api.controller.IntegerSliderControllerBuilder;
import dev.isxander.yacl3.config.v2.api.ConfigClassHandler;
import dev.isxander.yacl3.config.v2.api.SerialEntry;
import dev.isxander.yacl3.config.v2.api.serializer.GsonConfigSerializerBuilder;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class IJMTweaksConfig {
    public static final int IMG_WIDTH = 1920;
    public static final int IMG_HEIGHT = 1080;
    private static final ConfigClassHandler<IJMTweaksConfig> HANDLER = ConfigClassHandler.createBuilder(IJMTweaksConfig.class).id(class_2960.method_60655((String)"ijmtweaks", (String)"ijmtweaks")).serializer(config -> GsonConfigSerializerBuilder.create((ConfigClassHandler)config).setPath(FabricLoader.getInstance().getConfigDir().resolve("ijmtweaks.json")).appendGsonBuilder(GsonBuilder::setPrettyPrinting).setJson5(false).build()).build();
    @SerialEntry
    public boolean darkLoadingOverlay = true;
    @SerialEntry
    public int pumpkinOverlayOpacity = 40;
    @SerialEntry
    public int blockBreakParticle = 0;
    @SerialEntry
    public boolean experienceBarInCreative = false;
    @SerialEntry
    public boolean autoJumpOnStairs = true;
    @SerialEntry
    public int zoomLevel = 70;
    @SerialEntry
    public boolean singleItemInventorySwap = false;
    @SerialEntry
    public boolean screenshotsFolder = true;
    @SerialEntry
    public boolean debugInvisibleEntities = false;
    @SerialEntry
    public boolean fullbright = false;
    @SerialEntry
    public FireOverlayType fireOverlay = FireOverlayType.REDUCED;

    public static void load() {
        HANDLER.load();
    }

    public static void save() {
        HANDLER.save();
    }

    public static IJMTweaksConfig get() {
        return (IJMTweaksConfig)HANDLER.instance();
    }

    public static YetAnotherConfigLib getScreen() {
        return YetAnotherConfigLib.create(HANDLER, (defaults, config, builder) -> {
            Option darkLoadingScreenOpt = IJMTweaksConfig.getGenericOption("darkLoadingOverlay", "dark_overlay").binding((Object)defaults.darkLoadingOverlay, () -> config.darkLoadingOverlay, newVal -> {
                config.darkLoadingOverlay = newVal;
            }).flag(new OptionFlag[]{OptionFlag.ASSET_RELOAD}).controller(opt -> BooleanControllerBuilder.create((Option)opt).trueFalseFormatter()).build();
            Option pumpkinOverlayOpacityOpt = IJMTweaksConfig.getGenericOption("pumpkinOverlayOpacity", "pumpkin_overlay").binding((Object)defaults.pumpkinOverlayOpacity, () -> config.pumpkinOverlayOpacity, newVal -> {
                config.pumpkinOverlayOpacity = newVal;
            }).controller(opt -> ((IntegerSliderControllerBuilder)((IntegerSliderControllerBuilder)IntegerSliderControllerBuilder.create((Option)opt).range((Number)0, (Number)100)).step((Number)10)).formatValue(value -> class_2561.method_43470((String)(value + "%")))).build();
            Option blockBreakParticleScaleOpt = IJMTweaksConfig.getGenericOption("blockBreakParticle", "break_particles").binding((Object)defaults.blockBreakParticle, () -> config.blockBreakParticle, newVal -> {
                config.blockBreakParticle = newVal;
            }).controller(opt -> ((IntegerSliderControllerBuilder)IntegerSliderControllerBuilder.create((Option)opt).range((Number)0, (Number)4)).step((Number)1)).build();
            Option experienceBarInCreativeOpt = IJMTweaksConfig.getGenericOption("experienceBarInCreative", "experience_bar").binding((Object)defaults.experienceBarInCreative, () -> config.experienceBarInCreative, newVal -> {
                config.experienceBarInCreative = newVal;
            }).controller(opt -> BooleanControllerBuilder.create((Option)opt).trueFalseFormatter()).build();
            Option autoJumpOnStairsOpt = IJMTweaksConfig.getGenericOption("autoJumpOnStairs", "auto_jump").binding((Object)defaults.autoJumpOnStairs, () -> config.autoJumpOnStairs, newVal -> {
                config.autoJumpOnStairs = newVal;
            }).controller(opt -> BooleanControllerBuilder.create((Option)opt).trueFalseFormatter()).build();
            Option zoomLevelOpt = IJMTweaksConfig.getGenericOption("zoomLevel", "zoom_level").binding((Object)defaults.zoomLevel, () -> config.zoomLevel, newVal -> {
                config.zoomLevel = newVal;
            }).controller(opt -> ((IntegerSliderControllerBuilder)((IntegerSliderControllerBuilder)IntegerSliderControllerBuilder.create((Option)opt).range((Number)0, (Number)100)).step((Number)10)).formatValue(value -> class_2561.method_43470((String)(value + "%")))).build();
            Option fireOverlayOpt = IJMTweaksConfig.getGenericOption("fireOverlay", "fire_overlay").binding((Object)defaults.fireOverlay, () -> config.fireOverlay, newVal -> {
                config.fireOverlay = newVal;
            }).controller(opt -> EnumControllerBuilder.create((Option)opt).enumClass(FireOverlayType.class)).build();
            Option singleItemInventorySwapOpt = IJMTweaksConfig.getGenericOption("singleItemInventorySwap", "inventory_swap").binding((Object)defaults.singleItemInventorySwap, () -> config.singleItemInventorySwap, newVal -> {
                config.singleItemInventorySwap = newVal;
            }).controller(opt -> BooleanControllerBuilder.create((Option)opt).trueFalseFormatter()).build();
            Option screenshotsFolderOpt = IJMTweaksConfig.getGenericOption("screenshotsFolder", "screenshots_folder").binding((Object)defaults.screenshotsFolder, () -> config.screenshotsFolder, newVal -> {
                config.screenshotsFolder = newVal;
            }).controller(opt -> BooleanControllerBuilder.create((Option)opt).trueFalseFormatter()).build();
            Option debugInvisibleEntitiesOpt = IJMTweaksConfig.getGenericOption("debugInvisibleEntities", "debug_invisible_entities", OptionRequirement.NON_SURVIVAL_OP).binding((Object)defaults.debugInvisibleEntities, () -> config.debugInvisibleEntities, newVal -> {
                config.debugInvisibleEntities = newVal;
            }).controller(opt -> BooleanControllerBuilder.create((Option)opt).trueFalseFormatter()).build();
            Option fullbrightOpt = IJMTweaksConfig.getGenericOption("fullbright", "fullbright").binding((Object)defaults.fullbright, () -> config.fullbright, newVal -> {
                config.fullbright = newVal;
            }).controller(opt -> BooleanControllerBuilder.create((Option)opt).trueFalseFormatter()).build();
            return builder.title(class_2561.method_30163((String)"IJM's Tweaks")).category(ConfigCategory.createBuilder().name(IJMTweaksConfig.getCategoryName("screen")).group(OptionGroup.createBuilder().name(IJMTweaksConfig.getGroupName("overlay")).options(List.of(darkLoadingScreenOpt, pumpkinOverlayOpacityOpt, fireOverlayOpt)).build()).build()).category(ConfigCategory.createBuilder().name(IJMTweaksConfig.getCategoryName("utility")).group(OptionGroup.createBuilder().name(IJMTweaksConfig.getGroupName("general")).options(List.of(zoomLevelOpt, screenshotsFolderOpt)).build()).group(OptionGroup.createBuilder().name(IJMTweaksConfig.getGroupName("movement")).options(List.of(autoJumpOnStairsOpt)).build()).group(OptionGroup.createBuilder().name(IJMTweaksConfig.getGroupName("creative")).options(List.of(experienceBarInCreativeOpt, singleItemInventorySwapOpt)).build()).build()).category(ConfigCategory.createBuilder().name(IJMTweaksConfig.getCategoryName("visual")).group(OptionGroup.createBuilder().name(IJMTweaksConfig.getGroupName("rendering")).options(List.of(blockBreakParticleScaleOpt, fullbrightOpt)).build()).group(OptionGroup.createBuilder().name(IJMTweaksConfig.getGroupName("debug")).options(List.of(debugInvisibleEntitiesOpt)).build()).build()).save(IJMTweaksConfig::save);
        });
    }

    private static <T> Option.Builder<T> getGenericOption(String name, String image) {
        return IJMTweaksConfig.getGenericOption(name, image, null);
    }

    private static <T> Option.Builder<T> getGenericOption(String name, String image, @Nullable OptionRequirement requirement) {
        return Option.createBuilder().name(IJMTweaksConfig.getOptionName(name)).description(OptionDescription.createBuilder().text(new class_2561[]{IJMTweaksConfig.getDesc(name, requirement)}).image(IJMTweaksConfig.getImage(image), 1920, 1080).build());
    }

    private static class_2561 getCategoryName(String category) {
        return class_2561.method_43471((String)String.format("category.%s.%s", "ijmtweaks", category));
    }

    private static class_2561 getGroupName(String group) {
        return class_2561.method_43471((String)String.format("group.%s.%s.name", "ijmtweaks", group));
    }

    private static class_2561 getOptionName(String option) {
        return class_2561.method_43471((String)String.format("option.%s.%s.name", "ijmtweaks", option));
    }

    private static class_2561 getDesc(String option, @Nullable OptionRequirement requirement) {
        class_5250 text = class_2561.method_43471((String)String.format("option.%s.%s.desc", "ijmtweaks", option));
        if (requirement != null) {
            text.method_10852((class_2561)class_2561.method_43470((String)"\n").method_10852(requirement.getText()));
        }
        return text;
    }

    private static class_2960 getImage(String name) {
        return class_2960.method_60655((String)"ijmtweaks", (String)String.format("config/%s.png", name));
    }

    public static enum FireOverlayType implements NameableEnum
    {
        DEFAULT,
        REDUCED,
        HIDDEN;


        public class_2561 getDisplayName() {
            return class_2561.method_43471((String)String.format("enum.%s.fireOverlayType.%s", "ijmtweaks", this.name().toLowerCase()));
        }
    }
}

