/*
 * Decompiled with CFR 0.152.
 */
package com.github.k1ritoz.vote2Sleep.api;

import com.github.k1ritoz.vote2Sleep.Vote2Sleep;
import com.github.k1ritoz.vote2Sleep.data.SleepVote;
import com.github.k1ritoz.vote2Sleep.data.WorldData;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.GameMode;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class Vote2SleepAPI {
    private final Vote2Sleep plugin;

    public Vote2SleepAPI(Vote2Sleep plugin) {
        this.plugin = plugin;
    }

    public boolean hasPlayerVoted(Player player) {
        return this.plugin.getVoteManager().hasPlayerVoted(player);
    }

    public int getCurrentVotes(World world) {
        return this.plugin.getVoteManager().getCurrentVotes(world);
    }

    public int getRequiredVotes(World world) {
        return this.plugin.getVoteManager().getRequiredVotes(world);
    }

    public boolean isWorldEnabled(World world) {
        return this.plugin.getConfigManager().isWorldEnabled(world);
    }

    public void startSleepVote(Player player) {
        this.plugin.getVoteManager().startSleepVote(player);
    }

    public void removeSleepVote(Player player) {
        this.plugin.getVoteManager().removeSleepVote(player);
    }

    public Map<String, SleepVote> getWorldVotes(World world) {
        WorldData data = this.plugin.getVoteManager().getWorldData(world);
        if (data == null) {
            return Map.of();
        }
        return data.getVotes().entrySet().stream().collect(Collectors.toMap(entry -> ((SleepVote)entry.getValue()).getPlayerName(), Map.Entry::getValue));
    }

    public void forceSkip(World world, Player initiator) {
        this.plugin.getVoteManager().forceSkip(world, initiator);
    }

    public void clearVotes(World world) {
        this.plugin.getVoteManager().clearVotes(world);
    }

    public boolean canSleep(World world) {
        boolean isNight = world.getTime() >= 12542L && world.getTime() <= 23459L;
        boolean isStormy = world.hasStorm() || world.isThundering();
        return isNight && this.plugin.getConfigManager().isNightSkipAllowed() || isStormy && this.plugin.getConfigManager().isStormSkipAllowed();
    }

    public double getVoteProgress(World world) {
        int current = this.getCurrentVotes(world);
        int required = this.getRequiredVotes(world);
        return required > 0 ? (double)current / (double)required : 0.0;
    }

    public int getEligiblePlayerCount(World world) {
        return (int)world.getPlayers().stream().filter(p -> p.getGameMode() != GameMode.SPECTATOR).filter(p -> p.getGameMode() != GameMode.CREATIVE).filter(p -> !p.hasPermission("vote2sleep.exempt")).count();
    }

    public boolean isPlayerExempt(Player player) {
        String gameMode = player.getGameMode().name();
        if (this.plugin.getConfigManager().getExemptGameModes().contains(gameMode)) {
            return true;
        }
        for (String permission : this.plugin.getConfigManager().getExemptPermissions()) {
            if (!player.hasPermission(permission)) continue;
            return true;
        }
        return false;
    }

    public WorldData getWorldData(World world) {
        return this.plugin.getVoteManager().getWorldData(world);
    }
}

