/*
 * Decompiled with CFR 0.152.
 */
package com.github.k1ritoz.vote2Sleep.managers;

import com.github.k1ritoz.vote2Sleep.Vote2Sleep;
import com.github.k1ritoz.vote2Sleep.data.SleepVote;
import java.util.List;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class EffectsManager {
    private final Vote2Sleep plugin;

    public EffectsManager(Vote2Sleep plugin) {
        this.plugin = plugin;
    }

    public void playVoteEffects(World world, Player voter) {
        if (this.plugin.getConfigManager().areSoundsEnabled()) {
            this.playSound(world, this.plugin.getConfigManager().getVoteSound());
        }
        if (this.plugin.getConfigManager().areParticleEffectsEnabled() && voter.isOnline()) {
            Location loc = voter.getLocation();
            world.spawnParticle(Particle.HAPPY_VILLAGER, loc.add(0.0, 1.0, 0.0), 10, 0.5, 0.5, 0.5, 0.1);
        }
        if (this.plugin.getConfigManager().isActionBarEnabled()) {
            for (Player player : world.getPlayers()) {
                this.plugin.getMessageManager().sendActionBar(player, "vote-cast-actionbar", Map.of("player", voter.getName()));
            }
        }
    }

    public void playSkipEffects(World world, List<SleepVote> votes, boolean wasNight) {
        if (this.plugin.getConfigManager().areSoundsEnabled()) {
            this.playSound(world, this.plugin.getConfigManager().getSkipSound());
        }
        if (this.plugin.getConfigManager().areTitlesEnabled()) {
            int fadeIn = this.plugin.getConfigManager().getTitleFadeIn();
            int stay = this.plugin.getConfigManager().getTitleStay();
            int fadeOut = this.plugin.getConfigManager().getTitleFadeOut();
            String title = wasNight ? this.plugin.getMessageManager().getMessage("skip-title") : this.plugin.getMessageManager().getMessage("storm-skip-title");
            String subtitle = wasNight ? this.plugin.getMessageManager().getMessage("skip-subtitle") : this.plugin.getMessageManager().getMessage("storm-skip-subtitle");
            for (Player player : world.getPlayers()) {
                player.sendTitle(title, subtitle, fadeIn, stay, fadeOut);
            }
        }
        if (this.plugin.getConfigManager().areParticleEffectsEnabled()) {
            for (SleepVote vote : votes) {
                Location loc = vote.getLocation();
                if (!loc.getWorld().equals((Object)world)) continue;
                world.spawnParticle(Particle.END_ROD, loc.add(0.0, 2.0, 0.0), 20, 1.0, 1.0, 1.0, 0.1);
            }
        }
        if (this.plugin.getConfigManager().isLightningOnSkipEnabled()) {
            double lightningChance = this.plugin.getConfigManager().getLightningChance();
            for (Player player : world.getPlayers()) {
                if (!(Math.random() < lightningChance)) continue;
                Location loc = player.getLocation();
                world.strikeLightningEffect(loc);
                if (!this.plugin.getConfigManager().isDebugMode()) continue;
                this.plugin.getLogger().info("Lightning effect triggered for player " + player.getName() + " at " + String.valueOf(loc));
            }
        } else if (this.plugin.getConfigManager().isDebugMode()) {
            this.plugin.getLogger().info("Lightning effects are disabled to prevent 'Surge Protector' achievement");
        }
    }

    private void playSound(World world, String soundName) {
        try {
            Sound sound = Sound.valueOf((String)soundName);
            for (Player player : world.getPlayers()) {
                player.playSound(player.getLocation(), sound, 1.0f, 1.0f);
            }
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLogger().warning("Invalid sound name: " + soundName);
            for (Player player : world.getPlayers()) {
                player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
            }
        }
    }

    public void cleanup() {
    }
}

