/*
 * Decompiled with CFR 0.152.
 */
package com.github.k1ritoz.vote2Sleep.managers;

import com.github.k1ritoz.vote2Sleep.Vote2Sleep;
import com.github.k1ritoz.vote2Sleep.managers.Vote2SleepPlaceholders;
import org.bukkit.Bukkit;

public class HooksManager {
    private final Vote2Sleep plugin;
    private boolean placeholderAPIHooked = false;
    private boolean worldGuardHooked = false;
    private boolean essentialsHooked = false;
    private Vote2SleepPlaceholders placeholderExpansion = null;

    public HooksManager(Vote2Sleep plugin) {
        this.plugin = plugin;
    }

    public void initializeHooks() {
        block18: {
            if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
                try {
                    if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
                        Class.forName("me.clip.placeholderapi.expansion.PlaceholderExpansion");
                        Class.forName("me.clip.placeholderapi.PlaceholderAPI");
                        this.placeholderExpansion = new Vote2SleepPlaceholders(this.plugin);
                        if (this.placeholderExpansion.register()) {
                            this.placeholderAPIHooked = true;
                            this.plugin.getLogger().info("Successfully hooked into PlaceholderAPI");
                        } else {
                            this.plugin.getLogger().warning("Failed to register PlaceholderAPI expansion");
                        }
                        break block18;
                    }
                    this.plugin.getLogger().info("PlaceholderAPI found but not enabled");
                }
                catch (ClassNotFoundException e) {
                    this.plugin.getLogger().warning("PlaceholderAPI classes not found: " + e.getMessage());
                }
                catch (Exception e) {
                    this.plugin.getLogger().warning("Failed to hook into PlaceholderAPI: " + e.getMessage());
                    e.printStackTrace();
                }
            } else {
                this.plugin.getLogger().info("PlaceholderAPI not found");
            }
        }
        if (Bukkit.getPluginManager().getPlugin("WorldGuard") != null) {
            try {
                if (Bukkit.getPluginManager().isPluginEnabled("WorldGuard")) {
                    this.worldGuardHooked = true;
                    this.plugin.getLogger().info("WorldGuard detected - region checking enabled");
                } else {
                    this.plugin.getLogger().info("WorldGuard found but not enabled");
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Error checking WorldGuard: " + e.getMessage());
            }
        }
        if (Bukkit.getPluginManager().getPlugin("Essentials") != null) {
            try {
                if (Bukkit.getPluginManager().isPluginEnabled("Essentials")) {
                    this.essentialsHooked = true;
                    this.plugin.getLogger().info("Essentials detected - AFK checking enabled");
                } else {
                    this.plugin.getLogger().info("Essentials found but not enabled");
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Error checking Essentials: " + e.getMessage());
            }
        }
        this.plugin.getLogger().info("Hooks initialized - PlaceholderAPI: " + this.placeholderAPIHooked + ", WorldGuard: " + this.worldGuardHooked + ", Essentials: " + this.essentialsHooked);
    }

    public void reinitializeHooks() {
        if (this.placeholderExpansion != null) {
            try {
                this.placeholderExpansion.unregister();
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Error unregistering PlaceholderAPI expansion: " + e.getMessage());
            }
        }
        this.placeholderAPIHooked = false;
        this.worldGuardHooked = false;
        this.essentialsHooked = false;
        this.placeholderExpansion = null;
        this.initializeHooks();
    }

    public boolean isPluginAvailable(String pluginName) {
        try {
            return Bukkit.getPluginManager().getPlugin(pluginName) != null && Bukkit.getPluginManager().isPluginEnabled(pluginName);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isPlaceholderAPIHooked() {
        return this.placeholderAPIHooked;
    }

    public boolean isWorldGuardHooked() {
        return this.worldGuardHooked;
    }

    public boolean isEssentialsHooked() {
        return this.essentialsHooked;
    }

    public Vote2SleepPlaceholders getPlaceholderExpansion() {
        return this.placeholderExpansion;
    }

    public void cleanup() {
        if (this.placeholderExpansion != null) {
            try {
                this.placeholderExpansion.unregister();
                this.plugin.getLogger().info("PlaceholderAPI expansion unregistered");
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Error unregistering PlaceholderAPI expansion: " + e.getMessage());
            }
        }
    }
}

