/*
 * Decompiled with CFR 0.152.
 */
package com.github.k1ritoz.vote2Sleep.managers;

import com.github.k1ritoz.vote2Sleep.Vote2Sleep;
import com.github.k1ritoz.vote2Sleep.config.AutoConfigUpdater;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Map;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class MessageManager {
    private final Vote2Sleep plugin;
    private FileConfiguration messages;
    private File messagesFile;
    private String prefix;
    private String currentLanguage;
    private AutoConfigUpdater autoUpdater;

    public MessageManager(Vote2Sleep plugin) {
        this.plugin = plugin;
        this.autoUpdater = new AutoConfigUpdater(plugin);
    }

    public void loadMessages() {
        this.currentLanguage = this.plugin.getConfigManager().getLanguage();
        this.ensureMessagesFile();
        this.messages = YamlConfiguration.loadConfiguration((File)this.messagesFile);
        this.setDefaults();
        this.autoUpdater.updateMessagesIfNeeded(this.currentLanguage);
        this.messages = YamlConfiguration.loadConfiguration((File)this.messagesFile);
        this.prefix = this.getMessage("prefix");
        this.plugin.getLogger().info("Loaded messages for language: " + this.currentLanguage);
    }

    private void ensureMessagesFile() {
        Object fileName = "messages_" + this.currentLanguage + ".yml";
        this.messagesFile = new File(this.plugin.getDataFolder(), (String)fileName);
        if (!this.messagesFile.exists()) {
            try {
                InputStream resourceStream = this.plugin.getResource((String)fileName);
                if (resourceStream != null) {
                    Files.copy(resourceStream, this.messagesFile.toPath(), new CopyOption[0]);
                    this.plugin.getLogger().info("Created " + (String)fileName + " from template");
                } else {
                    this.plugin.getLogger().warning("Language file " + (String)fileName + " not found, falling back to English");
                    this.currentLanguage = "en";
                    fileName = "messages_en.yml";
                    this.messagesFile = new File(this.plugin.getDataFolder(), (String)fileName);
                    if (!this.messagesFile.exists()) {
                        resourceStream = this.plugin.getResource((String)fileName);
                        if (resourceStream != null) {
                            Files.copy(resourceStream, this.messagesFile.toPath(), new CopyOption[0]);
                        } else {
                            this.createDefaultMessagesFile();
                        }
                    }
                }
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Could not create messages file: " + e.getMessage());
                this.createDefaultMessagesFile();
            }
        }
    }

    private void createDefaultMessagesFile() {
        try {
            this.messagesFile.createNewFile();
            this.messages = YamlConfiguration.loadConfiguration((File)this.messagesFile);
            this.setDefaultMessages();
            this.messages.save(this.messagesFile);
            this.plugin.getLogger().info("Created default messages file");
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not create default messages file: " + e.getMessage());
        }
    }

    private void setDefaults() {
        if (this.messages.getKeys(false).isEmpty()) {
            this.setDefaultMessages();
            this.saveMessages();
        }
    }

    private void setDefaultMessages() {
        if (!this.messages.contains("prefix")) {
            this.messages.set("prefix", (Object)"&8[&bVote2Sleep&8] &r");
        }
        if (!this.messages.contains("world-not-enabled")) {
            this.messages.set("world-not-enabled", (Object)"&cVote2Sleep is not enabled in this world!");
        }
        if (!this.messages.contains("player-exempt")) {
            this.messages.set("player-exempt", (Object)"&cYou are exempt from sleep voting!");
        }
        if (!this.messages.contains("cannot-sleep-now")) {
            this.messages.set("cannot-sleep-now", (Object)"&cYou can only vote for sleep during night or storms!");
        }
        if (!this.messages.contains("already-voted")) {
            this.messages.set("already-voted", (Object)"&cYou have already voted for sleep!");
        }
        if (!this.messages.contains("vote-removed")) {
            this.messages.set("vote-removed", (Object)"&aYour sleep vote has been removed!");
        }
        if (!this.messages.contains("vote-cast")) {
            this.messages.set("vote-cast", (Object)"&a{current}&7/&a{required} &7players voted for sleep! &8(&c{remaining} &7remaining)");
        }
        if (!this.messages.contains("skip-countdown")) {
            this.messages.set("skip-countdown", (Object)"&eNight will be skipped in &a{seconds} &eseconds...");
        }
        if (!this.messages.contains("vote-timeout")) {
            this.messages.set("vote-timeout", (Object)"&cSleep vote has timed out!");
        }
        if (!this.messages.contains("night-skipped")) {
            this.messages.set("night-skipped", (Object)"&aThe night has been skipped! Sweet dreams! &f\u2728");
        }
        if (!this.messages.contains("storm-skipped")) {
            this.messages.set("storm-skipped", (Object)"&aThe storm has been cleared! The sun is shining again! &e\u2600");
        }
        if (!this.messages.contains("boss-bar-title")) {
            this.messages.set("boss-bar-title", (Object)"Sleep Vote: {current}/{required}");
        }
        if (!this.messages.contains("world-enabled")) {
            this.messages.set("world-enabled", (Object)"&aVote2Sleep enabled for world &e{world}&a!");
        }
        if (!this.messages.contains("world-disabled")) {
            this.messages.set("world-disabled", (Object)"&cVote2Sleep disabled for world &e{world}&c!");
        }
        if (!this.messages.contains("already-enabled")) {
            this.messages.set("already-enabled", (Object)"&cVote2Sleep is already enabled in this world!");
        }
        if (!this.messages.contains("already-disabled")) {
            this.messages.set("already-disabled", (Object)"&cVote2Sleep is already disabled in this world!");
        }
        if (!this.messages.contains("no-permission")) {
            this.messages.set("no-permission", (Object)"&cYou don't have permission to use this command!");
        }
        if (!this.messages.contains("reload-success")) {
            this.messages.set("reload-success", (Object)"&aVote2Sleep configuration reloaded successfully!");
        }
        if (!this.messages.contains("statistics-cleared")) {
            this.messages.set("statistics-cleared", (Object)"&aStatistics have been cleared!");
        }
        if (!this.messages.contains("votes-cancelled-by-admin")) {
            this.messages.set("votes-cancelled-by-admin", (Object)"&cSleep votes have been cancelled by {admin}!");
        }
        if (!this.messages.contains("force-skip-by-admin")) {
            this.messages.set("force-skip-by-admin", (Object)"&eNight has been force-skipped by {admin}!");
        }
        if (!this.messages.contains("weather-cleared-votes-cancelled")) {
            this.messages.set("weather-cleared-votes-cancelled", (Object)"&cSleep votes cancelled because the weather cleared!");
        }
        if (!this.messages.contains("world-enabled-notice")) {
            this.messages.set("world-enabled-notice", (Object)"&aVote2Sleep is enabled in this world! Use /sleep to vote.");
        }
        if (!this.messages.contains("world-disabled-notice")) {
            this.messages.set("world-disabled-notice", (Object)"&cVote2Sleep is disabled in this world.");
        }
        if (!this.messages.contains("lightning-disabled")) {
            this.messages.set("lightning-disabled", (Object)"&eLightning effects have been disabled for achievement reasons.");
        }
        if (!this.messages.contains("effects-disabled")) {
            this.messages.set("effects-disabled", (Object)"&eVisual effects have been disabled in configuration.");
        }
        if (!this.messages.contains("status.header")) {
            this.messages.set("status.header", (Object)"&b&l=== Vote2Sleep Status ===");
        }
        if (!this.messages.contains("status.world")) {
            this.messages.set("status.world", (Object)"&7World: &e{world}");
        }
        if (!this.messages.contains("status.current-votes")) {
            this.messages.set("status.current-votes", (Object)"&7Current Votes: &a{current}&7/&a{required}");
        }
        if (!this.messages.contains("status.you-voted")) {
            this.messages.set("status.you-voted", (Object)"&7You Voted: {status}");
        }
        if (!this.messages.contains("status.can-sleep")) {
            this.messages.set("status.can-sleep", (Object)"&7Can Sleep: {status}");
        }
        if (!this.messages.contains("status.progress")) {
            this.messages.set("status.progress", (Object)"&7Progress: &a{progress}%");
        }
        if (!this.messages.contains("status.time-remaining")) {
            this.messages.set("status.time-remaining", (Object)"&7Time Remaining: &e{time} seconds");
        }
        if (!this.messages.contains("status-yes")) {
            this.messages.set("status-yes", (Object)"&aYes");
        }
        if (!this.messages.contains("status-no")) {
            this.messages.set("status-no", (Object)"&cNo");
        }
        if (!this.messages.contains("stats.header")) {
            this.messages.set("stats.header", (Object)"&b&l=== Vote2Sleep Statistics ===");
        }
        if (!this.messages.contains("stats.plugin-version")) {
            this.messages.set("stats.plugin-version", (Object)"&7Plugin Version: &e{version}");
        }
        if (!this.messages.contains("stats.platform")) {
            this.messages.set("stats.platform", (Object)"&7Platform: &e{platform}");
        }
        if (!this.messages.contains("stats.enabled-worlds")) {
            this.messages.set("stats.enabled-worlds", (Object)"&7Enabled Worlds: &a{count}");
        }
        if (!this.messages.contains("stats.server-tps")) {
            this.messages.set("stats.server-tps", (Object)"&7Server TPS: &a{tps}");
        }
        if (!this.messages.contains("stats.database-status")) {
            this.messages.set("stats.database-status", (Object)"&7Database: {status}");
        }
        if (!this.messages.contains("stats.total-skips")) {
            this.messages.set("stats.total-skips", (Object)"&7Total Night Skips: &e{skips}");
        }
        if (!this.messages.contains("help.header")) {
            this.messages.set("help.header", (Object)"&b&l=== Vote2Sleep Help ===");
        }
        if (!this.messages.contains("help.vote")) {
            this.messages.set("help.vote", (Object)"&e/sleep &7- Vote to skip night or storm");
        }
        if (!this.messages.contains("help.status")) {
            this.messages.set("help.status", (Object)"&e/sleep status &7- Check current vote status");
        }
        if (!this.messages.contains("help.enable")) {
            this.messages.set("help.enable", (Object)"&e/sleep enable &7- Enable plugin in current world");
        }
        if (!this.messages.contains("help.disable")) {
            this.messages.set("help.disable", (Object)"&e/sleep disable &7- Disable plugin in current world");
        }
        if (!this.messages.contains("help.reload")) {
            this.messages.set("help.reload", (Object)"&e/sleep reload &7- Reload configuration");
        }
        if (!this.messages.contains("help.stats")) {
            this.messages.set("help.stats", (Object)"&e/sleep stats &7- View plugin statistics");
        }
        if (!this.messages.contains("help.cancel")) {
            this.messages.set("help.cancel", (Object)"&e/sleep cancel &7- Cancel current votes");
        }
        if (!this.messages.contains("help.force")) {
            this.messages.set("help.force", (Object)"&e/sleep force &7- Force skip night/storm");
        }
        if (!this.messages.contains("help.help")) {
            this.messages.set("help.help", (Object)"&e/sleep help &7- Show this help message");
        }
        if (!this.messages.contains("vote-cast-actionbar")) {
            this.messages.set("vote-cast-actionbar", (Object)"&a{player} &7voted for sleep! &8(&a{current}&7/&a{required}&8)");
        }
        if (!this.messages.contains("skip-title")) {
            this.messages.set("skip-title", (Object)"&a&lNight Skipped!");
        }
        if (!this.messages.contains("skip-subtitle")) {
            this.messages.set("skip-subtitle", (Object)"&eSleep tight! &f\u2728");
        }
    }

    public String getMessage(String key) {
        String message = this.messages.getString(key, key);
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    public String getMessage(String key, Map<String, String> placeholders) {
        String message = this.getMessage(key);
        if (placeholders != null) {
            for (Map.Entry<String, String> entry : placeholders.entrySet()) {
                message = message.replace("{" + entry.getKey() + "}", entry.getValue());
            }
        }
        return message;
    }

    public String processPlaceholders(Player player, String message) {
        block3: {
            if (this.plugin.getHooksManager().isPlaceholderAPIHooked()) {
                try {
                    Class<?> placeholderAPIClass = Class.forName("me.clip.placeholderapi.PlaceholderAPI");
                    Method setPlaceholdersMethod = placeholderAPIClass.getMethod("setPlaceholders", Player.class, String.class);
                    message = (String)setPlaceholdersMethod.invoke(null, player, message);
                }
                catch (Exception e) {
                    if (!this.plugin.getConfigManager().isDebugMode()) break block3;
                    this.plugin.getLogger().warning("Error processing PlaceholderAPI placeholders: " + e.getMessage());
                }
            }
        }
        return message;
    }

    public void sendMessage(Player player, String key) {
        String message = this.getMessage(key);
        if (!message.isEmpty() && !message.equals(key)) {
            message = this.processPlaceholders(player, message);
            player.sendMessage(this.prefix + message);
        }
    }

    public void sendMessage(Player player, String key, Map<String, String> placeholders) {
        String message = this.getMessage(key, placeholders);
        if (!message.isEmpty() && !message.equals(key)) {
            message = this.processPlaceholders(player, message);
            player.sendMessage(this.prefix + message);
        }
    }

    public void sendWorldMessage(World world, String key) {
        String message = this.getMessage(key);
        if (!message.isEmpty() && !message.equals(key)) {
            for (Player player : world.getPlayers()) {
                String processedMessage = this.processPlaceholders(player, message);
                player.sendMessage(this.prefix + processedMessage);
            }
        }
    }

    public void sendWorldMessage(World world, String key, Map<String, String> placeholders) {
        String message = this.getMessage(key, placeholders);
        if (!message.isEmpty() && !message.equals(key)) {
            for (Player player : world.getPlayers()) {
                String processedMessage = this.processPlaceholders(player, message);
                player.sendMessage(this.prefix + processedMessage);
            }
        }
    }

    public String getBossBarTitle(int current, int required) {
        String title;
        block3: {
            title = this.getMessage("boss-bar-title", Map.of("current", String.valueOf(current), "required", String.valueOf(required)));
            if (this.plugin.getHooksManager().isPlaceholderAPIHooked()) {
                try {
                    Class<?> placeholderAPIClass = Class.forName("me.clip.placeholderapi.PlaceholderAPI");
                    Method setPlaceholdersMethod = placeholderAPIClass.getMethod("setPlaceholders", Player.class, String.class);
                    title = (String)setPlaceholdersMethod.invoke(null, null, title);
                }
                catch (Exception e) {
                    if (!this.plugin.getConfigManager().isDebugMode()) break block3;
                    this.plugin.getLogger().warning("Error processing boss bar placeholders: " + e.getMessage());
                }
            }
        }
        return title;
    }

    public void sendActionBar(Player player, String key) {
        this.sendActionBar(player, key, Map.of());
    }

    public void sendActionBar(Player player, String key, Map<String, String> placeholders) {
        if (!this.plugin.getConfigManager().isActionBarEnabled()) {
            return;
        }
        String message = this.getMessage(key, placeholders);
        if (!message.isEmpty() && !message.equals(key)) {
            message = this.processPlaceholders(player, message);
            try {
                player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(message));
            }
            catch (Exception e) {
                player.sendMessage(message);
            }
        }
    }

    private void saveMessages() {
        try {
            this.messages.save(this.messagesFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save messages file: " + e.getMessage());
        }
    }

    public void reload() {
        this.loadMessages();
    }

    public String getCurrentLanguage() {
        return this.currentLanguage;
    }

    public boolean changeLanguage(String newLanguage) {
        String oldLanguage = this.currentLanguage;
        this.currentLanguage = newLanguage;
        try {
            String fileName = "messages_" + newLanguage + ".yml";
            File newMessagesFile = new File(this.plugin.getDataFolder(), fileName);
            if (!newMessagesFile.exists()) {
                try {
                    InputStream resourceStream = this.plugin.getResource(fileName);
                    if (resourceStream == null) {
                        this.plugin.getLogger().warning("Language file " + fileName + " not found in resources");
                        this.currentLanguage = oldLanguage;
                        return false;
                    }
                    Files.copy(resourceStream, newMessagesFile.toPath(), new CopyOption[0]);
                    this.plugin.getLogger().info("Created " + fileName + " from template");
                }
                catch (IOException e) {
                    this.plugin.getLogger().warning("Failed to create language file: " + e.getMessage());
                    this.currentLanguage = oldLanguage;
                    return false;
                }
            }
            this.messagesFile = newMessagesFile;
            this.messages = YamlConfiguration.loadConfiguration((File)this.messagesFile);
            this.setDefaults();
            this.autoUpdater.updateMessagesIfNeeded(newLanguage);
            this.messages = YamlConfiguration.loadConfiguration((File)this.messagesFile);
            this.prefix = this.getMessage("prefix");
            this.plugin.getLogger().info("Changed language from " + oldLanguage + " to " + newLanguage);
            return true;
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to change language to " + newLanguage + ", reverting to " + oldLanguage + ": " + e.getMessage());
            this.currentLanguage = oldLanguage;
            try {
                this.loadMessages();
            }
            catch (Exception revertError) {
                this.plugin.getLogger().severe("Failed to revert to old language: " + revertError.getMessage());
            }
            return false;
        }
    }
}

