/*
 * Decompiled with CFR 0.152.
 */
package com.github.k1ritoz.vote2Sleep.managers;

import com.github.k1ritoz.vote2Sleep.Vote2Sleep;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Vote2SleepPlaceholders
extends PlaceholderExpansion {
    private final Vote2Sleep plugin;

    public Vote2SleepPlaceholders(Vote2Sleep plugin) {
        this.plugin = plugin;
    }

    @NotNull
    public String getIdentifier() {
        return "vote2sleep";
    }

    @NotNull
    public String getAuthor() {
        return String.join((CharSequence)", ", this.plugin.getDescription().getAuthors());
    }

    @NotNull
    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }

    public boolean persist() {
        return true;
    }

    public boolean canRegister() {
        return this.plugin != null;
    }

    @Nullable
    public String onPlaceholderRequest(Player player, @NotNull String params) {
        if (player == null) {
            return this.handleGlobalPlaceholder(params);
        }
        World world = player.getWorld();
        if (!this.plugin.isEnabled()) {
            return null;
        }
        if (this.plugin.getVoteManager() == null) {
            return null;
        }
        try {
            switch (params.toLowerCase()) {
                case "current_votes": {
                    return String.valueOf(this.plugin.getVoteManager().getCurrentVotes(world));
                }
                case "required_votes": {
                    return String.valueOf(this.plugin.getVoteManager().getRequiredVotes(world));
                }
                case "remaining_votes": {
                    int current = this.plugin.getVoteManager().getCurrentVotes(world);
                    int required = this.plugin.getVoteManager().getRequiredVotes(world);
                    return String.valueOf(Math.max(0, required - current));
                }
                case "has_voted": {
                    return String.valueOf(this.plugin.getVoteManager().hasPlayerVoted(player));
                }
                case "has_voted_yes_no": {
                    return this.plugin.getVoteManager().hasPlayerVoted(player) ? "Yes" : "No";
                }
                case "world_enabled": {
                    return String.valueOf(this.plugin.getConfigManager().isWorldEnabled(world));
                }
                case "world_enabled_yes_no": {
                    return this.plugin.getConfigManager().isWorldEnabled(world) ? "Yes" : "No";
                }
                case "can_sleep": {
                    return String.valueOf(this.canSleep(world));
                }
                case "can_sleep_yes_no": {
                    return this.canSleep(world) ? "Yes" : "No";
                }
                case "is_night": {
                    return String.valueOf(this.isNight(world));
                }
                case "is_night_yes_no": {
                    return this.isNight(world) ? "Yes" : "No";
                }
                case "is_stormy": {
                    return String.valueOf(world.hasStorm() || world.isThundering());
                }
                case "is_stormy_yes_no": {
                    return world.hasStorm() || world.isThundering() ? "Yes" : "No";
                }
                case "progress_percentage": {
                    int currentVotes = this.plugin.getVoteManager().getCurrentVotes(world);
                    int requiredVotes = this.plugin.getVoteManager().getRequiredVotes(world);
                    return String.valueOf(requiredVotes > 0 ? Math.round((double)currentVotes * 100.0 / (double)requiredVotes) : 0L);
                }
                case "progress_decimal": {
                    int currentVotesDecimal = this.plugin.getVoteManager().getCurrentVotes(world);
                    int requiredVotesDecimal = this.plugin.getVoteManager().getRequiredVotes(world);
                    return String.format("%.2f", requiredVotesDecimal > 0 ? (double)currentVotesDecimal / (double)requiredVotesDecimal : 0.0);
                }
                case "world_name": {
                    return world.getName();
                }
                case "vote_percentage_setting": {
                    double percentage = this.plugin.getConfigManager().getVotePercentage(world);
                    return String.valueOf(Math.round(percentage * 100.0));
                }
                case "eligible_players": {
                    return String.valueOf(this.getEligiblePlayerCount(world));
                }
                case "total_players": {
                    return String.valueOf(world.getPlayers().size());
                }
                case "time_formatted": {
                    return this.formatTime(world.getTime());
                }
                case "world_time": {
                    return String.valueOf(world.getTime());
                }
                case "world_time_12h": {
                    return this.formatTime12Hour(world.getTime());
                }
                case "world_time_24h": {
                    return this.formatTime24Hour(world.getTime());
                }
            }
            return null;
        }
        catch (Exception e) {
            if (this.plugin.getConfigManager() != null && this.plugin.getConfigManager().isDebugMode()) {
                this.plugin.getLogger().warning("Error processing placeholder '" + params + "': " + e.getMessage());
            }
            return null;
        }
    }

    @Nullable
    private String handleGlobalPlaceholder(String params) {
        try {
            switch (params.toLowerCase()) {
                case "plugin_version": {
                    return this.plugin.getDescription().getVersion();
                }
                case "platform": {
                    return this.plugin.getPlatformAdapter() != null ? this.plugin.getPlatformAdapter().getPlatformName() : "Unknown";
                }
                case "enabled_worlds_count": {
                    return String.valueOf(this.plugin.getConfigManager().getEnabledWorlds().size());
                }
                case "database_enabled": {
                    return String.valueOf(this.plugin.getConfigManager().isDatabaseEnabled());
                }
                case "database_enabled_yes_no": {
                    return this.plugin.getConfigManager().isDatabaseEnabled() ? "Yes" : "No";
                }
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private boolean canSleep(World world) {
        boolean isNight = this.isNight(world);
        boolean isStormy = world.hasStorm() || world.isThundering();
        return isNight && this.plugin.getConfigManager().isNightSkipAllowed() || isStormy && this.plugin.getConfigManager().isStormSkipAllowed();
    }

    private boolean isNight(World world) {
        long time = world.getTime();
        return time >= 12542L && time <= 23459L;
    }

    private int getEligiblePlayerCount(World world) {
        return (int)world.getPlayers().stream().filter(p -> !this.isPlayerExempt((Player)p)).count();
    }

    private boolean isPlayerExempt(Player player) {
        try {
            String gameMode = player.getGameMode().name();
            if (this.plugin.getConfigManager().getExemptGameModes().contains(gameMode)) {
                return true;
            }
            for (String permission : this.plugin.getConfigManager().getExemptPermissions()) {
                if (!player.hasPermission(permission)) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private String formatTime(long ticks) {
        long totalMinutes = (ticks + 6000L) / 1000L * 60L / 60L;
        long hours = (totalMinutes %= 1440L) / 60L;
        long minutes = totalMinutes % 60L;
        return String.format("%02d:%02d", hours, minutes);
    }

    private String formatTime12Hour(long ticks) {
        String amPm;
        long totalMinutes = (ticks + 6000L) / 1000L * 60L / 60L;
        long hours = (totalMinutes %= 1440L) / 60L;
        long minutes = totalMinutes % 60L;
        String string = amPm = hours < 12L ? "AM" : "PM";
        hours = hours == 0L ? 12L : (hours > 12L ? hours - 12L : hours);
        return String.format("%d:%02d %s", hours, minutes, amPm);
    }

    private String formatTime24Hour(long ticks) {
        long totalMinutes = (ticks + 6000L) / 1000L * 60L / 60L;
        long hours = (totalMinutes %= 1440L) / 60L;
        long minutes = totalMinutes % 60L;
        return String.format("%02d:%02d", hours, minutes);
    }
}

