/*
 * Decompiled with CFR 0.152.
 */
package com.github.k1ritoz.vote2Sleep;

import com.github.k1ritoz.vote2Sleep.api.Vote2SleepAPI;
import com.github.k1ritoz.vote2Sleep.commands.SleepCommand;
import com.github.k1ritoz.vote2Sleep.config.ConfigurationManager;
import com.github.k1ritoz.vote2Sleep.listeners.PlayerBedListener;
import com.github.k1ritoz.vote2Sleep.listeners.PlayerConnectionListener;
import com.github.k1ritoz.vote2Sleep.listeners.WeatherChangeListener;
import com.github.k1ritoz.vote2Sleep.listeners.WorldEventListener;
import com.github.k1ritoz.vote2Sleep.managers.DatabaseManager;
import com.github.k1ritoz.vote2Sleep.managers.DawnAnimationManager;
import com.github.k1ritoz.vote2Sleep.managers.EffectsManager;
import com.github.k1ritoz.vote2Sleep.managers.HooksManager;
import com.github.k1ritoz.vote2Sleep.managers.MessageManager;
import com.github.k1ritoz.vote2Sleep.managers.SleepVoteManager;
import com.github.k1ritoz.vote2Sleep.platform.PlatformAdapter;
import com.github.k1ritoz.vote2Sleep.platform.PlatformDetector;
import com.github.k1ritoz.vote2Sleep.utils.UpdateChecker;
import com.github.k1ritoz.vote2sleep.lib.bstats.bukkit.Metrics;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class Vote2Sleep
extends JavaPlugin {
    private static Vote2Sleep instance;
    private PlatformAdapter platformAdapter;
    private ConfigurationManager configManager;
    private MessageManager messageManager;
    private SleepVoteManager voteManager;
    private EffectsManager effectsManager;
    private DatabaseManager databaseManager;
    private HooksManager hooksManager;
    private DawnAnimationManager dawnAnimationManager;
    private Vote2SleepAPI api;
    private UpdateChecker updateChecker;

    public void onLoad() {
        instance = this;
        this.platformAdapter = PlatformDetector.createAdapter();
        this.getLogger().info("Detected platform: " + this.platformAdapter.getPlatformName());
    }

    public void onEnable() {
        if (!this.platformAdapter.isVersionSupported()) {
            this.getLogger().severe("Unsupported server version! Requires MC 1.21+");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        try {
            block11: {
                this.initializeManagers();
                this.registerCommands();
                this.registerListeners();
                this.api = new Vote2SleepAPI(this);
                if (this.configManager.isMetricsEnabled()) {
                    this.initializeMetrics();
                }
                if (this.configManager.isUpdateCheckEnabled()) {
                    try {
                        this.updateChecker = new UpdateChecker(this, "https://api.github.com/repos/k1ritoz/Vote2Sleep/releases/latest");
                        if (this.updateChecker != null) {
                            this.updateChecker.checkForUpdates();
                            this.updateChecker.startPeriodicChecking();
                            if (this.configManager.isDebugMode()) {
                                this.getLogger().info("Update checker initialized with 24h periodic checks");
                            }
                            break block11;
                        }
                        this.getLogger().warning("Failed to initialize update checker - instance is null");
                    }
                    catch (Exception e) {
                        this.getLogger().warning("Failed to initialize update checker: " + e.getMessage());
                        if (this.configManager.isDebugMode()) {
                            e.printStackTrace();
                        }
                        break block11;
                    }
                }
                if (this.configManager.isDebugMode()) {
                    this.getLogger().info("Update checker disabled in configuration");
                }
            }
            this.getLogger().info("Vote2Sleep v" + this.getDescription().getVersion() + " enabled successfully!");
            this.getLogger().info("Running on " + this.platformAdapter.getPlatformName());
        }
        catch (Exception e) {
            this.getLogger().severe("Failed to enable Vote2Sleep: " + e.getMessage());
            e.printStackTrace();
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
    }

    private void initializeMetrics() {
        try {
            int pluginId = 26722;
            Metrics metrics = new Metrics((Plugin)this, pluginId);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onDisable() {
        try {
            if (this.voteManager != null) {
                this.voteManager.shutdown();
            }
            if (this.dawnAnimationManager != null) {
                this.dawnAnimationManager.cleanup();
            }
            if (this.hooksManager != null) {
                this.hooksManager.cleanup();
            }
            if (this.databaseManager != null) {
                this.databaseManager.close();
            }
            if (this.effectsManager != null) {
                this.effectsManager.cleanup();
            }
            if (this.updateChecker != null) {
                this.updateChecker.stopPeriodicChecking();
            }
            this.getLogger().info("Vote2Sleep disabled successfully!");
        }
        catch (Exception e) {
            this.getLogger().severe("Error during plugin shutdown: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void initializeManagers() {
        try {
            this.configManager = new ConfigurationManager(this);
            this.configManager.loadConfig();
            this.getLogger().info("Configuration loaded");
            this.messageManager = new MessageManager(this);
            this.messageManager.loadMessages();
            this.getLogger().info("Messages loaded");
            this.databaseManager = new DatabaseManager(this);
            this.getLogger().info("Database manager initialized");
            this.hooksManager = new HooksManager(this);
            this.getLogger().info("Hooks manager initialized");
            this.effectsManager = new EffectsManager(this);
            this.getLogger().info("Effects manager initialized");
            this.dawnAnimationManager = new DawnAnimationManager(this);
            this.getLogger().info("Dawn animation manager initialized");
            this.voteManager = new SleepVoteManager(this);
            this.getLogger().info("Vote manager initialized");
            this.hooksManager.initializeHooks();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize managers", e);
        }
    }

    private void registerCommands() {
        try {
            SleepCommand sleepCommand;
            if (this.getCommand("sleep") != null) {
                sleepCommand = new SleepCommand(this);
                this.getCommand("sleep").setExecutor((CommandExecutor)sleepCommand);
                this.getCommand("sleep").setTabCompleter((TabCompleter)sleepCommand);
            }
            if (this.getCommand("v2s") != null) {
                sleepCommand = new SleepCommand(this);
                this.getCommand("v2s").setExecutor((CommandExecutor)sleepCommand);
                this.getCommand("v2s").setTabCompleter((TabCompleter)sleepCommand);
            }
            if (this.getCommand("vote2sleep") != null) {
                sleepCommand = new SleepCommand(this);
                this.getCommand("vote2sleep").setExecutor((CommandExecutor)sleepCommand);
                this.getCommand("vote2sleep").setTabCompleter((TabCompleter)sleepCommand);
            }
            this.getLogger().info("Commands registered successfully");
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to register commands", e);
        }
    }

    private void registerListeners() {
        try {
            this.getServer().getPluginManager().registerEvents((Listener)new PlayerBedListener(this), (Plugin)this);
            this.getServer().getPluginManager().registerEvents((Listener)new PlayerConnectionListener(this), (Plugin)this);
            this.getServer().getPluginManager().registerEvents((Listener)new WorldEventListener(this), (Plugin)this);
            this.getServer().getPluginManager().registerEvents((Listener)new WeatherChangeListener(this), (Plugin)this);
            this.getLogger().info("Event listeners registered successfully");
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to register listeners", e);
        }
    }

    public void reloadPlugin() {
        try {
            if (this.configManager != null) {
                this.configManager.reload();
            }
            if (this.messageManager != null) {
                this.messageManager.reload();
            }
            if (this.hooksManager != null) {
                this.hooksManager.reinitializeHooks();
            }
            this.getLogger().info("Plugin reloaded successfully");
        }
        catch (Exception e) {
            this.getLogger().severe("Error during plugin reload: " + e.getMessage());
            throw e;
        }
    }

    public static Vote2Sleep getInstance() {
        return instance;
    }

    public PlatformAdapter getPlatformAdapter() {
        return this.platformAdapter;
    }

    public ConfigurationManager getConfigManager() {
        return this.configManager;
    }

    public MessageManager getMessageManager() {
        return this.messageManager;
    }

    public SleepVoteManager getVoteManager() {
        return this.voteManager;
    }

    public EffectsManager getEffectsManager() {
        return this.effectsManager;
    }

    public DatabaseManager getDatabaseManager() {
        return this.databaseManager;
    }

    public HooksManager getHooksManager() {
        return this.hooksManager;
    }

    public DawnAnimationManager getDawnAnimationManager() {
        return this.dawnAnimationManager;
    }

    public Vote2SleepAPI getApi() {
        return this.api;
    }

    public boolean isFullyInitialized() {
        return this.configManager != null && this.messageManager != null && this.voteManager != null && this.effectsManager != null && this.databaseManager != null && this.hooksManager != null && this.dawnAnimationManager != null;
    }
}

