/*
 * Decompiled with CFR 0.152.
 */
package com.github.k1ritoz.vote2Sleep.config;

import com.github.k1ritoz.vote2Sleep.Vote2Sleep;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class AutoConfigUpdater {
    private final Vote2Sleep plugin;

    public AutoConfigUpdater(Vote2Sleep plugin) {
        this.plugin = plugin;
    }

    public boolean updateConfigIfNeeded() {
        try {
            double defaultConfigVersion;
            File userConfigFile = new File(this.plugin.getDataFolder(), "config.yml");
            if (!userConfigFile.exists()) {
                return false;
            }
            YamlConfiguration userConfig = YamlConfiguration.loadConfiguration((File)userConfigFile);
            FileConfiguration defaultConfig = this.getDefaultConfig();
            if (defaultConfig == null) {
                this.plugin.getLogger().warning("Could not load default config for comparison");
                return false;
            }
            double userConfigVersion = userConfig.getDouble("config-version", 1.0);
            if (userConfigVersion >= (defaultConfigVersion = defaultConfig.getDouble("config-version", 1.0))) {
                return false;
            }
            Set<String> missingKeys = this.findMissingKeys((FileConfiguration)userConfig, defaultConfig);
            if (missingKeys.isEmpty() && userConfigVersion >= defaultConfigVersion) {
                userConfig.set("config-version", (Object)defaultConfigVersion);
                userConfig.save(userConfigFile);
                return false;
            }
            this.plugin.getLogger().info("Updating configuration from version " + String.format("%.1f", userConfigVersion) + " to " + String.format("%.1f", defaultConfigVersion));
            this.plugin.getLogger().info("Found " + missingKeys.size() + " new configuration options");
            this.backupConfig(userConfigFile);
            this.updateConfigWithComments(userConfigFile, defaultConfig, missingKeys);
            YamlConfiguration updatedConfig = YamlConfiguration.loadConfiguration((File)userConfigFile);
            updatedConfig.set("config-version", (Object)defaultConfigVersion);
            updatedConfig.save(userConfigFile);
            this.plugin.getLogger().info("Configuration updated successfully! Added: " + String.valueOf(missingKeys));
            return true;
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error updating configuration: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    public boolean updateMessagesIfNeeded(String language) {
        try {
            double defaultMessageVersion;
            String fileName = "messages_" + language + ".yml";
            File userMessagesFile = new File(this.plugin.getDataFolder(), fileName);
            if (!userMessagesFile.exists()) {
                return false;
            }
            YamlConfiguration userMessages = YamlConfiguration.loadConfiguration((File)userMessagesFile);
            FileConfiguration defaultMessages = this.getDefaultMessages(language);
            if (defaultMessages == null) {
                this.plugin.getLogger().warning("Could not load default messages for " + language);
                return false;
            }
            double userMessageVersion = userMessages.getDouble("message-version", 1.0);
            if (userMessageVersion >= (defaultMessageVersion = defaultMessages.getDouble("message-version", 1.0))) {
                return false;
            }
            Set<String> missingKeys = this.findMissingKeys((FileConfiguration)userMessages, defaultMessages);
            if (missingKeys.isEmpty() && userMessageVersion >= defaultMessageVersion) {
                userMessages.set("message-version", (Object)defaultMessageVersion);
                userMessages.save(userMessagesFile);
                return false;
            }
            this.plugin.getLogger().info("Updating " + language + " messages from version " + String.format("%.1f", userMessageVersion) + " to " + String.format("%.1f", defaultMessageVersion));
            this.plugin.getLogger().info("Found " + missingKeys.size() + " new message keys");
            this.backupMessages(userMessagesFile, language);
            this.updateMessagesWithComments(userMessagesFile, defaultMessages, missingKeys);
            YamlConfiguration updatedMessages = YamlConfiguration.loadConfiguration((File)userMessagesFile);
            updatedMessages.set("message-version", (Object)defaultMessageVersion);
            updatedMessages.save(userMessagesFile);
            this.plugin.getLogger().info("Messages updated successfully! Added: " + String.valueOf(missingKeys));
            return true;
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error updating messages for " + language + ": " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private FileConfiguration getDefaultConfig() {
        try (InputStream stream = this.plugin.getResource("config.yml");){
            if (stream == null) {
                FileConfiguration fileConfiguration = null;
                return fileConfiguration;
            }
            File tempFile = File.createTempFile("vote2sleep-default-config", ".yml");
            Files.copy(stream, tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)tempFile);
            tempFile.delete();
            YamlConfiguration yamlConfiguration = config;
            return yamlConfiguration;
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private FileConfiguration getDefaultMessages(String language) {
        try (InputStream stream = this.plugin.getResource("messages_" + language + ".yml");){
            if (stream == null) {
                FileConfiguration fileConfiguration = null;
                return fileConfiguration;
            }
            File tempFile = File.createTempFile("vote2sleep-default-messages", ".yml");
            Files.copy(stream, tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            YamlConfiguration messages = YamlConfiguration.loadConfiguration((File)tempFile);
            tempFile.delete();
            YamlConfiguration yamlConfiguration = messages;
            return yamlConfiguration;
        }
        catch (IOException e) {
            return null;
        }
    }

    private Set<String> findMissingKeys(FileConfiguration userConfig, FileConfiguration defaultConfig) {
        HashSet<String> missingKeys = new HashSet<String>();
        Set<String> defaultKeys = this.getAllKeys(defaultConfig);
        Set<String> userKeys = this.getAllKeys(userConfig);
        for (String key : defaultKeys) {
            if (userKeys.contains(key) || key.equals("config-version") || key.equals("message-version")) continue;
            missingKeys.add(key);
        }
        return missingKeys;
    }

    private Set<String> getAllKeys(FileConfiguration config) {
        HashSet<String> keys = new HashSet<String>();
        this.getAllKeysRecursive((ConfigurationSection)config.getRoot(), "", keys);
        return keys;
    }

    private void getAllKeysRecursive(ConfigurationSection section, String prefix, Set<String> keys) {
        for (String key : section.getKeys(false)) {
            String fullKey;
            String string = fullKey = prefix.isEmpty() ? key : prefix + "." + key;
            if (section.isConfigurationSection(key)) {
                this.getAllKeysRecursive(section.getConfigurationSection(key), fullKey, keys);
                continue;
            }
            keys.add(fullKey);
        }
    }

    private void backupConfig(File configFile) throws IOException {
        File backupFile = new File(this.plugin.getDataFolder(), "config.yml.backup." + System.currentTimeMillis());
        Files.copy(configFile.toPath(), backupFile.toPath(), new CopyOption[0]);
        this.plugin.getLogger().info("Configuration backed up to: " + backupFile.getName());
    }

    private void backupMessages(File messagesFile, String language) throws IOException {
        File backupFile = new File(this.plugin.getDataFolder(), "messages_" + language + ".yml.backup." + System.currentTimeMillis());
        Files.copy(messagesFile.toPath(), backupFile.toPath(), new CopyOption[0]);
        this.plugin.getLogger().info("Messages backed up to: " + backupFile.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateConfigWithComments(File userConfigFile, FileConfiguration defaultConfig, Set<String> missingKeys) throws IOException {
        YamlConfiguration userConfig = YamlConfiguration.loadConfiguration((File)userConfigFile);
        File tempFile = File.createTempFile("vote2sleep-config-update", ".yml");
        try {
            try (InputStream defaultStream = this.plugin.getResource("config.yml");){
                Files.copy(defaultStream, tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            YamlConfiguration cleanConfig = YamlConfiguration.loadConfiguration((File)tempFile);
            this.transferUserValues((FileConfiguration)userConfig, (FileConfiguration)cleanConfig);
            cleanConfig.save(userConfigFile);
        }
        finally {
            tempFile.delete();
        }
    }

    private void transferUserValues(FileConfiguration userConfig, FileConfiguration cleanConfig) {
        Set<String> userKeys = this.getAllKeys(userConfig);
        for (String key : userKeys) {
            if (key.equals("config-version") || key.equals("message-version") || !cleanConfig.contains(key)) continue;
            Object userValue = userConfig.get(key);
            cleanConfig.set(key, userValue);
            if (!this.plugin.getConfigManager().isDebugMode()) continue;
            this.plugin.getLogger().info("Preserved user setting: " + key + " = " + String.valueOf(userValue));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMessagesWithComments(File userMessagesFile, FileConfiguration defaultMessages, Set<String> missingKeys) throws IOException {
        YamlConfiguration userMessages = YamlConfiguration.loadConfiguration((File)userMessagesFile);
        String language = userMessagesFile.getName().replace("messages_", "").replace(".yml", "");
        File tempFile = File.createTempFile("vote2sleep-messages-update", ".yml");
        try {
            try (InputStream defaultStream = this.plugin.getResource("messages_" + language + ".yml");){
                Files.copy(defaultStream, tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            YamlConfiguration cleanMessages = YamlConfiguration.loadConfiguration((File)tempFile);
            this.transferUserValues((FileConfiguration)userMessages, (FileConfiguration)cleanMessages);
            cleanMessages.save(userMessagesFile);
        }
        finally {
            tempFile.delete();
        }
    }
}

