/*
 * Decompiled with CFR 0.152.
 */
package com.github.k1ritoz.vote2Sleep.config;

import com.github.k1ritoz.vote2Sleep.Vote2Sleep;
import com.github.k1ritoz.vote2Sleep.config.AutoConfigUpdater;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigurationManager {
    private final Vote2Sleep plugin;
    private FileConfiguration config;
    private FileConfiguration worldConfig;
    private File worldsFile;
    private AutoConfigUpdater autoUpdater;

    public ConfigurationManager(Vote2Sleep plugin) {
        this.plugin = plugin;
        this.autoUpdater = new AutoConfigUpdater(plugin);
    }

    public void loadConfig() {
        this.loadConfigurations();
        this.autoUpdater.updateConfigIfNeeded();
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
    }

    public void loadConfigurations() {
        this.plugin.saveDefaultConfig();
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
        this.worldsFile = new File(this.plugin.getDataFolder(), "worlds.yml");
        if (!this.worldsFile.exists()) {
            try {
                this.worldsFile.createNewFile();
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Could not create worlds.yml file: " + e.getMessage());
            }
        }
        this.worldConfig = YamlConfiguration.loadConfiguration((File)this.worldsFile);
        this.setDefaults();
    }

    private void setDefaults() {
        if (!this.config.contains("settings.language")) {
            this.config.set("settings.language", (Object)"en");
        }
        if (!this.config.contains("settings.vote-percentage")) {
            this.config.set("settings.vote-percentage", (Object)0.5);
        }
        if (!this.config.contains("settings.minimum-players")) {
            this.config.set("settings.minimum-players", (Object)1);
        }
        if (!this.config.contains("settings.maximum-players")) {
            this.config.set("settings.maximum-players", (Object)-1);
        }
        if (!this.config.contains("settings.skip-delay-seconds")) {
            this.config.set("settings.skip-delay-seconds", (Object)3);
        }
        if (!this.config.contains("settings.vote-timeout-seconds")) {
            this.config.set("settings.vote-timeout-seconds", (Object)60);
        }
        if (!this.config.contains("settings.allow-storm-skip")) {
            this.config.set("settings.allow-storm-skip", (Object)true);
        }
        if (!this.config.contains("settings.allow-night-skip")) {
            this.config.set("settings.allow-night-skip", (Object)true);
        }
        if (!this.config.contains("settings.reset-statistics")) {
            this.config.set("settings.reset-statistics", (Object)true);
        }
        if (!this.config.contains("settings.heal-players")) {
            this.config.set("settings.heal-players", (Object)false);
        }
        if (!this.config.contains("settings.feed-players")) {
            this.config.set("settings.feed-players", (Object)false);
        }
        if (!this.config.contains("settings.clear-weather")) {
            this.config.set("settings.clear-weather", (Object)true);
        }
        if (!this.config.contains("settings.bed-interaction")) {
            this.config.set("settings.bed-interaction", (Object)true);
        }
        if (!this.config.contains("display.boss-bar.enabled")) {
            this.config.set("display.boss-bar.enabled", (Object)true);
        }
        if (!this.config.contains("display.boss-bar.color")) {
            this.config.set("display.boss-bar.color", (Object)"BLUE");
        }
        if (!this.config.contains("display.boss-bar.style")) {
            this.config.set("display.boss-bar.style", (Object)"SOLID");
        }
        if (!this.config.contains("display.titles.enabled")) {
            this.config.set("display.titles.enabled", (Object)true);
        }
        if (!this.config.contains("display.titles.fade-in")) {
            this.config.set("display.titles.fade-in", (Object)10);
        }
        if (!this.config.contains("display.titles.stay")) {
            this.config.set("display.titles.stay", (Object)70);
        }
        if (!this.config.contains("display.titles.fade-out")) {
            this.config.set("display.titles.fade-out", (Object)20);
        }
        if (!this.config.contains("display.sounds.enabled")) {
            this.config.set("display.sounds.enabled", (Object)true);
        }
        if (!this.config.contains("display.sounds.vote-sound")) {
            this.config.set("display.sounds.vote-sound", (Object)"BLOCK_NOTE_BLOCK_CHIME");
        }
        if (!this.config.contains("display.sounds.skip-sound")) {
            this.config.set("display.sounds.skip-sound", (Object)"ENTITY_EXPERIENCE_ORB_PICKUP");
        }
        if (!this.config.contains("display.actionbar.enabled")) {
            this.config.set("display.actionbar.enabled", (Object)true);
        }
        if (!this.config.contains("effects.lightning-on-skip")) {
            this.config.set("effects.lightning-on-skip", (Object)false);
        }
        if (!this.config.contains("effects.lightning-chance")) {
            this.config.set("effects.lightning-chance", (Object)0.3);
        }
        if (!this.config.contains("effects.particle-effects")) {
            this.config.set("effects.particle-effects", (Object)true);
        }
        this.config.addDefault("animation.dawn.enabled", (Object)false);
        this.config.addDefault("animation.dawn.duration-seconds", (Object)3);
        this.config.addDefault("animation.dawn.animation-steps", (Object)32);
        this.config.addDefault("animation.dawn.title.enabled", (Object)true);
        this.config.addDefault("animation.dawn.boss-bar.enabled", (Object)true);
        this.config.addDefault("animation.dawn.boss-bar.color", (Object)"YELLOW");
        this.config.addDefault("animation.dawn.boss-bar.style", (Object)"SOLID");
        this.config.addDefault("animation.dawn.particles.enabled", (Object)true);
        this.config.addDefault("animation.dawn.particles.type", (Object)"ENCHANT");
        this.config.addDefault("animation.dawn.sounds.animation-sound", (Object)"BLOCK_AMETHYST_BLOCK_CHIME");
        this.config.addDefault("animation.dawn.sounds.final-sound", (Object)"ENTITY_EXPERIENCE_ORB_PICKUP");
        if (!this.config.contains("advanced.database.enabled")) {
            this.config.set("advanced.database.enabled", (Object)false);
        }
        if (!this.config.contains("advanced.database.type")) {
            this.config.set("advanced.database.type", (Object)"SQLITE");
        }
        if (!this.config.contains("advanced.update-checker")) {
            this.config.set("advanced.update-checker", (Object)true);
        }
        if (!this.config.contains("advanced.debug-mode")) {
            this.config.set("advanced.debug-mode", (Object)false);
        }
        if (!this.config.contains("advanced.metrics")) {
            this.config.set("advanced.metrics", (Object)true);
        }
        if (!this.config.contains("advanced.exempt-gamemodes")) {
            this.config.set("advanced.exempt-gamemodes", Arrays.asList("SPECTATOR", "CREATIVE"));
        }
        if (!this.config.contains("advanced.exempt-permissions")) {
            this.config.set("advanced.exempt-permissions", Arrays.asList("vote2sleep.exempt"));
        }
        this.plugin.saveConfig();
    }

    public boolean isWorldEnabled(World world) {
        return this.worldConfig.getBoolean("worlds." + world.getName() + ".enabled", false);
    }

    public void enableWorld(World world) {
        this.worldConfig.set("worlds." + world.getName() + ".enabled", (Object)true);
        this.saveWorldsConfig();
    }

    public void disableWorld(World world) {
        this.worldConfig.set("worlds." + world.getName() + ".enabled", (Object)false);
        this.saveWorldsConfig();
    }

    public Set<String> getEnabledWorlds() {
        ConfigurationSection worldsSection = this.worldConfig.getConfigurationSection("worlds");
        if (worldsSection == null) {
            return Set.of();
        }
        return worldsSection.getKeys(false);
    }

    public double getVotePercentage(World world) {
        return this.worldConfig.getDouble("worlds." + world.getName() + ".vote-percentage", this.config.getDouble("settings.vote-percentage"));
    }

    public void setVotePercentage(World world, double percentage) {
        this.worldConfig.set("worlds." + world.getName() + ".vote-percentage", (Object)percentage);
        this.saveWorldsConfig();
    }

    public String getLanguage() {
        return this.config.getString("settings.language");
    }

    public int getMinimumPlayers() {
        return this.config.getInt("settings.minimum-players");
    }

    public int getMaximumPlayers() {
        return this.config.getInt("settings.maximum-players");
    }

    public int getSkipDelaySeconds() {
        return this.config.getInt("settings.skip-delay-seconds");
    }

    public int getVoteTimeoutSeconds() {
        return this.config.getInt("settings.vote-timeout-seconds");
    }

    public boolean isStormSkipAllowed() {
        return this.config.getBoolean("settings.allow-storm-skip");
    }

    public boolean isNightSkipAllowed() {
        return this.config.getBoolean("settings.allow-night-skip");
    }

    public boolean shouldResetStatistics() {
        return this.config.getBoolean("settings.reset-statistics");
    }

    public boolean shouldHealPlayers() {
        return this.config.getBoolean("settings.heal-players");
    }

    public boolean shouldFeedPlayers() {
        return this.config.getBoolean("settings.feed-players");
    }

    public boolean shouldClearWeather() {
        return this.config.getBoolean("settings.clear-weather");
    }

    public boolean isBedInteractionEnabled() {
        return this.config.getBoolean("settings.bed-interaction");
    }

    public boolean isBossBarEnabled() {
        return this.config.getBoolean("display.boss-bar.enabled");
    }

    public String getBossBarColor() {
        return this.config.getString("display.boss-bar.color");
    }

    public String getBossBarStyle() {
        return this.config.getString("display.boss-bar.style");
    }

    public boolean areTitlesEnabled() {
        return this.config.getBoolean("display.titles.enabled");
    }

    public int getTitleFadeIn() {
        return this.config.getInt("display.titles.fade-in");
    }

    public int getTitleStay() {
        return this.config.getInt("display.titles.stay");
    }

    public int getTitleFadeOut() {
        return this.config.getInt("display.titles.fade-out");
    }

    public boolean areSoundsEnabled() {
        return this.config.getBoolean("display.sounds.enabled");
    }

    public String getVoteSound() {
        return this.config.getString("display.sounds.vote-sound");
    }

    public String getSkipSound() {
        return this.config.getString("display.sounds.skip-sound");
    }

    public boolean isActionBarEnabled() {
        return this.config.getBoolean("display.actionbar.enabled");
    }

    public boolean isLightningOnSkipEnabled() {
        return this.config.getBoolean("effects.lightning-on-skip");
    }

    public double getLightningChance() {
        return this.config.getDouble("effects.lightning-chance");
    }

    public boolean areParticleEffectsEnabled() {
        return this.config.getBoolean("effects.particle-effects");
    }

    public boolean isDawnAnimationEnabled() {
        return this.config.getBoolean("animation.dawn.enabled");
    }

    public int getDawnAnimationDuration() {
        return this.config.getInt("animation.dawn.duration-seconds");
    }

    public int getDawnAnimationSteps() {
        return this.config.getInt("animation.dawn.animation-steps");
    }

    public boolean isDawnTitleEnabled() {
        return this.config.getBoolean("animation.dawn.title.enabled");
    }

    public boolean isDawnBossBarEnabled() {
        return this.config.getBoolean("animation.dawn.boss-bar.enabled");
    }

    public String getDawnBossBarColor() {
        return this.config.getString("animation.dawn.boss-bar.color");
    }

    public String getDawnBossBarStyle() {
        return this.config.getString("animation.dawn.boss-bar.style");
    }

    public boolean isDawnParticlesEnabled() {
        return this.config.getBoolean("animation.dawn.particles.enabled");
    }

    public String getDawnParticleType() {
        return this.config.getString("animation.dawn.particles.type");
    }

    public String getDawnSound() {
        return this.config.getString("animation.dawn.sounds.animation-sound");
    }

    public String getDawnFinalSound() {
        return this.config.getString("animation.dawn.sounds.final-sound");
    }

    public boolean isDatabaseEnabled() {
        return this.config.getBoolean("advanced.database.enabled");
    }

    public String getDatabaseType() {
        return this.config.getString("advanced.database.type");
    }

    public boolean isUpdateCheckEnabled() {
        return this.config.getBoolean("advanced.update-checker");
    }

    public boolean isDebugMode() {
        return this.config.getBoolean("advanced.debug-mode");
    }

    public boolean isMetricsEnabled() {
        return this.config.getBoolean("advanced.metrics");
    }

    public List<String> getExemptGameModes() {
        return this.config.getStringList("advanced.exempt-gamemodes");
    }

    public List<String> getExemptPermissions() {
        return this.config.getStringList("advanced.exempt-permissions");
    }

    public void reload() {
        this.loadConfigurations();
    }

    private void saveWorldsConfig() {
        try {
            this.worldConfig.save(this.worldsFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save worlds.yml file!");
        }
    }
}

