/*
 * Decompiled with CFR 0.152.
 */
package com.github.k1ritoz.vote2Sleep.managers;

import com.github.k1ritoz.vote2Sleep.Vote2Sleep;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitTask;

public class DawnAnimationManager {
    private final Vote2Sleep plugin;
    private final Map<UUID, BukkitTask> activeAnimations;
    private final Map<UUID, BossBar> animationBossBars;
    private final Object animationLock = new Object();

    public DawnAnimationManager(Vote2Sleep plugin) {
        this.plugin = plugin;
        this.activeAnimations = new ConcurrentHashMap<UUID, BukkitTask>();
        this.animationBossBars = new ConcurrentHashMap<UUID, BossBar>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startDawnAnimation(World world) {
        if (!this.plugin.getConfigManager().isDawnAnimationEnabled()) {
            return;
        }
        Object object = this.animationLock;
        synchronized (object) {
            if (this.activeAnimations.containsKey(world.getUID())) {
                return;
            }
            if (!this.isNight(world)) {
                if (this.plugin.getConfigManager().isDebugMode()) {
                    this.plugin.getLogger().info("Dawn animation skipped - not night time");
                }
                return;
            }
            if (this.plugin.getConfigManager().isDebugMode()) {
                this.plugin.getLogger().info("Starting dawn animation for world: " + world.getName());
            }
            this.plugin.getPlatformAdapter().runTaskLater(() -> {
                block2: {
                    try {
                        this.plugin.getVoteManager().clearVotes(world);
                    }
                    catch (Exception e) {
                        if (!this.plugin.getConfigManager().isDebugMode()) break block2;
                        this.plugin.getLogger().warning("Error clearing votes before animation: " + e.getMessage());
                    }
                }
            }, 1L);
            this.startTimeAcceleration(world);
        }
    }

    private void startTimeAcceleration(World world) {
        int duration = Math.max(1, Math.min(this.plugin.getConfigManager().getDawnAnimationDuration(), 30));
        int totalSteps = Math.max(8, Math.min(this.plugin.getConfigManager().getDawnAnimationSteps(), 256));
        long startTime = world.getTime();
        long endTime = 1000L;
        long totalTimeToAdvance = this.calculateTimeDistance(startTime, endTime);
        long ticksPerStep = Math.max((long)duration * 20L / (long)totalSteps, 1L);
        long timePerStep = Math.max(totalTimeToAdvance / (long)totalSteps, 10L);
        if (this.plugin.getConfigManager().isDebugMode()) {
            this.plugin.getLogger().info("Dawn animation: " + totalTimeToAdvance + " time units over " + totalSteps + " steps in " + duration + " seconds (" + timePerStep + " time per step, " + ticksPerStep + " ticks per step)");
        }
        this.plugin.getPlatformAdapter().runTaskLater(() -> this.createAnimationVisuals(world), 3L);
        int[] currentStep = new int[]{0};
        long finalTimePerStep = timePerStep;
        int finalTotalSteps = totalSteps;
        BukkitTask animationTask = this.plugin.getPlatformAdapter().runTaskTimerForWorld(world, w -> {
            if (currentStep[0] >= finalTotalSteps) {
                this.finalizeDawnAnimation((World)w);
                return;
            }
            this.performTimeStep((World)w, startTime, finalTimePerStep, currentStep[0], finalTotalSteps);
            currentStep[0] = currentStep[0] + 1;
        }, 5L, ticksPerStep);
        this.activeAnimations.put(world.getUID(), animationTask);
    }

    private void performTimeStep(World world, long startTime, long timePerStep, long currentStep, int totalSteps) {
        if (!this.activeAnimations.containsKey(world.getUID())) {
            return;
        }
        try {
            long newTime = (startTime + timePerStep * (currentStep + 1L)) % 24000L;
            world.setTime(newTime);
            double progress = (double)(currentStep + 1L) / (double)totalSteps;
            this.updateAnimationProgress(world, progress);
        }
        catch (Exception e) {
            if (this.plugin.getConfigManager().isDebugMode()) {
                this.plugin.getLogger().warning("Error during dawn animation time step: " + e.getMessage());
            }
            this.stopDawnAnimation(world);
        }
    }

    private void createAnimationVisuals(World world) {
        if (this.plugin.getConfigManager().isDawnBossBarEnabled()) {
            this.createAnimationBossBar(world);
        }
        if (this.plugin.getConfigManager().isDawnTitleEnabled()) {
            this.sendAnimationTitle(world, "dawn-animation-start");
        }
        if (this.plugin.getConfigManager().areSoundsEnabled()) {
            this.playDawnSound(world, this.plugin.getConfigManager().getDawnSound());
        }
    }

    private void updateAnimationProgress(World world, double progress) {
        BossBar bossBar = this.animationBossBars.get(world.getUID());
        if (bossBar != null) {
            bossBar.setProgress(Math.min(progress, 1.0));
            String title = this.plugin.getMessageManager().getMessage("dawn-animation-progress", Map.of("progress", String.valueOf((int)(progress * 100.0))));
            bossBar.setTitle(title);
        }
        int totalSteps = this.plugin.getConfigManager().getDawnAnimationSteps();
        double particleChance = Math.max(0.1, Math.min(0.6, 10.0 / (double)totalSteps));
        if (this.plugin.getConfigManager().isDawnParticlesEnabled() && Math.random() < particleChance) {
            this.spawnDawnParticles(world);
        }
    }

    private void spawnDawnParticles(World world) {
        String particleType = this.plugin.getConfigManager().getDawnParticleType();
        for (Player player : world.getPlayers()) {
            if (!(Math.random() < 0.6)) continue;
            Location loc = player.getLocation().add(0.0, 2.0, 0.0);
            try {
                Particle particle = Particle.valueOf((String)particleType.toUpperCase());
                world.spawnParticle(particle, loc, 3, 1.5, 0.8, 1.5, 0.05);
            }
            catch (IllegalArgumentException e) {
                world.spawnParticle(Particle.ENCHANT, loc, 3, 1.5, 0.8, 1.5, 0.05);
            }
        }
    }

    private void createAnimationBossBar(World world) {
        String title = this.plugin.getMessageManager().getMessage("dawn-animation-title");
        BossBar bossBar = Bukkit.createBossBar((String)title, (BarColor)BarColor.valueOf((String)this.plugin.getConfigManager().getDawnBossBarColor()), (BarStyle)BarStyle.valueOf((String)this.plugin.getConfigManager().getDawnBossBarStyle()), (BarFlag[])new BarFlag[0]);
        for (Player player : world.getPlayers()) {
            bossBar.addPlayer(player);
        }
        bossBar.setVisible(true);
        this.animationBossBars.put(world.getUID(), bossBar);
    }

    private void sendAnimationTitle(World world, String messageKey) {
        if (!this.plugin.getConfigManager().areTitlesEnabled()) {
            return;
        }
        String title = this.plugin.getMessageManager().getMessage(messageKey + "-title");
        String subtitle = this.plugin.getMessageManager().getMessage(messageKey + "-subtitle");
        for (Player player : world.getPlayers()) {
            player.sendTitle(title, subtitle, 10, 40, 10);
        }
    }

    private void playDawnSound(World world, String soundName) {
        try {
            Sound sound = Sound.valueOf((String)soundName);
            for (Player player : world.getPlayers()) {
                player.playSound(player.getLocation(), sound, 0.6f, 1.1f);
            }
        }
        catch (IllegalArgumentException e) {
            for (Player player : world.getPlayers()) {
                player.playSound(player.getLocation(), Sound.BLOCK_AMETHYST_BLOCK_CHIME, 0.6f, 1.1f);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finalizeDawnAnimation(World world) {
        block6: {
            Object object = this.animationLock;
            synchronized (object) {
                this.stopDawnAnimation(world);
            }
            try {
                world.setTime(1000L);
                if (this.plugin.getConfigManager().shouldClearWeather()) {
                    world.setStorm(false);
                    world.setThundering(false);
                }
            }
            catch (Exception e) {
                if (!this.plugin.getConfigManager().isDebugMode()) break block6;
                this.plugin.getLogger().warning("Error finalizing dawn animation world operations: " + e.getMessage());
            }
        }
        this.plugin.getPlatformAdapter().runTaskLater(() -> {
            block5: {
                try {
                    if (this.plugin.getConfigManager().isDawnTitleEnabled()) {
                        this.sendAnimationTitle(world, "dawn-animation-complete");
                    }
                    if (this.plugin.getConfigManager().areSoundsEnabled()) {
                        this.playDawnSound(world, this.plugin.getConfigManager().getDawnFinalSound());
                    }
                    this.plugin.getMessageManager().sendWorldMessage(world, "dawn-animation-complete");
                    if (this.plugin.getConfigManager().isDebugMode()) {
                        this.plugin.getLogger().info("Dawn animation completed for world: " + world.getName());
                    }
                }
                catch (Exception e) {
                    if (!this.plugin.getConfigManager().isDebugMode()) break block5;
                    this.plugin.getLogger().warning("Error finalizing dawn animation effects: " + e.getMessage());
                }
            }
        }, 5L);
    }

    private long calculateTimeDistance(long from, long to) {
        long directDistance = (to - from + 24000L) % 24000L;
        return Math.min(directDistance, 24000L - directDistance);
    }

    private boolean isNight(World world) {
        long time = world.getTime();
        return time >= 12542L && time <= 23459L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopDawnAnimation(World world) {
        Object object = this.animationLock;
        synchronized (object) {
            BossBar bossBar;
            BukkitTask task = this.activeAnimations.remove(world.getUID());
            if (task != null && !task.isCancelled()) {
                task.cancel();
            }
            if ((bossBar = this.animationBossBars.remove(world.getUID())) != null) {
                bossBar.removeAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAnimating(World world) {
        Object object = this.animationLock;
        synchronized (object) {
            return this.activeAnimations.containsKey(world.getUID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        Object object = this.animationLock;
        synchronized (object) {
            for (BukkitTask task : this.activeAnimations.values()) {
                if (task.isCancelled()) continue;
                task.cancel();
            }
            for (BossBar bossBar : this.animationBossBars.values()) {
                bossBar.removeAll();
            }
            this.activeAnimations.clear();
            this.animationBossBars.clear();
        }
    }

    public void handlePlayerJoin(Player player) {
        World world = player.getWorld();
        BossBar bossBar = this.animationBossBars.get(world.getUID());
        if (bossBar != null) {
            this.plugin.getPlatformAdapter().runTaskLater(() -> {
                if (bossBar != null && player.isOnline()) {
                    bossBar.addPlayer(player);
                }
            }, 1L);
        }
    }

    public void handlePlayerQuit(Player player) {
    }
}

