/*
 * Decompiled with CFR 0.152.
 */
package com.github.k1ritoz.vote2Sleep.managers;

import com.github.k1ritoz.vote2Sleep.Vote2Sleep;
import com.github.k1ritoz.vote2Sleep.api.events.NightSkipEvent;
import com.github.k1ritoz.vote2Sleep.api.events.PreNightSkipEvent;
import com.github.k1ritoz.vote2Sleep.api.events.PreSleepVoteEvent;
import com.github.k1ritoz.vote2Sleep.api.events.SleepVoteRemovedEvent;
import com.github.k1ritoz.vote2Sleep.data.SleepVote;
import com.github.k1ritoz.vote2Sleep.data.WorldData;
import com.github.k1ritoz.vote2Sleep.platform.FoliaAdapter;
import com.github.k1ritoz.vote2Sleep.platform.PurpurAdapter;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Statistic;
import org.bukkit.World;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.scheduler.BukkitTask;

public class SleepVoteManager {
    private final Vote2Sleep plugin;
    private final Map<UUID, WorldData> worldDataMap;
    private final Map<UUID, BossBar> worldBossBars;
    private final Map<UUID, BukkitTask> skipTasks;
    private final Map<UUID, BukkitTask> voteTimeoutTasks;
    private final Map<UUID, BukkitTask> nightCheckTasks;

    public SleepVoteManager(Vote2Sleep plugin) {
        this.plugin = plugin;
        this.worldDataMap = new ConcurrentHashMap<UUID, WorldData>();
        this.worldBossBars = new ConcurrentHashMap<UUID, BossBar>();
        this.skipTasks = new ConcurrentHashMap<UUID, BukkitTask>();
        this.voteTimeoutTasks = new ConcurrentHashMap<UUID, BukkitTask>();
        this.nightCheckTasks = new ConcurrentHashMap<UUID, BukkitTask>();
    }

    public void startSleepVote(Player player) {
        this.startSleepVoteInternal(player, true);
    }

    public void startSleepVoteFromBed(Player player) {
        if (!this.plugin.getConfigManager().isBedInteractionEnabled()) {
            this.plugin.getMessageManager().sendMessage(player, "bed-interaction-disabled");
            return;
        }
        this.startSleepVoteInternal(player, false);
    }

    private void startSleepVoteInternal(Player player, boolean skipBedCheck) {
        World world = player.getWorld();
        if (!this.plugin.getConfigManager().isWorldEnabled(world)) {
            this.plugin.getMessageManager().sendMessage(player, "world-not-enabled");
            return;
        }
        if (this.plugin.getDawnAnimationManager().isAnimating(world)) {
            this.plugin.getMessageManager().sendMessage(player, "dawn-animation-active");
            return;
        }
        if (this.isPlayerExempt(player)) {
            this.plugin.getMessageManager().sendMessage(player, "player-exempt");
            return;
        }
        if (!this.canSleep(world)) {
            this.plugin.getMessageManager().sendMessage(player, "cannot-sleep-now");
            return;
        }
        WorldData worldData = this.getOrCreateWorldData(world);
        if (worldData.hasPlayerVoted(player.getUniqueId())) {
            this.plugin.getMessageManager().sendMessage(player, "already-voted");
            return;
        }
        SleepVote vote = new SleepVote(player.getUniqueId(), player.getName(), LocalDateTime.now(), player.getLocation());
        PreSleepVoteEvent preEvent = new PreSleepVoteEvent(player, world, vote);
        Bukkit.getPluginManager().callEvent((Event)preEvent);
        if (preEvent.isCancelled()) {
            return;
        }
        worldData.addVote(vote);
        this.updateBossBar(world);
        this.sendVoteMessage(world);
        this.playVoteEffects(world, player);
        if (this.areRequirementsMet(world)) {
            this.scheduleNightSkip(world);
        } else {
            this.scheduleVoteTimeout(world);
            this.scheduleNightCheckTask(world);
        }
    }

    public void removeSleepVote(Player player) {
        World world = player.getWorld();
        WorldData worldData = this.worldDataMap.get(world.getUID());
        if (worldData == null || !worldData.hasPlayerVoted(player.getUniqueId())) {
            return;
        }
        if (this.plugin.getDawnAnimationManager().isAnimating(world)) {
            this.plugin.getMessageManager().sendMessage(player, "dawn-animation-active");
            return;
        }
        SleepVote vote = worldData.getVote(player.getUniqueId());
        worldData.removeVote(player.getUniqueId());
        SleepVoteRemovedEvent event = new SleepVoteRemovedEvent(player, world, vote);
        Bukkit.getPluginManager().callEvent((Event)event);
        this.updateBossBar(world);
        if (!this.areRequirementsMet(world)) {
            this.cancelSkipTask(world);
        }
        this.plugin.getMessageManager().sendMessage(player, "vote-removed");
    }

    private void scheduleNightCheckTask(World world) {
        this.cancelNightCheckTask(world);
        BukkitTask task = this.plugin.getPlatformAdapter().runTaskTimerForWorld(world, w -> {
            if (!this.plugin.getConfigManager().isWorldEnabled((World)w)) {
                this.cancelNightCheckTask((World)w);
                return;
            }
            WorldData worldData = this.worldDataMap.get(w.getUID());
            if (worldData == null || worldData.isEmpty()) {
                this.cancelNightCheckTask((World)w);
                return;
            }
            if (!this.canSleep((World)w)) {
                this.clearVotes((World)w);
                if (this.plugin.getConfigManager().isDebugMode()) {
                    this.plugin.getLogger().info("Natural night/storm end detected in world " + w.getName() + ", clearing votes");
                }
            }
        }, 20L, 20L);
        this.nightCheckTasks.put(world.getUID(), task);
    }

    private void scheduleNightSkip(World world) {
        this.cancelSkipTask(world);
        this.cancelVoteTimeoutTask(world);
        this.cancelNightCheckTask(world);
        int delay = this.plugin.getConfigManager().getSkipDelaySeconds() * 20;
        BukkitTask task = this.plugin.getPlatformAdapter().runTaskLater(() -> {
            if (this.areRequirementsMet(world)) {
                this.executeNightSkip(world);
            }
        }, delay);
        this.skipTasks.put(world.getUID(), task);
        this.plugin.getPlatformAdapter().runTaskLater(() -> {
            boolean night = this.isNight(world);
            String skipKey = night ? "skip-countdown" : "storm-skip-countdown";
            this.plugin.getMessageManager().sendWorldMessage(world, skipKey, Map.of("seconds", String.valueOf(this.plugin.getConfigManager().getSkipDelaySeconds())));
        }, 1L);
    }

    private void scheduleVoteTimeout(World world) {
        this.cancelVoteTimeoutTask(world);
        int timeout = this.plugin.getConfigManager().getVoteTimeoutSeconds() * 20;
        BukkitTask task = this.plugin.getPlatformAdapter().runTaskLater(() -> {
            WorldData worldData = this.worldDataMap.get(world.getUID());
            if (worldData != null && !worldData.isEmpty()) {
                this.clearVotes(world);
                this.plugin.getMessageManager().sendWorldMessage(world, "vote-timeout");
            }
        }, timeout);
        this.voteTimeoutTasks.put(world.getUID(), task);
    }

    private void executeNightSkip(World world) {
        boolean shouldAnimate;
        WorldData worldData = this.worldDataMap.get(world.getUID());
        if (worldData == null) {
            return;
        }
        ArrayList<SleepVote> votes = new ArrayList<SleepVote>(worldData.getVotes().values());
        PreNightSkipEvent preEvent = new PreNightSkipEvent(world, votes);
        Bukkit.getPluginManager().callEvent((Event)preEvent);
        if (preEvent.isCancelled()) {
            return;
        }
        boolean isNightTime = this.isNight(world);
        boolean bl = shouldAnimate = this.plugin.getConfigManager().isDawnAnimationEnabled() && isNightTime && this.plugin.getConfigManager().isNightSkipAllowed();
        if (shouldAnimate) {
            if (this.plugin.getConfigManager().isDebugMode()) {
                this.plugin.getLogger().info("Starting dawn animation for night skip in world: " + world.getName());
            }
            this.plugin.getDawnAnimationManager().startDawnAnimation(world);
            this.plugin.getPlatformAdapter().runTaskLater(() -> {
                this.performSkipActions(world, votes, false);
                NightSkipEvent skipEvent = new NightSkipEvent(world, votes);
                Bukkit.getPluginManager().callEvent((Event)skipEvent);
            }, (long)this.plugin.getConfigManager().getDawnAnimationDuration() * 20L);
        } else {
            if (this.plugin.getConfigManager().isDebugMode()) {
                this.plugin.getLogger().info("Performing immediate skip actions (no animation) for world: " + world.getName());
            }
            this.performSkipActions(world, votes, true);
            NightSkipEvent skipEvent = new NightSkipEvent(world, votes);
            Bukkit.getPluginManager().callEvent((Event)skipEvent);
        }
        this.clearVotes(world);
        if (this.plugin.getConfigManager().isDatabaseEnabled()) {
            this.plugin.getDatabaseManager().saveSkipEvent(world, votes);
        }
    }

    private void performSkipActions(World world, List<SleepVote> votes, boolean shouldSetTime) {
        boolean wasNight = this.isNight(world);
        this.plugin.getPlatformAdapter().runTaskLaterForWorld(world, w -> {
            try {
                if (shouldSetTime) {
                    if (this.plugin.getPlatformAdapter() instanceof PurpurAdapter) {
                        PurpurAdapter purpurAdapter = (PurpurAdapter)this.plugin.getPlatformAdapter();
                        if (this.isNight((World)w) && this.plugin.getConfigManager().isNightSkipAllowed()) {
                            purpurAdapter.setWorldTimeOptimized((World)w, 1000L);
                        }
                        if (this.plugin.getConfigManager().shouldClearWeather()) {
                            purpurAdapter.clearWeatherOptimized((World)w);
                        }
                    } else {
                        if (this.isNight((World)w) && this.plugin.getConfigManager().isNightSkipAllowed()) {
                            w.setTime(1000L);
                        }
                        if (this.plugin.getConfigManager().shouldClearWeather()) {
                            w.setStorm(false);
                            w.setThundering(false);
                        }
                    }
                } else if (this.plugin.getConfigManager().shouldClearWeather()) {
                    if (this.plugin.getPlatformAdapter() instanceof PurpurAdapter) {
                        ((PurpurAdapter)this.plugin.getPlatformAdapter()).clearWeatherOptimized((World)w);
                    } else {
                        w.setStorm(false);
                        w.setThundering(false);
                    }
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Error performing world skip actions: " + e.getMessage());
                e.printStackTrace();
            }
        }, 1L);
        for (SleepVote vote : votes) {
            Player player = Bukkit.getPlayer((UUID)vote.getPlayerUUID());
            if (player == null || !player.isOnline()) continue;
            this.plugin.getPlatformAdapter().runTaskLaterForPlayer(player, p -> {
                try {
                    if (this.plugin.getConfigManager().shouldResetStatistics()) {
                        try {
                            p.setStatistic(Statistic.TIME_SINCE_REST, 0);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (this.plugin.getConfigManager().shouldHealPlayers()) {
                        p.setHealth(p.getMaxHealth());
                    }
                    if (this.plugin.getConfigManager().shouldFeedPlayers()) {
                        p.setFoodLevel(20);
                        p.setSaturation(20.0f);
                    }
                    if (this.plugin.getPlatformAdapter() instanceof PurpurAdapter) {
                        ((PurpurAdapter)this.plugin.getPlatformAdapter()).optimizePlayerOperation((Player)p, () -> {});
                    }
                }
                catch (Exception e) {
                    this.plugin.getLogger().warning("Error performing player actions for " + p.getName() + ": " + e.getMessage());
                    e.printStackTrace();
                }
            }, 2L);
        }
        if (shouldSetTime) {
            this.plugin.getPlatformAdapter().runTaskLater(() -> {
                try {
                    if (wasNight) {
                        this.plugin.getMessageManager().sendWorldMessage(world, "night-skipped");
                    } else {
                        this.plugin.getMessageManager().sendWorldMessage(world, "storm-skipped");
                    }
                }
                catch (Exception e) {
                    this.plugin.getLogger().warning("Error sending skip messages: " + e.getMessage());
                    e.printStackTrace();
                }
            }, 3L);
        }
        if (shouldSetTime) {
            if (this.plugin.getPlatformAdapter() instanceof FoliaAdapter) {
                FoliaAdapter foliaAdapter = (FoliaAdapter)this.plugin.getPlatformAdapter();
                foliaAdapter.runRegionSpecificEffects(world, w -> {
                    try {
                        this.plugin.getEffectsManager().playSkipEffects((World)w, votes, wasNight);
                    }
                    catch (Exception e) {
                        this.plugin.getLogger().warning("Error playing skip effects: " + e.getMessage());
                        e.printStackTrace();
                    }
                }, 4L);
            } else {
                this.plugin.getPlatformAdapter().runTaskLater(() -> {
                    try {
                        this.plugin.getEffectsManager().playSkipEffects(world, votes, wasNight);
                    }
                    catch (Exception e) {
                        this.plugin.getLogger().warning("Error playing skip effects: " + e.getMessage());
                        e.printStackTrace();
                    }
                }, 4L);
            }
        }
    }

    private WorldData getOrCreateWorldData(World world) {
        return this.worldDataMap.computeIfAbsent(world.getUID(), k -> new WorldData(world));
    }

    private boolean isPlayerExempt(Player player) {
        String gameMode = player.getGameMode().name();
        if (this.plugin.getConfigManager().getExemptGameModes().contains(gameMode)) {
            return true;
        }
        for (String permission : this.plugin.getConfigManager().getExemptPermissions()) {
            if (!player.hasPermission(permission)) continue;
            return true;
        }
        return false;
    }

    private boolean canSleep(World world) {
        boolean isNight = this.isNight(world);
        boolean isStormy = world.hasStorm() || world.isThundering();
        return isNight && this.plugin.getConfigManager().isNightSkipAllowed() || isStormy && this.plugin.getConfigManager().isStormSkipAllowed();
    }

    private boolean isNight(World world) {
        long time = world.getTime();
        return time >= 12542L && time <= 23459L;
    }

    private boolean areRequirementsMet(World world) {
        int requiredVotes;
        WorldData worldData = this.worldDataMap.get(world.getUID());
        if (worldData == null) {
            return false;
        }
        int currentVotes = worldData.getVotes().size();
        return currentVotes >= (requiredVotes = this.getRequiredVotes(world));
    }

    private int getEligiblePlayerCount(World world) {
        return (int)world.getPlayers().stream().filter(p -> !this.isPlayerExempt((Player)p)).count();
    }

    private void updateBossBar(World world) {
        block39: {
            WorldData worldData;
            if (!this.plugin.getConfigManager().isBossBarEnabled()) {
                block38: {
                    BossBar existingBar = this.worldBossBars.remove(world.getUID());
                    if (existingBar != null) {
                        try {
                            existingBar.removeAll();
                        }
                        catch (Exception e) {
                            if (!this.plugin.getConfigManager().isDebugMode()) break block38;
                            this.plugin.getLogger().warning("Error removing disabled BossBar: " + e.getMessage());
                        }
                    }
                }
                return;
            }
            BossBar bossBar = this.worldBossBars.get(world.getUID());
            boolean needsRecreation = false;
            if (bossBar == null) {
                needsRecreation = true;
            } else {
                try {
                    BarColor currentColor = bossBar.getColor();
                    BarStyle currentStyle = bossBar.getStyle();
                    BarColor configColor = BarColor.valueOf((String)this.plugin.getConfigManager().getBossBarColor());
                    BarStyle configStyle = BarStyle.valueOf((String)this.plugin.getConfigManager().getBossBarStyle());
                    if (currentColor != configColor || currentStyle != configStyle) {
                        needsRecreation = true;
                        if (this.plugin.getConfigManager().isDebugMode()) {
                            this.plugin.getLogger().info("BossBar settings changed after reload, recreating for world " + world.getName());
                        }
                    }
                    bossBar.getTitle();
                    bossBar.getProgress();
                    bossBar.isVisible();
                }
                catch (IllegalArgumentException e) {
                    if (this.plugin.getConfigManager().isDebugMode()) {
                        this.plugin.getLogger().warning("Invalid BossBar configuration detected, using defaults: " + e.getMessage());
                    }
                    needsRecreation = true;
                }
                catch (Exception e) {
                    if (this.plugin.getConfigManager().isDebugMode()) {
                        this.plugin.getLogger().warning("BossBar corrupted for world " + world.getName() + ", recreating: " + e.getMessage());
                    }
                    needsRecreation = true;
                }
            }
            if (needsRecreation) {
                if (bossBar != null) {
                    try {
                        bossBar.removeAll();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.worldBossBars.remove(world.getUID());
                }
                try {
                    BarStyle barStyle;
                    BarColor barColor;
                    try {
                        barColor = BarColor.valueOf((String)this.plugin.getConfigManager().getBossBarColor());
                    }
                    catch (Exception e) {
                        this.plugin.getLogger().warning("Invalid boss bar color, using default BLUE");
                        barColor = BarColor.BLUE;
                    }
                    try {
                        barStyle = BarStyle.valueOf((String)this.plugin.getConfigManager().getBossBarStyle());
                    }
                    catch (Exception e) {
                        this.plugin.getLogger().warning("Invalid boss bar style, using default SOLID");
                        barStyle = BarStyle.SOLID;
                    }
                    bossBar = Bukkit.createBossBar((String)"", (BarColor)barColor, (BarStyle)barStyle, (BarFlag[])new BarFlag[0]);
                    this.worldBossBars.put(world.getUID(), bossBar);
                    if (this.plugin.getConfigManager().isDebugMode()) {
                        this.plugin.getLogger().info("Created new BossBar for world " + world.getName());
                    }
                }
                catch (Exception e) {
                    this.plugin.getLogger().severe("Failed to create BossBar for world " + world.getName() + ": " + e.getMessage());
                    return;
                }
            }
            if ((worldData = this.worldDataMap.get(world.getUID())) == null || worldData.getVotes().isEmpty()) {
                try {
                    bossBar.setVisible(false);
                    bossBar.removeAll();
                }
                catch (Exception e) {
                    if (this.plugin.getConfigManager().isDebugMode()) {
                        this.plugin.getLogger().warning("Error hiding BossBar: " + e.getMessage());
                    }
                    break block39;
                }
            }
            int currentVotes = worldData.getVotes().size();
            int requiredVotes = this.getRequiredVotes(world);
            try {
                String title = this.plugin.getMessageManager().getBossBarTitle(currentVotes, requiredVotes);
                bossBar.setTitle(title);
                bossBar.setProgress(Math.min((double)currentVotes / (double)requiredVotes, 1.0));
                bossBar.setVisible(true);
                HashSet bossBarPlayers = new HashSet(bossBar.getPlayers());
                HashSet worldPlayers = new HashSet(world.getPlayers());
                for (Player player : worldPlayers) {
                    if (bossBarPlayers.contains(player)) continue;
                    try {
                        bossBar.addPlayer(player);
                        if (!this.plugin.getConfigManager().isDebugMode()) continue;
                        this.plugin.getLogger().info("Added missing player " + player.getName() + " to BossBar");
                    }
                    catch (Exception e) {
                        if (!this.plugin.getConfigManager().isDebugMode()) continue;
                        this.plugin.getLogger().warning("Failed to add player " + player.getName() + " to BossBar: " + e.getMessage());
                    }
                }
                for (Player player : bossBarPlayers) {
                    if (worldPlayers.contains(player)) continue;
                    try {
                        bossBar.removePlayer(player);
                        if (!this.plugin.getConfigManager().isDebugMode()) continue;
                        this.plugin.getLogger().info("Removed player " + player.getName() + " from BossBar (not in world)");
                    }
                    catch (Exception e) {
                        if (!this.plugin.getConfigManager().isDebugMode()) continue;
                        this.plugin.getLogger().warning("Failed to remove player " + player.getName() + " from BossBar: " + e.getMessage());
                    }
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Error updating BossBar for world " + world.getName() + ": " + e.getMessage());
                this.worldBossBars.remove(world.getUID());
                try {
                    bossBar.removeAll();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void synchronizeBossBarSettings() {
        if (this.plugin.getConfigManager().isDebugMode()) {
            this.plugin.getLogger().info("Synchronizing BossBar settings after configuration reload...");
        }
        for (UUID worldUUID : new HashSet<UUID>(this.worldBossBars.keySet())) {
            World world = Bukkit.getWorld((UUID)worldUUID);
            if (world != null) {
                this.updateBossBar(world);
                continue;
            }
            BossBar bossBar = this.worldBossBars.remove(worldUUID);
            if (bossBar == null) continue;
            try {
                bossBar.removeAll();
            }
            catch (Exception exception) {}
        }
        if (this.plugin.getConfigManager().isDebugMode()) {
            this.plugin.getLogger().info("BossBar synchronization completed");
        }
    }

    private void sendVoteMessage(World world) {
        WorldData worldData = this.worldDataMap.get(world.getUID());
        if (worldData == null) {
            return;
        }
        int currentVotes = worldData.getVotes().size();
        int requiredVotes = this.getRequiredVotes(world);
        this.plugin.getMessageManager().sendWorldMessage(world, "vote-cast", Map.of("current", String.valueOf(currentVotes), "required", String.valueOf(requiredVotes), "remaining", String.valueOf(requiredVotes - currentVotes)));
    }

    private void playVoteEffects(World world, Player voter) {
        this.plugin.getEffectsManager().playVoteEffects(world, voter);
        if (this.plugin.getConfigManager().isActionBarEnabled()) {
            WorldData worldData = this.worldDataMap.get(world.getUID());
            if (worldData == null) {
                return;
            }
            int currentVotes = worldData.getVotes().size();
            int requiredVotes = this.getRequiredVotes(world);
            for (Player player : world.getPlayers()) {
                this.plugin.getMessageManager().sendActionBar(player, "vote-cast-actionbar", Map.of("player", voter.getName(), "current", String.valueOf(currentVotes), "required", String.valueOf(requiredVotes), "remaining", String.valueOf(requiredVotes - currentVotes)));
            }
        }
    }

    public void clearVotes(World world) {
        this.worldDataMap.remove(world.getUID());
        this.updateBossBar(world);
        this.cancelSkipTask(world);
        this.cancelVoteTimeoutTask(world);
        this.cancelNightCheckTask(world);
    }

    private void cancelSkipTask(World world) {
        BukkitTask task = this.skipTasks.remove(world.getUID());
        if (task != null && !task.isCancelled()) {
            task.cancel();
        }
    }

    private void cancelVoteTimeoutTask(World world) {
        BukkitTask task = this.voteTimeoutTasks.remove(world.getUID());
        if (task != null && !task.isCancelled()) {
            task.cancel();
        }
    }

    private void cancelNightCheckTask(World world) {
        BukkitTask task = this.nightCheckTasks.remove(world.getUID());
        if (task != null && !task.isCancelled()) {
            task.cancel();
        }
    }

    public WorldData getWorldData(World world) {
        return this.worldDataMap.get(world.getUID());
    }

    public boolean hasPlayerVoted(Player player) {
        WorldData data = this.worldDataMap.get(player.getWorld().getUID());
        return data != null && data.hasPlayerVoted(player.getUniqueId());
    }

    public int getCurrentVotes(World world) {
        WorldData data = this.worldDataMap.get(world.getUID());
        return data != null ? data.getVotes().size() : 0;
    }

    public int getRequiredVotes(World world) {
        int onlinePlayers = this.getEligiblePlayerCount(world);
        double percentage = this.plugin.getConfigManager().getVotePercentage(world);
        int required = (int)Math.ceil((double)onlinePlayers * percentage);
        int minimum = this.plugin.getConfigManager().getMinimumPlayers();
        int maximum = this.plugin.getConfigManager().getMaximumPlayers();
        required = Math.max(required, minimum);
        if (maximum > 0) {
            required = Math.min(required, maximum);
        }
        return Math.min(required, onlinePlayers);
    }

    public void forceSkip(World world, Player initiator) {
        if (!this.plugin.getConfigManager().isWorldEnabled(world)) {
            this.plugin.getMessageManager().sendMessage(initiator, "world-not-enabled");
            return;
        }
        if (this.plugin.getDawnAnimationManager().isAnimating(world)) {
            this.plugin.getMessageManager().sendMessage(initiator, "dawn-animation-active");
            return;
        }
        List<SleepVote> fakeVotes = List.of(new SleepVote(initiator.getUniqueId(), initiator.getName(), LocalDateTime.now(), initiator.getLocation()));
        this.performSkipActions(world, fakeVotes, true);
        this.plugin.getMessageManager().sendWorldMessage(world, "force-skip-by-admin", Map.of("admin", initiator.getName()));
    }

    public void handlePlayerJoin(Player player) {
        World world = player.getWorld();
        this.plugin.getPlatformAdapter().runTaskLater(() -> {
            this.updateBossBar(world);
            this.addPlayerToBossBar(world, player);
            if (this.plugin.getDawnAnimationManager() != null) {
                this.plugin.getDawnAnimationManager().handlePlayerJoin(player);
            }
        }, 20L);
    }

    public void handlePlayerQuit(Player player) {
        if (this.hasPlayerVoted(player)) {
            this.removeSleepVote(player);
        }
        if (this.plugin.getDawnAnimationManager() != null) {
            this.plugin.getDawnAnimationManager().handlePlayerQuit(player);
        }
    }

    public void handlePlayerChangeWorld(Player player, World fromWorld, World toWorld) {
        WorldData fromData = this.worldDataMap.get(fromWorld.getUID());
        if (fromData != null && fromData.hasPlayerVoted(player.getUniqueId())) {
            SleepVote vote = fromData.getVote(player.getUniqueId());
            fromData.removeVote(player.getUniqueId());
            SleepVoteRemovedEvent event = new SleepVoteRemovedEvent(player, fromWorld, vote);
            Bukkit.getPluginManager().callEvent((Event)event);
            this.updateBossBar(fromWorld);
        }
        this.addPlayerToBossBar(toWorld, player);
    }

    private void addPlayerToBossBar(World world, Player player) {
        BossBar bossBar = this.worldBossBars.get(world.getUID());
        if (bossBar != null && !bossBar.getPlayers().contains(player)) {
            bossBar.addPlayer(player);
        }
    }

    public void shutdown() {
        this.skipTasks.values().forEach(task -> {
            if (!task.isCancelled()) {
                task.cancel();
            }
        });
        this.voteTimeoutTasks.values().forEach(task -> {
            if (!task.isCancelled()) {
                task.cancel();
            }
        });
        this.nightCheckTasks.values().forEach(task -> {
            if (!task.isCancelled()) {
                task.cancel();
            }
        });
        this.worldBossBars.values().forEach(BossBar::removeAll);
        this.worldDataMap.clear();
        this.worldBossBars.clear();
        this.skipTasks.clear();
        this.voteTimeoutTasks.clear();
        this.nightCheckTasks.clear();
    }
}

