/*
 * Decompiled with CFR 0.152.
 */
package com.github.k1ritoz.vote2Sleep.platform;

import com.github.k1ritoz.vote2Sleep.Vote2Sleep;
import com.github.k1ritoz.vote2Sleep.platform.PlatformAdapter;
import java.lang.reflect.Method;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class FoliaAdapter
implements PlatformAdapter {
    private final Vote2Sleep plugin = Vote2Sleep.getInstance();

    @Override
    public String getPlatformName() {
        return "Folia";
    }

    @Override
    public boolean isVersionSupported() {
        return this.getMinecraftVersion() >= 1210;
    }

    @Override
    public BukkitTask runTaskLater(Runnable task, long delay) {
        try {
            Object scheduler = Bukkit.class.getMethod("getGlobalRegionScheduler", new Class[0]).invoke(null, new Object[0]);
            Object scheduledTask = scheduler.getClass().getMethod("runDelayed", Plugin.class, Consumer.class, Long.TYPE).invoke(scheduler, new Object[]{this.plugin, t -> {
                try {
                    task.run();
                }
                catch (Exception e) {
                    this.plugin.getLogger().warning("Error in Folia global task: " + e.getMessage());
                }
            }, delay});
            return new FoliaTaskWrapper(scheduledTask);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to schedule Folia global task, falling back to Bukkit scheduler: " + e.getMessage());
            return Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, task, delay);
        }
    }

    @Override
    public BukkitTask runTaskTimer(Runnable task, long delay, long period) {
        try {
            Object scheduler = Bukkit.class.getMethod("getGlobalRegionScheduler", new Class[0]).invoke(null, new Object[0]);
            Object scheduledTask = scheduler.getClass().getMethod("runAtFixedRate", Plugin.class, Consumer.class, Long.TYPE, Long.TYPE).invoke(scheduler, new Object[]{this.plugin, t -> {
                try {
                    task.run();
                }
                catch (Exception e) {
                    this.plugin.getLogger().warning("Error in Folia global timer task: " + e.getMessage());
                }
            }, delay, period});
            return new FoliaTaskWrapper(scheduledTask);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to schedule Folia global timer task, falling back to Bukkit scheduler: " + e.getMessage());
            return Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, task, delay, period);
        }
    }

    @Override
    public BukkitTask runTaskAsync(Runnable task) {
        try {
            Object scheduler = Bukkit.class.getMethod("getAsyncScheduler", new Class[0]).invoke(null, new Object[0]);
            Object scheduledTask = scheduler.getClass().getMethod("runNow", Plugin.class, Consumer.class).invoke(scheduler, new Object[]{this.plugin, t -> {
                try {
                    task.run();
                }
                catch (Exception e) {
                    this.plugin.getLogger().warning("Error in Folia async task: " + e.getMessage());
                }
            }});
            return new FoliaTaskWrapper(scheduledTask);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to schedule Folia async task, falling back to Bukkit scheduler: " + e.getMessage());
            return Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, task);
        }
    }

    @Override
    public BukkitTask runTaskLaterForWorld(World world, Consumer<World> task, long delay) {
        return this.runTaskLater(() -> task.accept(world), delay);
    }

    @Override
    public BukkitTask runTaskTimerForWorld(World world, Consumer<World> task, long delay, long period) {
        return this.runTaskTimer(() -> task.accept(world), delay, period);
    }

    public BukkitTask runTaskLaterForWorldRegion(World world, Consumer<World> task, long delay) {
        try {
            Object scheduler = Bukkit.class.getMethod("getRegionScheduler", new Class[0]).invoke(null, new Object[0]);
            int chunkX = world.getSpawnLocation().getBlockX() >> 4;
            int chunkZ = world.getSpawnLocation().getBlockZ() >> 4;
            Object scheduledTask = scheduler.getClass().getMethod("runDelayed", Plugin.class, World.class, Integer.TYPE, Integer.TYPE, Consumer.class, Long.TYPE).invoke(scheduler, new Object[]{this.plugin, world, chunkX, chunkZ, t -> {
                try {
                    task.accept(world);
                }
                catch (Exception e) {
                    this.plugin.getLogger().warning("Error in Folia world region task: " + e.getMessage());
                    e.printStackTrace();
                }
            }, delay});
            return new FoliaTaskWrapper(scheduledTask);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to schedule Folia world region task, falling back to global scheduler: " + e.getMessage());
            e.printStackTrace();
            return this.runTaskLater(() -> task.accept(world), delay);
        }
    }

    @Override
    public BukkitTask runTaskLaterForPlayer(Player player, Consumer<Player> task, long delay) {
        try {
            Object scheduler = player.getClass().getMethod("getScheduler", new Class[0]).invoke((Object)player, new Object[0]);
            Object scheduledTask = scheduler.getClass().getMethod("runDelayed", Plugin.class, Consumer.class, Runnable.class, Long.TYPE).invoke(scheduler, new Object[]{this.plugin, t -> {
                try {
                    if (player.isOnline()) {
                        task.accept(player);
                    }
                }
                catch (Exception e) {
                    this.plugin.getLogger().warning("Error in Folia player task: " + e.getMessage());
                }
            }, null, delay});
            return new FoliaTaskWrapper(scheduledTask);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to schedule Folia player task for " + player.getName() + ", falling back to global scheduler: " + e.getMessage());
            return this.runTaskLater(() -> {
                if (player.isOnline()) {
                    task.accept(player);
                }
            }, delay);
        }
    }

    @Override
    public double[] getTPS() {
        return new double[]{20.0, 20.0, 20.0};
    }

    @Override
    public boolean isAsyncSafe() {
        return false;
    }

    public BukkitTask runRegionSpecificEffects(World world, Consumer<World> effectsTask, long delay) {
        return this.runTaskLaterForWorldRegion(world, effectsTask, delay);
    }

    private int getMinecraftVersion() {
        String version = Bukkit.getBukkitVersion();
        String[] parts = version.split("-")[0].split("\\.");
        return Integer.parseInt(parts[1]) * 100 + (parts.length > 2 ? Integer.parseInt(parts[2]) : 0);
    }

    private static class FoliaTaskWrapper
    implements BukkitTask {
        private final Object scheduledTask;
        private volatile boolean cancelled = false;

        public FoliaTaskWrapper(Object scheduledTask) {
            this.scheduledTask = scheduledTask;
        }

        public int getTaskId() {
            return this.scheduledTask.hashCode();
        }

        public Plugin getOwner() {
            try {
                Method method = this.findMethod(this.scheduledTask.getClass(), "getOwningPlugin");
                if (method != null) {
                    method.setAccessible(true);
                    return (Plugin)method.invoke(this.scheduledTask, new Object[0]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return Vote2Sleep.getInstance();
        }

        public boolean isSync() {
            return true;
        }

        public boolean isCancelled() {
            if (this.cancelled) {
                return true;
            }
            try {
                Method method = this.findMethod(this.scheduledTask.getClass(), "isCancelled");
                if (method != null) {
                    method.setAccessible(true);
                    return (Boolean)method.invoke(this.scheduledTask, new Object[0]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this.cancelled;
        }

        public void cancel() {
            this.cancelled = true;
            try {
                Method method = this.findMethod(this.scheduledTask.getClass(), "cancel");
                if (method != null) {
                    method.setAccessible(true);
                    method.invoke(this.scheduledTask, new Object[0]);
                }
            }
            catch (Exception e) {
                Vote2Sleep.getInstance().getLogger().warning("Could not cancel Folia task: " + e.getMessage());
            }
        }

        private Method findMethod(Class<?> clazz, String methodName) {
            try {
                return clazz.getMethod(methodName, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                try {
                    return clazz.getDeclaredMethod(methodName, new Class[0]);
                }
                catch (NoSuchMethodException ex) {
                    Class<?> superClass = clazz.getSuperclass();
                    if (superClass != null && superClass != Object.class) {
                        return this.findMethod(superClass, methodName);
                    }
                    for (Class<?> iface : clazz.getInterfaces()) {
                        try {
                            return this.findMethod(iface, methodName);
                        }
                        catch (Exception exception) {
                        }
                    }
                    return null;
                }
            }
        }
    }
}

