/*
 * Decompiled with CFR 0.152.
 */
package com.github.k1ritoz.vote2Sleep.platform;

import com.github.k1ritoz.vote2Sleep.Vote2Sleep;
import com.github.k1ritoz.vote2Sleep.platform.PlatformAdapter;
import java.lang.reflect.Method;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class PurpurAdapter
implements PlatformAdapter {
    private final Vote2Sleep plugin = Vote2Sleep.getInstance();

    @Override
    public String getPlatformName() {
        return "Purpur";
    }

    @Override
    public boolean isVersionSupported() {
        return this.getMinecraftVersion() >= 1210;
    }

    @Override
    public BukkitTask runTaskLater(Runnable task, long delay) {
        return Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, task, delay);
    }

    @Override
    public BukkitTask runTaskTimer(Runnable task, long delay, long period) {
        return Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, task, delay, period);
    }

    @Override
    public BukkitTask runTaskAsync(Runnable task) {
        return Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, task);
    }

    @Override
    public BukkitTask runTaskLaterForWorld(World world, Consumer<World> task, long delay) {
        return Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> task.accept(world), delay);
    }

    @Override
    public BukkitTask runTaskTimerForWorld(World world, Consumer<World> task, long delay, long period) {
        return Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> task.accept(world), delay, period);
    }

    @Override
    public BukkitTask runTaskLaterForPlayer(Player player, Consumer<Player> task, long delay) {
        return Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> task.accept(player), delay);
    }

    @Override
    public double[] getTPS() {
        try {
            return this.getPurpurTPS();
        }
        catch (Exception e) {
            try {
                return Bukkit.getTPS();
            }
            catch (Exception ex) {
                return new double[]{20.0, 20.0, 20.0};
            }
        }
    }

    @Override
    public boolean isAsyncSafe() {
        return true;
    }

    private double[] getPurpurTPS() throws Exception {
        try {
            Class<?> purpurServerClass = Class.forName("org.purpurmc.purpur.PurpurServer");
            Method getTpsMethod = purpurServerClass.getMethod("getTPS", new Class[0]);
            Object tpsResult = getTpsMethod.invoke(null, new Object[0]);
            if (tpsResult instanceof double[]) {
                return (double[])tpsResult;
            }
        }
        catch (ClassNotFoundException e) {
            return Bukkit.getTPS();
        }
        return new double[]{20.0, 20.0, 20.0};
    }

    public void optimizePlayerOperation(Player player, Runnable operation) {
        try {
            Class<?> purpurPlayerClass = Class.forName("org.purpurmc.purpur.entity.PurpurPlayer");
            if (purpurPlayerClass.isInstance(player)) {
                Method optimizeMethod = purpurPlayerClass.getMethod("runOptimizedOperation", Runnable.class);
                optimizeMethod.invoke((Object)player, operation);
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        operation.run();
    }

    public boolean hasPurpurWorldOptimizations(World world) {
        try {
            Class<?> purpurWorldClass = Class.forName("org.purpurmc.purpur.world.PurpurWorld");
            return purpurWorldClass.isInstance(world);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public void setWorldTimeOptimized(World world, long time) {
        try {
            if (this.hasPurpurWorldOptimizations(world)) {
                Class<?> purpurWorldClass = Class.forName("org.purpurmc.purpur.world.PurpurWorld");
                Method optimizedSetTime = purpurWorldClass.getMethod("setTimeOptimized", Long.TYPE);
                optimizedSetTime.invoke((Object)world, time);
                return;
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to use Purpur optimized time setting: " + e.getMessage());
        }
        world.setTime(time);
    }

    public void clearWeatherOptimized(World world) {
        try {
            if (this.hasPurpurWorldOptimizations(world)) {
                Class<?> purpurWorldClass = Class.forName("org.purpurmc.purpur.world.PurpurWorld");
                Method optimizedClearWeather = purpurWorldClass.getMethod("clearWeatherOptimized", new Class[0]);
                optimizedClearWeather.invoke((Object)world, new Object[0]);
                return;
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to use Purpur optimized weather clearing: " + e.getMessage());
        }
        world.setStorm(false);
        world.setThundering(false);
    }

    public boolean hasAsyncChunkOptimizations() {
        try {
            Class.forName("org.purpurmc.purpur.chunk.AsyncChunkLoader");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private int getMinecraftVersion() {
        try {
            String version = Bukkit.getBukkitVersion();
            String[] parts = version.split("-")[0].split("\\.");
            return Integer.parseInt(parts[1]) * 100 + (parts.length > 2 ? Integer.parseInt(parts[2]) : 0);
        }
        catch (Exception e) {
            return 1210;
        }
    }
}

