/*
 * Decompiled with CFR 0.152.
 */
package com.github.k1ritoz.vote2Sleep.platform;

import com.github.k1ritoz.vote2Sleep.Vote2Sleep;
import com.github.k1ritoz.vote2Sleep.platform.PlatformAdapter;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class SpongeAdapter
implements PlatformAdapter {
    private final Vote2Sleep plugin = Vote2Sleep.getInstance();

    @Override
    public String getPlatformName() {
        return "Sponge";
    }

    @Override
    public boolean isVersionSupported() {
        return this.getMinecraftVersion() >= 1210;
    }

    @Override
    public BukkitTask runTaskLater(Runnable task, long delay) {
        return Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, task, delay);
    }

    @Override
    public BukkitTask runTaskTimer(Runnable task, long delay, long period) {
        return Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, task, delay, period);
    }

    @Override
    public BukkitTask runTaskAsync(Runnable task) {
        return Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, task);
    }

    @Override
    public BukkitTask runTaskLaterForWorld(World world, Consumer<World> task, long delay) {
        return Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> task.accept(world), delay);
    }

    @Override
    public BukkitTask runTaskTimerForWorld(World world, Consumer<World> task, long delay, long period) {
        return Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> task.accept(world), delay, period);
    }

    @Override
    public BukkitTask runTaskLaterForPlayer(Player player, Consumer<Player> task, long delay) {
        return Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> task.accept(player), delay);
    }

    @Override
    public double[] getTPS() {
        try {
            return Bukkit.getTPS();
        }
        catch (Exception e) {
            return new double[]{20.0, 20.0, 20.0};
        }
    }

    @Override
    public boolean isAsyncSafe() {
        return true;
    }

    private int getMinecraftVersion() {
        String version = Bukkit.getBukkitVersion();
        String[] parts = version.split("-")[0].split("\\.");
        return Integer.parseInt(parts[1]) * 100 + (parts.length > 2 ? Integer.parseInt(parts[2]) : 0);
    }
}

